# hl7.fhir.cz.lab#0.5.0: HL7 CZ Laboratory IG

## Pages

* [Home](index.md)
* [Background](background-en.md)
* [Scope and content](scope-and-content-en.md)
* [Background](background-cs.md)
* [Oblasti a obsah](scope-and-content-cs.md)
* [Use cases](use-cases-en.md)
* [Obligations](obligations-en.md)
* [Logical models](logical-models-en.md)
* [Authors](authors-en.md)
* [Obligations](obligations-cs.md)
* [Datová sada - logické modely](logical-models-cs.md)
* [Závislosti](dependencies-cs.md)
* [Download](downloads-en.md)
* [Příklady](examples-cs.md)
* [Autorská práva](copyright-cs.md)
* [Workflow](workflow-en.md)
* [Terminologické aspekty](terminology-considerations-cs.md)
* [Copyright](copyright-en.md)
* [Download](downloads-cs.md)
* [Mapování logického modelu](model-map-cs.md)
* [Workflow](workflow-cs.md)
* [Examples](examples-en.md)
* [Autoři](authors-cs.md)
* [Dependencies](dependencies-en.md)
* [Artifacts Summary](artifacts.md)
* [Terminology considerations](terminology-considerations-en.md)
* [Příklady užití](use-cases-cs.md)
* [Model maps](model-map-en.md)

## Resources

### ValueSets

* [ValueSet - Clinically Relevant Time](ValueSet-cz-lab-clinically-relevant-time-VS.md)
* [Laboratory Container Types (CZ)](ValueSet-cz-lab-container-types-VS.md)
* [Laboratory Report Types (CZ)](ValueSet-cz-lab-report-types-VS.md)
* [Laboratory Speciality Types (CZ)](ValueSet-cz-lab-speciality-types-VS.md)
* [Laboratory Study Types (CZ)](ValueSet-cz-lab-study-types-VS.md)
* [Laboratory Techniques](ValueSet-cz-lab-technique-vs.md)
* [Národní číselník laboratorních položek](ValueSet-cz-nclp-labpol-vs.md)

### Logicals

* [A.4 - Additional attachments](StructureDefinition-AttachmentsCz.md)
* [A.1.5 - Author](StructureDefinition-AuthorCz.md)
* [A.1.9 - Electronic signatures](StructureDefinition-ElectronicSignatures.md)
* [A - Laboratory Report](StructureDefinition-LabReportCz.md)
* [A.1.7 - Legal authenticator](StructureDefinition-LegalAuthenticatorCz.md)
* [A.4 - Additional attachments](StructureDefinition-LogAttachmentsCz.md)
* [A.1.5 - Autor dokumentu](StructureDefinition-LogAuthorCz.md)
* [A.1.9 - Electronic signatures](StructureDefinition-LogElectronicSignatures.md)
* [A - Laboratorní zpráva](StructureDefinition-LogLabReportCz.md)
* [A.1.7 - Zodpovídá](StructureDefinition-LogLegalAuthenticatorCz.md)
* [A.2.1, A.2.2 - Objednávka](StructureDefinition-LogOrderCz.md)
* [A.1.3 - Preferované systémy](StructureDefinition-LogPayerCz.md)
* [A.3 - Presented form](StructureDefinition-LogPresentedFormCz.md)
* [A.1.4 - Příjemce dokumentu](StructureDefinition-LogRecipientCz.md)
* [A.2.4 - Datové elementy výsledku vyšetření](StructureDefinition-LogResultCz.md)
* [A.2.3 - Informace o vzorku](StructureDefinition-LogSpecimenLabCz.md)
* [A.1.1, A1.2 - Pacient](StructureDefinition-LogSubjectCz.md)
* [A.1.6 - Ověřil](StructureDefinition-LogValidatorCz.md)
* [A.2.1, A.2.2 - Order](StructureDefinition-OrderCz.md)
* [A.1.3 - Health insurance and payment information](StructureDefinition-PayerCz.md)
* [A.3 - Presented form](StructureDefinition-PresentedFormCz.md)
* [A.1.4 - Information recipient](StructureDefinition-RecipientCz.md)
* [A.2.4 - Results data elements](StructureDefinition-ResultCz.md)
* [A.2.3 - Specimen information](StructureDefinition-SpecimenLabCz.md)
* [A.1.1, A1.2 - Subject of care](StructureDefinition-SubjectCz.md)
* [A.1.6 - Result validator](StructureDefinition-ValidatorCz.md)

### Complex-type Profiles

* [Address: Obligations](StructureDefinition-cz-address-obl-lab.md)

### Resource Profiles

* [Attachment: Obligations](StructureDefinition-cz-attachment-obl-lab.md)
* [Attachment: Lab Report (CZ)](StructureDefinition-cz-attachment.md)
* [Bundle - Laboratory Result Report](StructureDefinition-cz-bundle-lab.md)
* [Bundle: Obligations](StructureDefinition-cz-bundle-obl-lab.md)
* [Composition: Laboratory Report](StructureDefinition-cz-composition-lab-report.md)
* [Composition: Obligations](StructureDefinition-cz-composition-obl-lab.md)
* [Coverage: Obligations](StructureDefinition-cz-coverage-obl-lab.md)
* [DiagnosticReport: Laboratory Report](StructureDefinition-cz-diagnostic-report-lab.md)
* [Diagnostic Report: Obligations](StructureDefinition-cz-diagnosticReport-obl-lab.md)
* [DocumentReference: Obligations](StructureDefinition-cz-documentReference-obl-lab.md)
* [Encounter: Obligations](StructureDefinition-cz-encounter-obl-lab.md)
* [Observation Laboratory (CZ)](StructureDefinition-cz-observation-result-laboratory.md)
* [Observation: Obligations](StructureDefinition-cz-observationResult-obl-lab.md)
* [Organization: Obligations](StructureDefinition-cz-organization-obl-lab.md)
* [Patient: Obligations](StructureDefinition-cz-patient-obl-lab.md)
* [Patient Animal: Obligations](StructureDefinition-cz-patientAnimal-obl-lab.md)
* [Practitioner: Obligations](StructureDefinition-cz-practitioner-obl-lab.md)
* [Practitioner Role: Obligations](StructureDefinition-cz-practitionerRole-obl-img.md)
* [Related Person: Obligations](StructureDefinition-cz-relatedPerson-obl-img.md)
* [ServiceRequest: Laboratory Order](StructureDefinition-cz-service-request-lab.md)
* [Service Request: Obligations](StructureDefinition-cz-serviceRequest-obl-lab.md)
* [Specimen Laboratory (CZ)](StructureDefinition-cz-specimen-lab.md)
* [Specimen: Obligations](StructureDefinition-cz-specimen-obl-lab.md)

### Extensions

* [Document DiagnosticReport Reference](StructureDefinition-composition-DiagnosticReportReference.md)
* [Document Based On Order](StructureDefinition-composition-based-on-order-or-requisition.md)
* [ExtNote (CZ)](StructureDefinition-cz-ext-note.md)
* [Extension - Clinically Relevant Time](StructureDefinition-cz-lab-clinically-relevant-time.md)
* [Information recipient](StructureDefinition-information-recipient.md)

### ConceptMaps

* [CZ Attachment Model to this guide Map](ConceptMap-AttachmentImagingReport2FHIR-cz.md)
* [DiagnosticReport to Composition status](ConceptMap-ConceptMap-cz-diagRptStatus2CompStatus.md)
* [eHN Author to this guide Map](ConceptMap-author2FHIR-cz-lab.md)
* [eHN Lab Report to this guide Map](ConceptMap-labRpt2FHIR-cz-lab.md)
* [eHN Recipient to this guide Map](ConceptMap-legalAuth2FHIR-cz-lab.md)
* [eHN Order to this guide Map](ConceptMap-order2FHIR-cz-lab.md)
* [eHN Payer to this guide Map](ConceptMap-payer2FHIR-cz-lab.md)
* [eHN Recipient to this guide Map](ConceptMap-recipient2FHIR-cz-lab.md)
* [eHN Result to this guide Map](ConceptMap-result2FHIR-cz-lab.md)
* [eHN Specimen to this guide Map](ConceptMap-specimen2FHIR-cz-lab.md)
* [eHN Subject to this guide Map](ConceptMap-subject2FHIR-cz-lab.md)
* [eHN Validator to this guide Map](ConceptMap-validator2FHIR-cz-lab.md)

### ImplementationGuides

* [HL7 CZ Laboratory IG](index.md)

### Examples

* [CZ-LabReport-Bundle-Example-Complex (Bundle)](Bundle-CZ-LabReport-Bundle-Example-Complex.md)
* [CZ-LabReport-Bundle-Example-L1 (Bundle)](Bundle-CZ-LabReport-Bundle-Example-L1.md)
* [CZ-LabReport-Bundle-Example-Min (Bundle)](Bundle-CZ-LabReport-Bundle-Example-Min.md)
* [CZ-LabReport-Bundle-Example-ObsTypes (Bundle)](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md)
* [CZ-LabReport-Bundle-Example-kn (Bundle)](Bundle-CZ-LabReport-Bundle-Example-kn.md)
* [CZ-LabReport-Bundle-Example (Bundle)](Bundle-CZ-LabReport-Bundle-Example.md)
* [b4e1a7f0-93f3-4d86-a3b1-7d15e42b12f8 (Coverage)](Coverage-b4e1a7f0-93f3-4d86-a3b1-7d15e42b12f8.md)
* [device-analyzer-urea (Device)](Device-device-analyzer-urea.md)
* [device-kit-urea (Device)](Device-device-kit-urea.md)
* [4d2447db-6692-40cd-a440-7544d48caa08 (Encounter)](Encounter-4d2447db-6692-40cd-a440-7544d48caa08.md)
* [2fb0c9d4-7e12-47a6-9a3b-1c5e8d2f4a76 (Observation)](Observation-2fb0c9d4-7e12-47a6-9a3b-1c5e8d2f4a76.md)
* [5c3e9a12-4f7b-41d0-86a2-9b7e4d2f1c08 (Observation)](Observation-5c3e9a12-4f7b-41d0-86a2-9b7e4d2f1c08.md)
* [5f3b0d47-2c3c-4c54-97f1-0bb8cc3e4e4f (Observation)](Observation-5f3b0d47-2c3c-4c54-97f1-0bb8cc3e4e4f.md)
* [8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3 (Observation)](Observation-8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3.md)
* [b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56 (Observation)](Observation-b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56.md)
* [d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35 (Observation)](Observation-d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35.md)
* [Ordinace MUDr. Kvida Polštáře (Organization)](Organization-RegisteringProviderExample.md)
* [Nemocnice Žlábek Dolní (Organization)](Organization-bc2b8a3e-999a-4f10-91ce-1dc12fa0e123.md)
* [Všeobecná zdravotní pojišťovna ČR (Organization)](Organization-d7a9324a-6d45-420a-bd8d-0a2c66e8e40c.md)
* [3f2a1b9e-6d4f-4c2e-9a7b-2d8f0b3e1c9a (Patient)](Patient-3f2a1b9e-6d4f-4c2e-9a7b-2d8f0b3e1c9a.md)
* [c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c (Patient)](Patient-c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c.md)
* [aabbccdd-1111-4222-9333-ffeeddccbbcc (Practitioner)](Practitioner-aabbccdd-1111-4222-9333-ffeeddccbbcc.md)
* [c2a7b9de-3b44-4e6f-9e51-9a1b8f1c82f4 (Practitioner)](Practitioner-c2a7b9de-3b44-4e6f-9e51-9a1b8f1c82f4.md)
* [fab321ab-7777-4444-cccc-abcdefabcdef (Practitioner)](Practitioner-fab321ab-7777-4444-cccc-abcdefabcdef.md)
* [3e4f8b7c-9a25-49cf-8b2a-2a8f1e7f3d66 (PractitionerRole)](PractitionerRole-3e4f8b7c-9a25-49cf-8b2a-2a8f1e7f3d66.md)
* [aabbccdd-2222-3333-dddd-112233445566 (PractitionerRole)](PractitionerRole-aabbccdd-2222-3333-dddd-112233445566.md)
* [ff223344-5566-4777-8899-ccbbccddeeff (PractitionerRole)](PractitionerRole-ff223344-5566-4777-8899-ccbbccddeeff.md)
* [5f9c2e8d-0b74-4dbb-8af3-3e6d2c1191a7 (ServiceRequest)](ServiceRequest-5f9c2e8d-0b74-4dbb-8af3-3e6d2c1191a7.md)
* [4c7a1d2f-89b3-41e5-a6f2-3b9d7c5e0a21 (Specimen)](Specimen-4c7a1d2f-89b3-41e5-a6f2-3b9d7c5e0a21.md)
* [6e2c1f9a-54b7-4d3e-82a1-7c4f9e2b0d85 (Specimen)](Specimen-6e2c1f9a-54b7-4d3e-82a1-7c4f9e2b0d85.md)
* [92f1c7b5-3a4e-4d8f-97c2-1b6e0f8d2a43 (Specimen)](Specimen-92f1c7b5-3a4e-4d8f-97c2-1b6e0f8d2a43.md)
* [fa3d8c2e-71b4-4e9c-9d2f-85b0a1f7c934 (Specimen)](Specimen-fa3d8c2e-71b4-4e9c-9d2f-85b0a1f7c934.md)
