# Information recipient - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Information recipient**

## Extension: Information recipient 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/StructureDefinition/information-recipient | *Version*:0.5.0 |
| Draft as of 2025-12-10 | *Computable Name*:InformationRecipient |

This extension applies to the Composition resource and is used to represent an intended recipient of the composition.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Composition: Laboratory Report](StructureDefinition-cz-composition-lab-report.md), [Composition (EU core) [WIP]](https://build.fhir.org/ig/hl7-eu/base/StructureDefinition-composition-eu-core.html) and [Composition: Laboratory Report](https://build.fhir.org/ig/hl7-eu/laboratory/StructureDefinition-Composition-eu-lab.html)
* Examples for this Extension: [Bundle/CZ-LabReport-Bundle-Example-L1](Bundle-CZ-LabReport-Bundle-Example-L1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/information-recipient)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-information-recipient.csv), [Excel](StructureDefinition-information-recipient.xlsx), [Schematron](StructureDefinition-information-recipient.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "information-recipient",
  "url" : "http://hl7.eu/fhir/StructureDefinition/information-recipient",
  "version" : "0.5.0",
  "name" : "InformationRecipient",
  "title" : "Information recipient",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "This extension applies to the Composition resource and is used to represent an intended recipient of the composition.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Composition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Information recipient",
        "definition" : "This extension applies to the Composition resource and is used to represent an intended recipient of the composition."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/StructureDefinition/information-recipient"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      }
    ]
  }
}

```
