# Extension - Clinically Relevant Time - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Extension - Clinically Relevant Time**

## Extension: Extension - Clinically Relevant Time 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/cz-lab-clinically-relevant-time | *Version*:0.5.0 |
| Draft as of 2025-12-10 | *Computable Name*:CZ_LabClinicallyRelevantTime |

Clinically Relevant Time Code

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Observation Laboratory (CZ)](StructureDefinition-cz-observation-result-laboratory.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/cz-lab-clinically-relevant-time)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-lab-clinically-relevant-time.csv), [Excel](StructureDefinition-cz-lab-clinically-relevant-time.xlsx), [Schematron](StructureDefinition-cz-lab-clinically-relevant-time.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-lab-clinically-relevant-time",
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-lab-clinically-relevant-time",
  "version" : "0.5.0",
  "name" : "CZ_LabClinicallyRelevantTime",
  "title" : "Extension - Clinically Relevant Time",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Clinically Relevant Time Code",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "fhirpath",
      "expression" : "Observation.effective.ofType(dateTime)"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Extension - Clinically Relevant Time",
        "definition" : "Clinically Relevant Time Code"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-lab-clinically-relevant-time"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/lab/ValueSet/cz-lab-clinically-relevant-time-VS"
        }
      },
      {
        "id" : "Extension.value[x].system",
        "path" : "Extension.value[x].system",
        "min" : 1
      },
      {
        "id" : "Extension.value[x].code",
        "path" : "Extension.value[x].code",
        "min" : 1
      }
    ]
  }
}

```
