# Document Based On Order - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Document Based On Order**

## Extension: Document Based On Order 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/composition-based-on-order-or-requisition | *Version*:0.5.0 |
| Draft as of 2025-12-10 | *Computable Name*:CompositionBasedOnOrderOrRequisition |

This extension provides a link to the order [(Reference(ServiceRequest)] or requisition [ServiceRequest.requisition (i.e., 'Request.groupIdentifier')] that this report document is based on and fulfills.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Composition: Laboratory Report](StructureDefinition-cz-composition-lab-report.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/composition-based-on-order-or-requisition)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-composition-based-on-order-or-requisition.csv), [Excel](StructureDefinition-composition-based-on-order-or-requisition.xlsx), [Schematron](StructureDefinition-composition-based-on-order-or-requisition.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "composition-based-on-order-or-requisition",
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/composition-based-on-order-or-requisition",
  "version" : "0.5.0",
  "name" : "CompositionBasedOnOrderOrRequisition",
  "title" : "Document Based On Order",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "This extension provides a link to the order [(Reference(ServiceRequest)] or requisition [ServiceRequest.requisition (i.e., 'Request.groupIdentifier')] that this report document is based on and fulfills.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Composition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Document Based On Order",
        "definition" : "This extension provides a link to the order [(Reference(ServiceRequest)] or requisition [ServiceRequest.requisition (i.e., 'Request.groupIdentifier')] that this report document is based on and fulfills."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://hl7.cz/fhir/lab/StructureDefinition/composition-based-on-order-or-requisition"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Identifier"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-service-request-lab"
            ]
          }
        ]
      }
    ]
  }
}

```
