# A.1.6 - Result validator - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.6 - Result validator**

## Logical Model: A.1.6 - Result validator 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/ValidatorCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnValidatorLabEhnCz |

 
Result validator. Section A1.6 of the eHN guideline. 

**Usages:**

* Use this Logical Model: [A - Laboratory Report](StructureDefinition-LabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/ValidatorCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ValidatorCz.csv), [Excel](StructureDefinition-ValidatorCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ValidatorCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/ValidatorCz",
  "version" : "0.5.0",
  "name" : "LogEnValidatorLabEhnCz",
  "title" : "A.1.6 - Result validator",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Result validator. Section A1.6 of the eHN guideline.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/ValidatorCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ValidatorCz",
        "path" : "ValidatorCz",
        "short" : "A.1.6 - Result validator",
        "definition" : "Result validator. Section A1.6 of the eHN guideline."
      },
      {
        "id" : "ValidatorCz.identifier",
        "path" : "ValidatorCz.identifier",
        "short" : "A.1.6.1 Result validator identifier",
        "definition" : "The health professional identification number who verified the document. Either an internal identifier assign by a healthcare provider institution or (preferably) a national health professional ID such as the license or registration number. The person certifying the document shall be mentioned only if he is different from the author of the document. In the case of a discharge report, this is the attending physician who had the patient under his/her care in the discharging ward.  ",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "ValidatorCz.name",
        "path" : "ValidatorCz.name",
        "short" : "A.1.6.2 Result validator name",
        "definition" : "Full name and identification details of the person who verified the document.  ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "ValidatorCz.organizationIdentifier",
        "path" : "ValidatorCz.organizationIdentifier",
        "short" : "A.1.6.3 Result validator organisation identifier",
        "definition" : "Identifier of the organisation that the verifier represents.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "ValidatorCz.organization",
        "path" : "ValidatorCz.organization",
        "short" : "A.1.6.4 Result validator organisation",
        "definition" : "The name and identification details of the healthcare facility represented by the person who verified the document.  ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "ValidatorCz.dateTime",
        "path" : "ValidatorCz.dateTime",
        "short" : "A.1.6.5 Validation date and time",
        "definition" : "Date and time when the document was validated. ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
