# A.1.6 - Ověřil - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.6 - Ověřil**

## Logical Model: A.1.6 - Ověřil 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LogValidatorCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzValidatorLabEhnCz |

 
Ověřil 

**Usages:**

* Use this Logical Model: [A - Laboratorní zpráva](StructureDefinition-LogLabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LogValidatorCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogValidatorCz.csv), [Excel](StructureDefinition-LogValidatorCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogValidatorCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LogValidatorCz",
  "version" : "0.5.0",
  "name" : "LogCzValidatorLabEhnCz",
  "title" : "A.1.6 - Ověřil",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Ověřil",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LogValidatorCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogValidatorCz",
        "path" : "LogValidatorCz",
        "short" : "A.1.6 - Ověřil",
        "definition" : "Ověřil"
      },
      {
        "id" : "LogValidatorCz.id",
        "path" : "LogValidatorCz.id",
        "short" : "A.1.6.1 Identifikátor ověřovatele",
        "definition" : "Identifikační číslo zdravotnického pracovníka, který ověřil dokument. Buď interní identifikátor přidělený institucí poskytovatele zdravotní péče, nebo (nejlépe) národní ID zdravotnického pracovníka, jako je číslo licence nebo registrační číslo. Osoba ověřující dokument se uvádí pouze pokud je odlišná od autora dokumentu. V případě propouštěcí zprávy jde o ošetřujícího lékaře, který měl pacienta v péči na propouštějícím oddělení.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogValidatorCz.jmeno",
        "path" : "LogValidatorCz.jmeno",
        "short" : "A.1.6.2 Jméno ověřovatele",
        "definition" : "Plné jméno a identifikační údaje osoby, která dokument ověřila",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogValidatorCz.idOrganizace",
        "path" : "LogValidatorCz.idOrganizace",
        "short" : "A.1.6.3 ID organizace",
        "definition" : "Identifikátor organizace, kterou ověřovatel reprezentuje",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogValidatorCz.organizace",
        "path" : "LogValidatorCz.organizace",
        "short" : "A.1.6.4 Organizace ověřovatele",
        "definition" : "Název a identifikační údaje zdravotnického zařízení které je reprezentováno osobou, která dokument ověřila.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "LogValidatorCz.datumAcas",
        "path" : "LogValidatorCz.datumAcas",
        "short" : "A.1.6.5 Datum a čas ověření",
        "definition" : "Datum a čas ověření dokumentu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
