# A.1.1, A1.2 - Pacient - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.1, A1.2 - Pacient**

## Logical Model: A.1.1, A1.2 - Pacient 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LogSubjectCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzSubjectLabEhnCz |

 
Pacient 

**Usages:**

* Use this Logical Model: [A - Laboratorní zpráva](StructureDefinition-LogLabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LogSubjectCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogSubjectCz.csv), [Excel](StructureDefinition-LogSubjectCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogSubjectCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LogSubjectCz",
  "version" : "0.5.0",
  "name" : "LogCzSubjectLabEhnCz",
  "title" : "A.1.1, A1.2 - Pacient",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Pacient",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LogSubjectCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogSubjectCz",
        "path" : "LogSubjectCz",
        "short" : "A.1.1, A1.2 - Pacient",
        "definition" : "Pacient"
      },
      {
        "id" : "LogSubjectCz.identifikace",
        "path" : "LogSubjectCz.identifikace",
        "short" : "A.1.1 Identifikace pacienta",
        "definition" : "A.1.1 Identifikace pacienta",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.identifikace.jmeno",
        "path" : "LogSubjectCz.identifikace.jmeno",
        "short" : "A.1.1.1 Křestní jméno",
        "definition" : "Křestní jméno",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.identifikace.prijmeni",
        "path" : "LogSubjectCz.identifikace.prijmeni",
        "short" : "A.1.1.2 Příjmení",
        "definition" : "Příjmení",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.identifikace.datumNarozeni",
        "path" : "LogSubjectCz.identifikace.datumNarozeni",
        "short" : "A.1.1.3 Datum narození",
        "definition" : "Datum, případně i čas narození\n- Preferované systémy: ISO 8601 ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.identifikace.id",
        "path" : "LogSubjectCz.identifikace.id",
        "short" : "A.1.1.4 Identifikátor pacienta",
        "definition" : "Typ identifikátoru a identifikátor osoby. Identifikátor musí být unikátní v rámci daného typu identifikátoru. Povinné je zadání alespoň jednoho národního či mezinárodního identifikátoru (rodné číslo, číslo pasu apod.)",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.identifikace.statniObcanstvi",
        "path" : "LogSubjectCz.identifikace.statniObcanstvi",
        "short" : "A.1.1.5 Státní občanství",
        "definition" : "Státní občanství dle zákona 186/2013. Státní občanství, jak je uváděno na oficiálních dokladech k prokázání identity.\n- Preferované systémy: eHDSICountry (ISO 3166)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.identifikace.pohlavi",
        "path" : "LogSubjectCz.identifikace.pohlavi",
        "short" : "A.1.1.6 Úřední pohlaví",
        "definition" : "Úřední/administrativní pohlaví (pohlaví uváděné v dokladech pro úřední účely). Biologické pohlaví pacienta, které může být odlišné od pohlaví administrativního může být vedeno v jiných částech zdravotnické dokumentace.\n- Preferované systémy: HL7 Administrative Gender ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.identifikace.komunikacniJazyk",
        "path" : "LogSubjectCz.identifikace.komunikacniJazyk",
        "short" : "A.1.1.7 Komunikační jazyk",
        "definition" : "Jazyk (jazyky) v nichž pacient komunikuje\n- Preferované systémy: NCLP EJAZYK",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt",
        "path" : "LogSubjectCz.kontakt",
        "short" : "A.1.2 Kontaktní informace pacienta",
        "definition" : "A.1.2 Kontaktní informace pacienta",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.adresa",
        "path" : "LogSubjectCz.kontakt.adresa",
        "short" : "A.1.2.1 Adresa",
        "definition" : "Poštovní, domácí a/nebo kancelářské adresa. Adresy jsou vždy sekvence částí adresy (např. řádek adresy, země, PSČ, město), i když se formát poštovní adresy může lišit v závislosti na zemi. Adresa může obsahovat informaci o typu adresy; pokud tento atribut není přítomen, předpokládá se, že jde o výchozí adresu použitelnou pro jakýkoli účel.\n- Preferované systémy:  eHDSICountry (ISO 3166)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.kontakt",
        "path" : "LogSubjectCz.kontakt.kontakt",
        "short" : "A.1.2.2 Telekomunikační kontakt (e-mail, telefon atp.).",
        "definition" : "Telekomunikační kontakt (e-mail, telefon atp.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar",
        "short" : "A.1.2.3 Preferovaný lékař",
        "definition" : "Registrující praktický lékař, případně jiný lékař, který může poskytovat informace o pacientovi. Zvláště potřebné u pacientů s vzácným onemocněním.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar.id",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar.id",
        "short" : "A.1.2.3.1 Identifikátor zdravotnického pracovníka v NR-ZP",
        "definition" : "Identifikační číslo zdravotnického pracovníka dle Národního registru zdravotnických pracovníků. ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar.jmeno",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar.jmeno",
        "short" : "A.1.2.3.2 Jméno lékaře",
        "definition" : "Jméno lékaře, u kterého je pacient v péči, nebo který pacienta eviduje.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar.specializace",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar.specializace",
        "short" : "A.1.2.3.3 Specializace lékaře",
        "definition" : "Specializace lékaře (Praktické lékařství pro děti a dorost, Praktické lékařství pro dospělé, interní lékařství, gynekologie a porodnictví a pod.)\n- Preferované systémy: NR-ZP Specializace lékařů",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar.idAnazevPoskytovatele",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar.idAnazevPoskytovatele",
        "short" : "A.1.2.3.4 ID a název poskytovatele",
        "definition" : "Identifikátor (IČO, NRPZS) a název poskytovatele, kterého lékař reprezentuje",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar.adresaPoskytovatele",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar.adresaPoskytovatele",
        "short" : "A.1.2.3.5 Adresa poskytovatele",
        "definition" : "Poštovní, domácí a/nebo kancelářské adresa. Adresy jsou vždy sekvence částí adresy (např. řádek adresy, země, PSČ, město), i když se formát poštovní adresy může lišit v závislosti na zemi. Adresa může obsahovat informaci o typu adresy; pokud tento atribut není přítomen, předpokládá se, že jde o výchozí adresu použitelnou pro jakýkoli účel.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar.kontakt",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar.kontakt",
        "short" : "A.1.2.3.6 Telekomunikační kontakt (e-mail, telefon atp.).",
        "definition" : "Telekomunikační kontakt (e-mail, telefon atp.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.legalRepresent",
        "path" : "LogSubjectCz.kontakt.legalRepresent",
        "short" : "A.1.2.4 Zákonní zástupci a další kontaktní osoby",
        "definition" : "A.1.2.4 Zákonní zástupci a další kontaktní osoby",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.legalRepresent.typ",
        "path" : "LogSubjectCz.kontakt.legalRepresent.typ",
        "short" : "A.1.2.4.1 Typ kontaktu",
        "definition" : "Typ kontaktní osoby rozlišující emergentní kontakty, zákonné zástupce a ostatní osoby se vztahem k pacientovi.\n- Preferované systémy: HL7 Role",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.legalRepresent.vztahKpacientovi",
        "path" : "LogSubjectCz.kontakt.legalRepresent.vztahKpacientovi",
        "short" : "A.1.2.4.2 Vztah k pacientovi",
        "definition" : "Vztah osoby k pacientovi (otec, syn, dcera atp.)\n- Preferované systémy: eHDSIPersonalRelationship",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.legalRepresent.id",
        "path" : "LogSubjectCz.kontakt.legalRepresent.id",
        "short" : "A.1.2.4.3 Id osoby",
        "definition" : "Typ identifikátoru a identifikátor osoby. Identifikátor musí být unikátní v rámci daného typu identifikátoru. Povinné je zadání alespoň jednoho národního či mezinárodního identifikátoru (rodné číslo, číslo pasu apod.)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.legalRepresent.jmeno",
        "path" : "LogSubjectCz.kontakt.legalRepresent.jmeno",
        "short" : "A.1.2.4.4 Křestní jméno",
        "definition" : "Křestní jméno",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.legalRepresent.prijmeni",
        "path" : "LogSubjectCz.kontakt.legalRepresent.prijmeni",
        "short" : "A.1.2.4.5 Příjmení",
        "definition" : "Příjmení",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.legalRepresent.adresa",
        "path" : "LogSubjectCz.kontakt.legalRepresent.adresa",
        "short" : "A.1.2.4.6 Adresa kontaktní osoby",
        "definition" : "Poštovní, domácí a/nebo kancelářské adresa. Adresy jsou vždy sekvence částí adresy (např. řádek adresy, země, PSČ, město), i když se formát poštovní adresy může lišit v závislosti na zemi. Adresa může obsahovat informaci o typu adresy; pokud tento atribut není přítomen, předpokládá se, že jde o výchozí adresu použitelnou pro jakýkoli účel.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.legalRepresent.kontakt",
        "path" : "LogSubjectCz.kontakt.legalRepresent.kontakt",
        "short" : "A.1.2.4.7 Telekomunikační kontakt (e-mail, telefon atp.).",
        "definition" : "Telekomunikační kontakt (e-mail, telefon atp.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      }
    ]
  }
}

```
