# A.2.3 - Informace o vzorku - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.3 - Informace o vzorku**

## Logical Model: A.2.3 - Informace o vzorku 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LogSpecimenLabCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzSpecimenLabEhnCz |

 
Informace o vzorku 

**Usages:**

* Use this Logical Model: [A - Laboratorní zpráva](StructureDefinition-LogLabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LogSpecimenLabCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogSpecimenLabCz.csv), [Excel](StructureDefinition-LogSpecimenLabCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogSpecimenLabCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LogSpecimenLabCz",
  "version" : "0.5.0",
  "name" : "LogCzSpecimenLabEhnCz",
  "title" : "A.2.3 - Informace o vzorku",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Informace o vzorku",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LogSpecimenLabCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogSpecimenLabCz",
        "path" : "LogSpecimenLabCz",
        "short" : "A.2.3 - Informace o vzorku",
        "definition" : "Informace o vzorku"
      },
      {
        "id" : "LogSpecimenLabCz.id",
        "path" : "LogSpecimenLabCz.id",
        "short" : "A.2.3.1 ID vzorku",
        "definition" : "Identifikátor vzorku, který je jedinečný v rozsahu zvoleného rámce. Například: identifikátor přidělený objednávkovým systémem, identifikátor přidělený laboratoří apod. Možné je použití více identifikátorů.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogSpecimenLabCz.druhVzorku",
        "path" : "LogSpecimenLabCz.druhVzorku",
        "short" : "A.2.3.2 Biologický druh",
        "definition" : "Biologický druh - týká se vzorků odebraných nikoliv přímo pacientovi, ale subjektu s pacientem souvisejícím.\n- Preferované systémy: SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSpecimenLabCz.material",
        "path" : "LogSpecimenLabCz.material",
        "short" : "A.2.3.3 Materiál",
        "definition" : "Materiál vzorku.\n- Preferované systémy: SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSpecimenLabCz.dobaSberu",
        "path" : "LogSpecimenLabCz.dobaSberu",
        "short" : "A.2.3.4 Doba sběru",
        "definition" : "Datum, čas odběru nebo doba sběru (začátek a ukončení sběru) materiálu.\n- Preferované systémy: ISO 8601",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogSpecimenLabCz.anatomickeUmisteni",
        "path" : "LogSpecimenLabCz.anatomickeUmisteni",
        "short" : "A.2.3.5 Anatomické umístění",
        "definition" : "Anatomické umístění (umístění v rámci těla, lateralita) odkud je materiál odebrán, například 'levý loket'.\n- Preferované systémy: SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSpecimenLabCz.morfologie",
        "path" : "LogSpecimenLabCz.morfologie",
        "short" : "A.2.3.6 Morfologie",
        "definition" : "Morfologické abnormality anatomického umístění odkud je materiál odebrán, například rána nebo vřed. \n- Preferované systémy: SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSpecimenLabCz.zdrojMaterialu",
        "path" : "LogSpecimenLabCz.zdrojMaterialu",
        "short" : "A.2.3.7 Zdroj materiálu",
        "definition" : "V případě, že není materiál odebrán přímo z pacienta, ale pochází z předmětu, který s pacientem souvisí (například katetr).\n- Preferované systémy: SNOMED CT\n- Preferované systémy: EMDN",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSpecimenLabCz.procedura",
        "path" : "LogSpecimenLabCz.procedura",
        "short" : "A.2.3.8 Procedura / metoda sběru",
        "definition" : "Metoda sběru vzorku - pro případy, kdy je to pro výsledky relevantní. \n- Preferované systémy: SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSpecimenLabCz.datumPrijeti",
        "path" : "LogSpecimenLabCz.datumPrijeti",
        "short" : "A.2.3.9 Datum přijetí",
        "definition" : "Datum a čas převzetí materiálu laboratoří.\n- Preferované systémy: ISO 8601",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
