# A.1.4 - Příjemce dokumentu - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.4 - Příjemce dokumentu**

## Logical Model: A.1.4 - Příjemce dokumentu 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LogRecipientCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzRecipientLabEhnCz |

 
Informace o zamýšleném příjemci dokumentu 

**Usages:**

* Use this Logical Model: [A - Laboratorní zpráva](StructureDefinition-LogLabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LogRecipientCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogRecipientCz.csv), [Excel](StructureDefinition-LogRecipientCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogRecipientCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LogRecipientCz",
  "version" : "0.5.0",
  "name" : "LogCzRecipientLabEhnCz",
  "title" : "A.1.4 - Příjemce dokumentu",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Informace o zamýšleném příjemci dokumentu",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LogRecipientCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogRecipientCz",
        "path" : "LogRecipientCz",
        "short" : "A.1.4 - Příjemce dokumentu",
        "definition" : "Informace o zamýšleném příjemci dokumentu"
      },
      {
        "id" : "LogRecipientCz.id",
        "path" : "LogRecipientCz.id",
        "short" : "A.1.4.1 ID příjemce",
        "definition" : "Identifikační číslo zdravotnického pracovníka. Buď interní identifikátor přidělený institucí poskytovatele zdravotní péče, nebo (nejlépe) národní ID zdravotnického pracovníka, jako je číslo licence nebo registrační číslo. V případě, kdy příjemcem není zdravotnický pracovník, např. pacient, měl by být použit vhodný osobní identifikátor.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogRecipientCz.jmeno",
        "path" : "LogRecipientCz.jmeno",
        "short" : "A.1.4.2 Jméno příjemce",
        "definition" : "Jméno a příjmení osoby příjemce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogRecipientCz.idOrganizace",
        "path" : "LogRecipientCz.idOrganizace",
        "short" : "A.1.4.3 ID organizace příjemce",
        "definition" : "Identifikátor organizace příjemce dle NRPZS nebo IČO.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogRecipientCz.organizace",
        "path" : "LogRecipientCz.organizace",
        "short" : "A.1.4.4 Organizace příjemce",
        "definition" : "Název a identifikační údaje zdravotnického zařízení příjemce, případně také pracoviště příjemce",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      }
    ]
  }
}

```
