# A.1.7 - Zodpovídá - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.7 - Zodpovídá**

## Logical Model: A.1.7 - Zodpovídá 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LogLegalAuthenticatorCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzLegalAuthenticatorLabEhnCz |

 
Zodpovídá 

**Usages:**

* Use this Logical Model: [A - Laboratorní zpráva](StructureDefinition-LogLabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LogLegalAuthenticatorCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogLegalAuthenticatorCz.csv), [Excel](StructureDefinition-LogLegalAuthenticatorCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogLegalAuthenticatorCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LogLegalAuthenticatorCz",
  "version" : "0.5.0",
  "name" : "LogCzLegalAuthenticatorLabEhnCz",
  "title" : "A.1.7 - Zodpovídá",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Zodpovídá",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LogLegalAuthenticatorCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogLegalAuthenticatorCz",
        "path" : "LogLegalAuthenticatorCz",
        "short" : "A.1.7 - Zodpovídá",
        "definition" : "Zodpovídá"
      },
      {
        "id" : "LogLegalAuthenticatorCz.id",
        "path" : "LogLegalAuthenticatorCz.id",
        "short" : "A.1.7.1 Zodpovídá - ID",
        "definition" : "Identifikační číslo zdravotnického pracovníka, který zodpovídá za celkový obsah dokumentu. Buď interní identifikátor přidělený institucí poskytovatele zdravotní péče, nebo (nejlépe) národní ID zdravotnického pracovníka, jako je číslo licence nebo registrační číslo. Primář či vedoucí oddělení, který zodpovídá za propouštěcí zprávu jako celek. Může být totožný s ověřujícím pracovníkem.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogLegalAuthenticatorCz.jmeno",
        "path" : "LogLegalAuthenticatorCz.jmeno",
        "short" : "A.1.7.2 Zodpovídá - jméno osoby",
        "definition" : "Plné jméno a identifikační údaje osoby, která zodpovídá za obsah dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogLegalAuthenticatorCz.organizace",
        "path" : "LogLegalAuthenticatorCz.organizace",
        "short" : "A.1.7.3 Zodpovídá - organizace",
        "definition" : "Název a identifikační údaje zdravotnického zařízení které je reprezentováno osobou, která zodpovídá za obsah dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "LogLegalAuthenticatorCz.datumAcas",
        "path" : "LogLegalAuthenticatorCz.datumAcas",
        "short" : "A.1.7.4 Datum a čas autorizace",
        "definition" : "Datum a čas autorizace dokumentu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
