# A - Laboratory Report - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A - Laboratory Report**

## Logical Model: A - Laboratory Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LabReportCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnLabReportEhnCz |

 
Laboratory Report. eHN guideline model. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LabReportCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LabReportCz.csv), [Excel](StructureDefinition-LabReportCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LabReportCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LabReportCz",
  "version" : "0.5.0",
  "name" : "LogEnLabReportEhnCz",
  "title" : "A - Laboratory Report",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Laboratory Report. eHN guideline model.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LabReportCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LabReportCz",
        "path" : "LabReportCz",
        "short" : "A - Laboratory Report",
        "definition" : "Laboratory Report. eHN guideline model."
      },
      {
        "id" : "LabReportCz.header",
        "path" : "LabReportCz.header",
        "short" : "A.1 Report header data elements",
        "definition" : "A.1 Report header data elements",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.subject",
        "path" : "LabReportCz.header.subject",
        "short" : "A.1.1 - A1.2 Patient/subject",
        "definition" : "A.1.1 Identification of the patient/subject and A.1.2 Patient/subject related contact information  ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/SubjectCz"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.payer",
        "path" : "LabReportCz.header.payer",
        "short" : "A.1.3 Health insurance and payment information",
        "definition" : "A.1.3 Health insurance and payment information",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/PayerCz"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.informationRecipient",
        "path" : "LabReportCz.header.informationRecipient",
        "short" : "A.1.4 Information recipient",
        "definition" : "A.1.4 Information recipient (intended recipient or recipients of the report, additional recipients might be identified by the ordering party, e.g. GP, other specialist), if applicable",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/RecipientCz"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.author",
        "path" : "LabReportCz.header.author",
        "short" : "A.1.5 Author",
        "definition" : "A.1.5 Author of the document according to Act 372/2011 §54 (3)",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/AuthorCz"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.validator",
        "path" : "LabReportCz.header.validator",
        "short" : "A.1.6 Result validator",
        "definition" : "A.1.7 Result validator",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/ValidatorCz"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.legalAuthenticator",
        "path" : "LabReportCz.header.legalAuthenticator",
        "short" : "A.1.7 Legal authenticator",
        "definition" : "A.1.7 Legal authenticator (The person taking responsibility for the medical content of the document)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/LegalAuthenticatorCz"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.metadata",
        "path" : "LabReportCz.header.metadata",
        "short" : "A.1.8 Laboratory report metadata",
        "definition" : "A.1.8 Laboratory report metadata",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.metadata.documentId",
        "path" : "LabReportCz.header.metadata.documentId",
        "short" : "A.1.8.1 Document Id",
        "definition" : "Unique identifier of the document",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.metadata.type",
        "path" : "LabReportCz.header.metadata.type",
        "short" : "A.1.8.2 Document type",
        "definition" : "Category of the document. \n- Preferred system(s): LOINC",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.metadata.status",
        "path" : "LabReportCz.header.metadata.status",
        "short" : "A.1.8.3 Document status",
        "definition" : "The status of the laboratory test result report. E.g., preliminary, final. \n- Preferred system(s): hl7:DiagnosticReportStatus",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.metadata.dateTime",
        "path" : "LabReportCz.header.metadata.dateTime",
        "short" : "A.1.8.4 Report date and time",
        "definition" : "Date and time of the result report creation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.metadata.title",
        "path" : "LabReportCz.header.metadata.title",
        "short" : "A.1.8.5 Document title",
        "definition" : "Document title, fixed value 'Laboratory Result report'",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.metadata.custodian",
        "path" : "LabReportCz.header.metadata.custodian",
        "short" : "A.1.8.6 Report custodian",
        "definition" : "Name and identification of the entity that manages the document. Alias of the technical administrator of the document.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "LabReportCz.header.metadata.confidentiality",
        "path" : "LabReportCz.header.metadata.confidentiality",
        "short" : "A.1.8.7 Confidentiality",
        "definition" : "Level of confidentiality of the document. Implicit value is normal. \n- Preferred system(s): hl7:Confidentiality",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.metadata.language",
        "path" : "LabReportCz.header.metadata.language",
        "short" : "A.1.8.8 Language",
        "definition" : "Language in which the document is written.\n- Preferred system(s):  NCLP EJAZYK",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.metadata.version",
        "path" : "LabReportCz.header.metadata.version",
        "short" : "A.1.8.9 Version",
        "definition" : "Version of the document.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LabReportCz.header.electronicSignatures",
        "path" : "LabReportCz.header.electronicSignatures",
        "short" : "A.1.9 Electronic signatures",
        "definition" : "Electronic signatures According to Act No. 327/2011, §54a.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LabReportCz.body",
        "path" : "LabReportCz.body",
        "short" : "A.2 Report body data elements",
        "definition" : "A.2 Report body data elements",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LabReportCz.body.order",
        "path" : "LabReportCz.body.order",
        "short" : "A.2.1-A.2.2 Order",
        "definition" : "A.2.1 Order information (Laboratory Result Report could respond to multiple test orders)\nA.2.2 Order reason (Laboratory Result Report could respond to multiple reasons)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/OrderCz"
          }
        ]
      },
      {
        "id" : "LabReportCz.body.specimen",
        "path" : "LabReportCz.body.specimen",
        "short" : "A.2.3 Specimen information",
        "definition" : "A.2.3 Specimen information",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/SpecimenLabCz"
          }
        ]
      },
      {
        "id" : "LabReportCz.body.result",
        "path" : "LabReportCz.body.result",
        "short" : "A.2.4 Results data elements",
        "definition" : "A.2.4 Results data elements",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/ResultCz"
          }
        ]
      },
      {
        "id" : "LabReportCz.presentedForm",
        "path" : "LabReportCz.presentedForm",
        "short" : "A.3 - Presented Form",
        "definition" : "Entire report as issued. Various formats could be provided,  pdf format is recommended.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/PresentedFormCz"
          }
        ]
      },
      {
        "id" : "LabReportCz.attachments",
        "path" : "LabReportCz.attachments",
        "short" : "A.4 - Attachments",
        "definition" : "Aditional attachment",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/AttachmentsCz"
          }
        ]
      }
    ]
  }
}

```
