# Example Laboratory Order - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example Laboratory Order**

## Example ServiceRequest: Example Laboratory Order

Profile: [ServiceRequest: Laboratory Order](StructureDefinition-cz-service-request-lab.md)

**identifier**: `https://example.org/lab-orders`/ORD-20250623-1234

**requisition**: `https://example.org/composite-id`/REQ-20250623-4567

**status**: Active

**intent**: Order

**category**: Laboratory procedure

**priority**: Urgent

**code**: 01898

**subject**: [Zyrgana Prouzdalová Female, DoB: 1982-03-17 ( Passport number (use: official, ))](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md#urn-uuid-c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c)

**authoredOn**: 2025-04-24

**requester**: [Practitioner Karel Franc](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md#urn-uuid-c2a7b9de-3b44-4e6f-9e51-9a1b8f1c82f4)

**insurance**: [Coverage: identifier = https://ncez.mzcr.cz/fhir/sid/rc#8203171234 (use: official, ); status = active](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md#urn-uuid-b4e1a7f0-93f3-4d86-a3b1-7d15e42b12f8)

**specimen**: [Specimen: type = Whole blood; receivedTime = 2025-04-24 07:30:00+0200](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md#urn-uuid-6e2c1f9a-54b7-4d3e-82a1-7c4f9e2b0d85)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "5f9c2e8d-0b74-4dbb-8af3-3e6d2c1191a7",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/lab/StructureDefinition/cz-service-request-lab"
    ]
  },
  "identifier" : [
    {
      "system" : "https://example.org/lab-orders",
      "value" : "ORD-20250623-1234"
    }
  ],
  "requisition" : {
    "system" : "https://example.org/composite-id",
    "value" : "REQ-20250623-4567"
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "108252007",
          "display" : "Laboratory procedure"
        }
      ]
    }
  ],
  "priority" : "urgent",
  "code" : {
    "coding" : [
      {
        "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
        "code" : "01898"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c"
  },
  "authoredOn" : "2025-04-24",
  "requester" : {
    "reference" : "urn:uuid:c2a7b9de-3b44-4e6f-9e51-9a1b8f1c82f4"
  },
  "insurance" : [
    {
      "reference" : "urn:uuid:b4e1a7f0-93f3-4d86-a3b1-7d15e42b12f8"
    }
  ],
  "specimen" : [
    {
      "reference" : "urn:uuid:6e2c1f9a-54b7-4d3e-82a1-7c4f9e2b0d85"
    }
  ]
}

```
