# eHN Order to this guide Map - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Order to this guide Map**

## ConceptMap: eHN Order to this guide Map (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ConceptMap/order2FHIR-cz-lab | *Version*:0.5.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:Order2Fhir |

 
eHN Order to this guide Map 

 
It shows how the Order data set defined by the EU eHN guidelines is mapped into this guide 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "order2FHIR-cz-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/ConceptMap/order2FHIR-cz-lab",
  "version" : "0.5.0",
  "name" : "Order2Fhir",
  "title" : "eHN Order to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "eHN Order to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "It shows how the Order data set defined by the EU eHN guidelines is mapped into this guide",
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/OrderCz",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-service-request-lab",
      "element" : [
        {
          "code" : "Order.orderDetails",
          "display" : "A.2.1 Order information",
          "target" : [
            {
              "code" : "ServiceRequest",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Order.orderDetails.identifier",
          "display" : "A.2.1.1 Order Id",
          "target" : [
            {
              "code" : "ServiceRequest.identifier",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Order.orderDetails.identifier",
          "display" : "A.2.1.1 Order Id",
          "target" : [
            {
              "code" : "ServiceRequest.requisition",
              "equivalence" : "relatedto",
              "comment" : "if the Composite Request ID."
            }
          ]
        },
        {
          "code" : "Order.orderDetails.dateTime",
          "display" : "A.2.1.2 Order date and time",
          "target" : [
            {
              "code" : "ServiceRequest.authoredOn",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Order.orderDetails.orderPlacerIdentifier",
          "display" : "A.2.1.3 Order placer identifier",
          "target" : [
            {
              "code" : "ServiceRequest.requester.identifier",
              "equivalence" : "relatedto",
              "comment" : "if the Composite Request ID."
            }
          ]
        },
        {
          "code" : "Order.orderDetails.orderPlacerName",
          "display" : "A.2.1.4 Order placer name",
          "target" : [
            {
              "code" : "ServiceRequest.requester.name",
              "equivalence" : "relatedto",
              "comment" : "requester.resolve().ofType(Practitioner).name"
            }
          ]
        },
        {
          "code" : "Order.orderDetails.orderPlacerName",
          "display" : "A.2.1.4 Order placer name",
          "target" : [
            {
              "code" : "ServiceRequest.requester.Practitioner.name",
              "equivalence" : "relatedto",
              "comment" : "requester.resolve().ofType(PractitionerRole).Practitioner.resolve().name"
            }
          ]
        },
        {
          "code" : "Order.orderDetails.orderPlacerContacts",
          "display" : "A.2.1.5 Order placer contact details",
          "target" : [
            {
              "code" : "ServiceRequest.requester.telecom",
              "equivalence" : "relatedto",
              "comment" : "requester.resolve().ofType(Practitioner).telecom"
            }
          ]
        },
        {
          "code" : "Order.orderDetails.orderPlacerContacts",
          "display" : "A.2.1.5 Order placer contact details",
          "target" : [
            {
              "code" : "ServiceRequest.requester.address",
              "equivalence" : "relatedto",
              "comment" : "requester.resolve().ofType(Practitioner).address"
            }
          ]
        },
        {
          "code" : "Order.orderDetails.orderPlacerContacts",
          "display" : "A.2.1.5 Order placer contact details",
          "target" : [
            {
              "code" : "ServiceRequest.requester.telecom",
              "equivalence" : "relatedto",
              "comment" : "requester.resolve().ofType(PractitionerRole).telecom"
            }
          ]
        },
        {
          "code" : "Order.orderDetails.orderPlacerOrganization",
          "display" : "A.2.1.6 Order placer organization",
          "target" : [
            {
              "code" : "ServiceRequest.requester.organization",
              "equivalence" : "equivalent",
              "comment" : "requester.resolve().ofType(PractitionerRole).organization.resolve()"
            }
          ]
        },
        {
          "code" : "Order.reason",
          "display" : "A.2.2 Order reason",
          "target" : [
            {
              "code" : "ServiceRequest.reasonCode",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Order.reason",
          "display" : "A.2.2 Order reason",
          "target" : [
            {
              "code" : "ServiceRequest.reasonReference",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Order.reason.code",
          "display" : "A.2.2.1 Problem / diagnosis / condition description",
          "target" : [
            {
              "code" : "ServiceRequest.reasonCode",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
