# Terminology considerations - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* **Terminology considerations**

## Terminology considerations

List of the codesystems and valueset used:

### MKN-10 / Orphacode

| | | |
| :--- | :--- | :--- |
| A.2.2.1 | Problem / diagnosis / condition description |   |

### Snomed-CT

| | | |
| :--- | :--- | :--- |
| A.2.3.2 | Species | SNOMED CT [TypeOfSpeciesCodelist] |
| A.2.3.3 | Material | SNOMED CT [SpecimenMaterialCodelist] |
| A.2.3.5 | Anatomic location | SNOMED CT [BodyLocation] |
| A.2.3.6 | Morphology | SNOMED CT [MorfologyCodelist] |
| A.2.3.7 | Source device | SNOMED CT |
| A.2.3.8 | Procedure | SNOMED CT [CollectionMethodCodelist] |

| | | |
| :--- | :--- | :--- |
| A.2.4.2.3 | Observation name | SNOMED CT |
| A.2.4.2.4 | Observation method | SNOMED CT |
| A.2.4.2.11 | Observation result | SNOMED CT |
| A.2.4.2.12 | Observation interpretation | SNOMED CT |

### FHIR

| | | |
| :--- | :--- | :--- |
| A.1.1.5 | Nationality | https://terminology.hl7.org/4.0.0/ValueSet-v3-Country2.html |
| A.1.1.6 | Gender | https://terminology.hl7.org/4.0.0/ValueSet-v3-AdministrativeGender.html |
| A.1.2.1 | Address | https://terminology.hl7.org/4.0.0/ValueSet-v3-Country2.html |
| A.1.2.4.1 | Type of contact | http://terminology.hl7.org/CodeSystem/v3-RoleClas |
| A.1.8.2 | Document category | http://hl7.org/fhir/ValueSet/referenced-item-category |
| A.1.8.3 | Document status | https://www.hl7.org/fhir/valueset-diagnostic-report-status.html |
| A.1.8.7 | Document confidentiality | https://terminology.hl7.org/ValueSet-v3-Confidentiality.html |

### DASTA

| | | |
| :--- | :--- | :--- |
| A.1.1.7 | Language | EJAZYK |
| A.1.8.8 | Language | EJAZYK |

### MVC

| | | |
| :--- | :--- | :--- |
| A.1.1.5 | Language | eHDSICountry |
| A.1.2.1 | Language | eHDSICountry |
| A.1.2.4.2 | Personal Relationship | eHDSIPersonalRelationship |

### NČLP

| | | |
| :--- | :--- | :--- |
| A.2.4.2.2 | Observation code | NCLPPOL |

