# Laboratory Container Types (CZ) - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Laboratory Container Types (CZ)**

## ValueSet: Laboratory Container Types (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ValueSet/cz-lab-container-types-VS | *Version*:0.5.0 |
| Active as of 2022-08-11 | *Computable Name*:CZ_LabContainerTypesVS |

 
Laboratory Container Types ValueSet 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-lab-container-types-VS",
  "language" : "cs-CZ",
  "url" : "https://hl7.cz/fhir/lab/ValueSet/cz-lab-container-types-VS",
  "version" : "0.5.0",
  "name" : "CZ_LabContainerTypesVS",
  "title" : "Laboratory Container Types (CZ)",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-08-11",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Laboratory Container Types ValueSet",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "702279008",
            "display" : "Evacuated blood collection tube, gel separator"
          },
          {
            "code" : "702283008",
            "display" : "Non-evacuated blood collection tube with gel separator"
          },
          {
            "code" : "733479001",
            "display" : "Adhesive slide"
          },
          {
            "code" : "702297000",
            "display" : "Non-evacuated blood collection tube, clot activator"
          },
          {
            "code" : "767384004",
            "display" : "Evacuated blood collection tube with clot activator"
          },
          {
            "code" : "702295008",
            "display" : "Non-evacuated blood collection tube, clot activator/gel separator"
          },
          {
            "code" : "702278000",
            "display" : "Evacuated blood collection tube, no additive/metal-free"
          },
          {
            "code" : "702228002",
            "display" : "Inoculating loop"
          },
          {
            "code" : "767382000",
            "display" : "Evacuated blood collection tube with heparin sodium"
          },
          {
            "code" : "702284002",
            "display" : "Non-evacuated blood collection tube, lithium heparin"
          },
          {
            "code" : "702296009",
            "display" : "Non-evacuated blood collection tube, sodium citrate"
          },
          {
            "code" : "702282003",
            "display" : "Non-evacuated blood collection tube, EDTA"
          },
          {
            "code" : "702299002",
            "display" : "Non-evacuated blood collection tube, K2EDTA"
          },
          {
            "code" : "702298005",
            "display" : "Non-evacuated blood collection tube, K3EDTA"
          },
          {
            "code" : "702287009",
            "display" : "Non-evacuated blood collection tube, potassium oxalate/sodium fluoride"
          },
          {
            "code" : "702286000",
            "display" : "Non-evacuated blood collection tube, NaEDTA/sodium fluoride"
          },
          {
            "code" : "706054001",
            "display" : "Urine specimen container"
          },
          {
            "code" : "702244006",
            "display" : "Sterile urine specimen container"
          },
          {
            "code" : "702264001",
            "display" : "Non-sterile urine specimen container"
          },
          {
            "code" : "702303007",
            "display" : "Evacuated urine specimen container, multiple preservative"
          },
          {
            "code" : "706053007",
            "display" : "General specimen container"
          },
          {
            "code" : "767385003",
            "display" : "Aerobic blood culture bottle"
          },
          {
            "code" : "767383005",
            "display" : "Anaerobic blood culture bottle"
          },
          {
            "code" : "706047007",
            "display" : "Fecal specimen container"
          },
          {
            "code" : "702223006",
            "display" : "Sputum specimen container"
          },
          {
            "code" : "408098004",
            "display" : "Swab"
          },
          {
            "code" : "463609005",
            "display" : "Oral care swab, sterile"
          },
          {
            "code" : "464025007",
            "display" : "Oral care swab, non-sterile"
          },
          {
            "code" : "702269006",
            "display" : "General specimen container, no additive, sterile"
          },
          {
            "code" : "767387006",
            "display" : "Evacuated blood collection tube with citrate and theophylline and adenosine and dipyramidole"
          },
          {
            "code" : "706055000",
            "display" : "24-hour urine specimen container"
          },
          {
            "code" : "767390000",
            "display" : "Evacuated blood collection tube with heparin lithium and gel separator"
          },
          {
            "code" : "767660003",
            "display" : "Evacuated blood collection tube with sodium fluoride"
          },
          {
            "code" : "702280006",
            "display" : "Evacuated blood collection tube, RNA stabiliser"
          },
          {
            "code" : "706048002",
            "display" : "Blood specimen receptacle"
          }
        ]
      }
    ]
  }
}

```
