# ValueSet - Clinically Relevant Time - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ValueSet - Clinically Relevant Time**

## ValueSet: ValueSet - Clinically Relevant Time 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ValueSet/cz-lab-clinically-relevant-time-VS | *Version*:0.5.0 |
| Active as of 2025-12-10 | *Computable Name*:CZ_LabClinicallyRelevantTimeVS |

 
Codes of the clinically relevant times 

 **References** 

* [Extension - Clinically Relevant Time](StructureDefinition-cz-lab-clinically-relevant-time.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-lab-clinically-relevant-time-VS",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "https://hl7.cz/fhir/lab/ValueSet/cz-lab-clinically-relevant-time-VS",
  "version" : "0.5.0",
  "name" : "CZ_LabClinicallyRelevantTimeVS",
  "title" : "ValueSet - Clinically Relevant Time",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Codes of the clinically relevant times",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "399445004",
            "display" : "Specimen collection date (observable entity)"
          },
          {
            "code" : "281271004",
            "display" : "Date sample received in laboratory (observable entity)"
          }
        ]
      }
    ]
  }
}

```
