# Specimen Laboratory (CZ) - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Specimen Laboratory (CZ)**

## Resource Profile: Specimen Laboratory (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_SpecimenLab |

 
Czech profile for a specimen in a laboratory report. In some laboratory reports, specimen information is allowed to be minimal as many informations concerning the specimen are implied by the observations done. 

**Usages:**

* Derived from this Profile: [Specimen: Obligations](StructureDefinition-cz-specimen-obl-lab.md)
* Use this Profile: [Bundle - Laboratory Result Report](StructureDefinition-cz-bundle-lab.md)
* Refer to this Profile: [Attachment: Lab Report (CZ)](StructureDefinition-cz-attachment.md), [DiagnosticReport: Laboratory Report](StructureDefinition-cz-diagnostic-report-lab.md), [Observation Laboratory (CZ)](StructureDefinition-cz-observation-result-laboratory.md) and [ServiceRequest: Laboratory Order](StructureDefinition-cz-service-request-lab.md)
* Examples for this Profile: [Specimen/4c7a1d2f-89b3-41e5-a6f2-3b9d7c5e0a21](Specimen-4c7a1d2f-89b3-41e5-a6f2-3b9d7c5e0a21.md), [Specimen/6e2c1f9a-54b7-4d3e-82a1-7c4f9e2b0d85](Specimen-6e2c1f9a-54b7-4d3e-82a1-7c4f9e2b0d85.md), [Specimen/92f1c7b5-3a4e-4d8f-97c2-1b6e0f8d2a43](Specimen-92f1c7b5-3a4e-4d8f-97c2-1b6e0f8d2a43.md) and [Specimen/fa3d8c2e-71b4-4e9c-9d2f-85b0a1f7c934](Specimen-fa3d8c2e-71b4-4e9c-9d2f-85b0a1f7c934.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/cz-specimen-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-specimen-lab.csv), [Excel](StructureDefinition-cz-specimen-lab.xlsx), [Schematron](StructureDefinition-cz-specimen-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-specimen-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/laboratory/StructureDefinition/Specimen-eu-lab"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab",
  "version" : "0.5.0",
  "name" : "CZ_SpecimenLab",
  "title" : "Specimen Laboratory (CZ)",
  "status" : "draft",
  "date" : "2022-09-27T14:58:00+01:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Czech profile for a specimen in a laboratory report. In some laboratory reports, specimen information is allowed to be minimal as many informations concerning the specimen are implied by the observations done.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Specimen",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-specimen",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Specimen.request",
        "path" : "Specimen.request",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-service-request-lab"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.collection",
        "path" : "Specimen.collection",
        "mustSupport" : true
      },
      {
        "id" : "Specimen.container",
        "path" : "Specimen.container",
        "mustSupport" : true
      },
      {
        "id" : "Specimen.container.identifier",
        "path" : "Specimen.container.identifier",
        "mustSupport" : true
      },
      {
        "id" : "Specimen.container.type",
        "path" : "Specimen.container.type",
        "mustSupport" : true
      }
    ]
  }
}

```
