# Diagnostic Report: Obligations - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Diagnostic Report: Obligations**

## Resource Profile: Diagnostic Report: Obligations 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnosticReport-obl-lab | *Version*:0.5.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_DiagnosticReportObligationsLab |

 
This profile defines obligations for a diagnostic report in FHIR for the purpose of this guide. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/cz-diagnosticReport-obl-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-diagnosticReport-obl-lab.csv), [Excel](StructureDefinition-cz-diagnosticReport-obl-lab.xlsx), [Schematron](StructureDefinition-cz-diagnosticReport-obl-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-diagnosticReport-obl-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/laboratory/StructureDefinition/DiagnosticReport-eu-lab"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnosticReport-obl-lab",
  "version" : "0.5.0",
  "name" : "CZ_DiagnosticReportObligationsLab",
  "title" : "Diagnostic Report: Obligations",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "This profile defines obligations for a diagnostic report in FHIR for the purpose of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DiagnosticReport",
  "baseDefinition" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnostic-report-lab",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DiagnosticReport",
        "path" : "DiagnosticReport"
      },
      {
        "id" : "DiagnosticReport.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.text"
      },
      {
        "id" : "DiagnosticReport.status",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.status"
      },
      {
        "id" : "DiagnosticReport.category",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.category"
      },
      {
        "id" : "DiagnosticReport.code",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.code"
      },
      {
        "id" : "DiagnosticReport.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.subject"
      },
      {
        "id" : "DiagnosticReport.effective[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "DiagnosticReport.effective[x]:effectiveDateTime",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.effective[x]",
        "sliceName" : "effectiveDateTime",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DiagnosticReport.issued",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.issued"
      },
      {
        "id" : "DiagnosticReport.performer",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.performer"
      },
      {
        "id" : "DiagnosticReport.specimen",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.specimen"
      },
      {
        "id" : "DiagnosticReport.result",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.result"
      },
      {
        "id" : "DiagnosticReport.media",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.media"
      },
      {
        "id" : "DiagnosticReport.conclusion",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.conclusion"
      },
      {
        "id" : "DiagnosticReport.conclusionCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.conclusionCode"
      },
      {
        "id" : "DiagnosticReport.presentedForm",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DiagnosticReport.presentedForm"
      }
    ]
  }
}

```
