# Attachment: Lab Report (CZ) - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Attachment: Lab Report (CZ)**

## Resource Profile: Attachment: Lab Report (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/cz-attachment | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_Attachment |

 
Czech profile for attachment. 

**Usages:**

* Derived from this Profile: [Attachment: Obligations](StructureDefinition-cz-attachment-obl-lab.md)
* Use this Profile: [Bundle - Laboratory Result Report](StructureDefinition-cz-bundle-lab.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/cz-attachment)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-attachment.csv), [Excel](StructureDefinition-cz-attachment.xlsx), [Schematron](StructureDefinition-cz-attachment.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-attachment",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-attachment",
  "version" : "0.5.0",
  "name" : "CZ_Attachment",
  "title" : "Attachment: Lab Report (CZ)",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Czech profile for attachment. ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "dicom",
      "uri" : "http://nema.org/dicom",
      "name" : "DICOM Tag Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Media",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Media",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Media",
        "path" : "Media",
        "short" : "Lab Report attachment",
        "definition" : "Lab Report attachment."
      },
      {
        "id" : "Media.basedOn",
        "path" : "Media.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-service-request-lab",
              "http://hl7.org/fhir/StructureDefinition/CarePlan"
            ]
          }
        ]
      },
      {
        "id" : "Media.subject",
        "path" : "Media.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core"
            ]
          }
        ]
      },
      {
        "id" : "Media.operator",
        "path" : "Media.operator",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
              "http://hl7.org/fhir/StructureDefinition/CareTeam",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core"
            ]
          }
        ]
      },
      {
        "id" : "Media.content.contentType",
        "path" : "Media.content.contentType",
        "mustSupport" : true
      },
      {
        "id" : "Media.content.language",
        "path" : "Media.content.language",
        "mustSupport" : true
      },
      {
        "id" : "Media.content.url",
        "path" : "Media.content.url",
        "mustSupport" : true
      },
      {
        "id" : "Media.content.title",
        "path" : "Media.content.title",
        "mustSupport" : true
      },
      {
        "id" : "Media.content.creation",
        "path" : "Media.content.creation",
        "mustSupport" : true
      }
    ]
  }
}

```
