# A.2.3 - Specimen information - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.3 - Specimen information**

## Logical Model: A.2.3 - Specimen information 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/SpecimenLabCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnSpecimenLabEhnCz |

 
Specimen information. Section A4 of the eHN guideline. 

**Usages:**

* Use this Logical Model: [A - Laboratory Report](StructureDefinition-LabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/SpecimenLabCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SpecimenLabCz.csv), [Excel](StructureDefinition-SpecimenLabCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SpecimenLabCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/SpecimenLabCz",
  "version" : "0.5.0",
  "name" : "LogEnSpecimenLabEhnCz",
  "title" : "A.2.3 - Specimen information",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Specimen information. Section A4 of the eHN guideline.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/SpecimenLabCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "SpecimenLabCz",
        "path" : "SpecimenLabCz",
        "short" : "A.2.3 - Specimen information",
        "definition" : "Specimen information. Section A4 of the eHN guideline."
      },
      {
        "id" : "SpecimenLabCz.identifier",
        "path" : "SpecimenLabCz.identifier",
        "short" : "A.2.3.1 Specimen identifier",
        "definition" : "An identifier of the specimen which is unique within in a defined scope. Example: identifier assigned by Specimening system, identifier assigned by laboratory etc. Multiple identifiers can be used.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SpecimenLabCz.speciesType",
        "path" : "SpecimenLabCz.speciesType",
        "short" : "A.2.3.2 Type of species",
        "definition" : "Biologic type of species for laboratory result reports bound to non-human subjects. \n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenLabCz.material",
        "path" : "SpecimenLabCz.material",
        "short" : "A.2.3.3 Material",
        "definition" : "Specimen material. ¨\n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenLabCz.collected",
        "path" : "SpecimenLabCz.collected",
        "short" : "A.2.3.4 Collection period",
        "definition" : "Collection date time or period. \n- Preferred system(s): ISO 8601",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "SpecimenLabCz.anatomicLocation",
        "path" : "SpecimenLabCz.anatomicLocation",
        "short" : "A.2.3.5 Anatomic location",
        "definition" : "Anatomic location (body location, laterality) where the material is collected, e.g. Elbow, left \n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenLabCz.morphology",
        "path" : "SpecimenLabCz.morphology",
        "short" : "A.2.3.6 Morphology",
        "definition" : "Morphological abnormalities of the anatomical location where the material is taken, for example wound, ulcer. \n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenLabCz.sourceDevice",
        "path" : "SpecimenLabCz.sourceDevice",
        "short" : "A.2.3.7 Source Device",
        "definition" : "If the material is not collected directly from the patient but comes from a patient-related object, e.g. a catheter\n- Preferred system(s): SNOMED CT\n- Preferred system(s): EMDN",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenLabCz.collectionMethod",
        "path" : "SpecimenLabCz.collectionMethod",
        "short" : "A.2.3.8 Collection procedure/method",
        "definition" : "If relevant for the results, the method of obtaining the specimen. \n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SpecimenLabCz.receivedDateTime",
        "path" : "SpecimenLabCz.receivedDateTime",
        "short" : "A.2.3.9 Received date",
        "definition" : "Date and time that the material is handed over at the laboratory or specimen collection centre. \n- Preferred system(s): ISO 8601",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
