# A.1.4 - Information recipient - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.4 - Information recipient**

## Logical Model: A.1.4 - Information recipient 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/RecipientCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnRecipientLabEhnCz |

 
Information recipient (intended recipient or recipients of the report, additional recipients might be identified by the ordering party, e.g. GP, other specialist), if applicable. Section A1.4 of the eHN guideline. 

**Usages:**

* Use this Logical Model: [A - Laboratory Report](StructureDefinition-LabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/RecipientCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-RecipientCz.csv), [Excel](StructureDefinition-RecipientCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RecipientCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/RecipientCz",
  "version" : "0.5.0",
  "name" : "LogEnRecipientLabEhnCz",
  "title" : "A.1.4 - Information recipient",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Information recipient (intended recipient or recipients of the report, additional recipients might be identified by the ordering party, e.g. GP, other specialist), if applicable.\nSection A1.4 of the eHN guideline.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/RecipientCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "RecipientCz",
        "path" : "RecipientCz",
        "short" : "A.1.4 - Information recipient",
        "definition" : "Information recipient (intended recipient or recipients of the report, additional recipients might be identified by the ordering party, e.g. GP, other specialist), if applicable.\nSection A1.4 of the eHN guideline."
      },
      {
        "id" : "RecipientCz.identifier",
        "path" : "RecipientCz.identifier",
        "short" : "A.1.4.1 Recipient identifier",
        "definition" : "The health professional identification number.\nEither an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the license or registration number.\nIn case when recipient is not a health professional, e.g. patient, appropriate personal identifier should be used.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "RecipientCz.name",
        "path" : "RecipientCz.name",
        "short" : "A.1.4.2 Recipient name",
        "definition" : "Name and surname of the recipient.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "RecipientCz.organizationIdentifier",
        "path" : "RecipientCz.organizationIdentifier",
        "short" : "A.1.4.3 Recipient organization id",
        "definition" : "Identifier of the recipient organization according to the NRPZS or IČO.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "RecipientCz.organization",
        "path" : "RecipientCz.organization",
        "short" : "A.1.4.4 Recipient organization",
        "definition" : "Name and identification details of the recipient's healthcare facility, and, where applicable, the recipient's workplace.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      }
    ]
  }
}

```
