# eHN Validator to this guide Map - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Validator to this guide Map**

## ConceptMap: eHN Validator to this guide Map (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ConceptMap/validator2FHIR-cz-lab | *Version*:0.5.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:Validator2Fhir |

 
eHN Validator Model to this guide Map 

 
It shows how the Validator Recipient data set defined by the EU eHN guidelines is mapped into this guide 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "validator2FHIR-cz-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/ConceptMap/validator2FHIR-cz-lab",
  "version" : "0.5.0",
  "name" : "Validator2Fhir",
  "title" : "eHN Validator to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "eHN Validator Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "It shows how the Validator Recipient data set defined by the EU eHN guidelines is mapped into this guide",
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/ValidatorCz",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-composition-lab-report",
      "element" : [
        {
          "code" : "Validator.identifier",
          "display" : "A.1.6.1 Result validator identifier",
          "target" : [
            {
              "code" : "Composition.attester.party.identifier",
              "equivalence" : "equivalent",
              "comment" : "attester.where(mode='professional')"
            }
          ]
        },
        {
          "code" : "Validator.name",
          "display" : "A.1.6.2 Result validator name",
          "target" : [
            {
              "code" : "Composition.attester.party.name",
              "equivalence" : "equivalent",
              "comment" : "attester.where(mode='professional').party.resolve().ofType(Practitioner).name"
            }
          ]
        },
        {
          "code" : "Validator.name",
          "display" : "A.1.6.2 Result validator name",
          "target" : [
            {
              "code" : "Composition.attester.party.Practitioner.name",
              "equivalence" : "equivalent",
              "comment" : "attester.where(mode='professional').party.resolve().ofType(PractitionerRole).Practitioner.resolve().name"
            }
          ]
        },
        {
          "code" : "Validator.organizationIdentifier",
          "display" : "A.1.6.3 Result validator organisation identifier",
          "target" : [
            {
              "code" : "Composition.attester.party.organization.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Validator.organization",
          "display" : "A.1.6.4 Result validator organisation",
          "target" : [
            {
              "code" : "Composition.attester.party.organization",
              "equivalence" : "equivalent",
              "comment" : "attester.where(mode='professional').party.resolve().ofType(PractitionerRole).organization.resolve()"
            }
          ]
        },
        {
          "code" : "Validator.dateTime",
          "display" : "A.1.6.5 Validation date and time",
          "target" : [
            {
              "code" : "Composition.attester.time",
              "equivalence" : "equivalent",
              "comment" : "attester.where(mode='professional').time"
            }
          ]
        }
      ]
    }
  ]
}

```
