# eHN Recipient to this guide Map - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Recipient to this guide Map**

## ConceptMap: eHN Recipient to this guide Map (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ConceptMap/recipient2FHIR-cz-lab | *Version*:0.5.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:Recipient2FHIR |

 
eHN Recipient Model to this guide Map 

 
It shows how the Laboratory Report Recipient data set defined by the EU eHN guidelines is mapped into this guide 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "recipient2FHIR-cz-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/ConceptMap/recipient2FHIR-cz-lab",
  "version" : "0.5.0",
  "name" : "Recipient2FHIR",
  "title" : "eHN Recipient to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "eHN Recipient Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "It shows how the Laboratory Report Recipient data set defined by the EU eHN guidelines is mapped into this guide",
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/RecipientCz",
      "target" : "http://hl7.eu/fhir/StructureDefinition/information-recipient",
      "targetVersion" : "0.1.1",
      "element" : [
        {
          "code" : "Recipient.identifier",
          "display" : "A.1.4.1 Recipient identifier",
          "target" : [
            {
              "code" : "extension:information-recipient.valueReference.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Recipient.name",
          "display" : "A.1.4.2 Recipient name",
          "target" : [
            {
              "code" : "extension:information-recipient.valueReference.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Recipient.organizationIdentifier",
          "display" : "A.1.4.3 Recipient organization",
          "target" : [
            {
              "code" : "extension:information-recipient.ValueReference.identifier",
              "equivalence" : "equivalent",
              "comment" : "ValueReference.resolve().ofType(Organization). If the recipient is an organization."
            }
          ]
        },
        {
          "code" : "Recipient.organizationIdentifier",
          "display" : "A.1.4.3 Recipient organization",
          "target" : [
            {
              "code" : "extension:information-recipient.ValueReference.organization.identifier",
              "equivalence" : "equivalent",
              "comment" : "ValueReference.resolve().ofType(PractitionerRole). If it is the organization the professional belong to"
            }
          ]
        },
        {
          "code" : "Recipient.organization",
          "display" : "A.1.4.4 Recipient organization",
          "target" : [
            {
              "code" : "extension:information-recipient.ValueReference",
              "equivalence" : "equivalent",
              "comment" : "ValueReference.resolve().ofType(Organization). If the recipient is an organization."
            }
          ]
        },
        {
          "code" : "Recipient.organization",
          "display" : "A.1.4.4 Recipient organization",
          "target" : [
            {
              "code" : "extension:information-recipient.ValueReference.organization",
              "equivalence" : "equivalent",
              "comment" : "ValueReference.resolve().ofType(PractitionerRole). If it is the organization the professional belong to"
            }
          ]
        }
      ]
    }
  ]
}

```
