# eHN Payer to this guide Map - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Payer to this guide Map**

## ConceptMap: eHN Payer to this guide Map (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ConceptMap/payer2FHIR-cz-lab | *Version*:0.5.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:Payer2Fhir |

 
eHN Payer Model to this guide Map 

 
It shows how the Laboratory Report Payer data set defined by the EU eHN guidelines is mapped into this guide 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "payer2FHIR-cz-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/ConceptMap/payer2FHIR-cz-lab",
  "version" : "0.5.0",
  "name" : "Payer2Fhir",
  "title" : "eHN Payer to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "eHN Payer Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "It shows how the Laboratory Report Payer data set defined by the EU eHN guidelines is mapped into this guide",
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/PayerCz",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-service-request-lab",
      "element" : [
        {
          "code" : "Payer.identifier",
          "display" : "A.1.3.1 Health insurance code",
          "target" : [
            {
              "code" : "ServiceRequest.insurance",
              "equivalence" : "relatedto",
              "comment" : "details in Group 2"
            }
          ]
        },
        {
          "code" : "Payer.name",
          "display" : "A.1.3.2 Health insurance name",
          "target" : [
            {
              "code" : "ServiceRequest.insurance",
              "equivalence" : "relatedto",
              "comment" : "details in Group 2"
            }
          ]
        },
        {
          "code" : "Payer.subjectIdentifier",
          "display" : "A.1.3.3 Health insurance number",
          "target" : [
            {
              "code" : "ServiceRequest.insurance",
              "equivalence" : "relatedto",
              "comment" : "details in Group 2"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/PayerCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-coverage",
      "element" : [
        {
          "code" : "Payer.identifier",
          "display" : "A.1.3.1 Health insurance code",
          "target" : [
            {
              "code" : "Coverage.payor.identifier",
              "equivalence" : "equivalent",
              "comment" : "payor.ofType(Organization)"
            }
          ]
        },
        {
          "code" : "Payer.name",
          "display" : "A.1.3.2 Health insurance name",
          "target" : [
            {
              "code" : "Coverage.payor.name",
              "equivalence" : "equivalent",
              "comment" : "payor.ofType(Organization)"
            }
          ]
        },
        {
          "code" : "Payer.subjectIdentifier",
          "display" : "A.1.3.3 Health insurance number",
          "target" : [
            {
              "code" : "Coverage.policyHolder.identifier",
              "equivalence" : "equivalent",
              "comment" : "If it refers to the owner of the policy"
            }
          ]
        },
        {
          "code" : "Payer.subjectIdentifier",
          "display" : "A.1.3.3 Health insurance number",
          "target" : [
            {
              "code" : "Coverage.beneficiary.identifier",
              "equivalence" : "equivalent",
              "comment" : "If it refers to the plan beneficiary"
            }
          ]
        },
        {
          "code" : "Payer.subjectIdentifier",
          "display" : "A.1.3.3 Health insurance number",
          "target" : [
            {
              "code" : "Coverage.subscriberId",
              "equivalence" : "equivalent",
              "comment" : "If it is the ID assigned to the subscriber"
            }
          ]
        },
        {
          "code" : "Payer.subjectIdentifier",
          "display" : "A.1.3.3 Health insurance number",
          "target" : [
            {
              "code" : "Coverage.subscriber.identifier",
              "equivalence" : "equivalent",
              "comment" : "If it refers to the subscriber to the policy and the Subscriber is of type Patient"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/PayerCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
      "element" : [
        {
          "code" : "Payer.identifier",
          "display" : "A.1.3.1 Health insurance code",
          "target" : [
            {
              "equivalence" : "unmatched"
            }
          ]
        },
        {
          "code" : "Payer.name",
          "display" : "A.1.3.2 Health insurance name",
          "target" : [
            {
              "equivalence" : "unmatched"
            }
          ]
        },
        {
          "code" : "Payer.subjectIdentifier",
          "display" : "A.1.3.3 Health insurance number",
          "target" : [
            {
              "code" : "Patient.identifier",
              "equivalence" : "equivalent",
              "comment" : "If treated as one of the Patient identifiers; this applies in some jurisdictions"
            }
          ]
        }
      ]
    }
  ]
}

```
