# eHN Author to this guide Map - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Author to this guide Map**

## ConceptMap: eHN Author to this guide Map (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ConceptMap/author2FHIR-cz-lab | *Version*:0.5.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:LabRptAuthor2FHIR |

 
eHN Author Model to this guide Map 

 
It shows how the Laboratory Report Author data set defined by the EU eHN guidelines is mapped into this guide 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "author2FHIR-cz-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/ConceptMap/author2FHIR-cz-lab",
  "version" : "0.5.0",
  "name" : "LabRptAuthor2FHIR",
  "title" : "eHN Author to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "eHN Author Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "It shows how the Laboratory Report Author data set defined by the EU eHN guidelines is mapped into this guide",
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/AuthorCz",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-composition-lab-report",
      "element" : [
        {
          "code" : "Author.identifier",
          "display" : "A.1.5.1 Author identifier",
          "target" : [
            {
              "code" : "Composition.author.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Author.name",
          "display" : "A.1.5.2 Author name",
          "target" : [
            {
              "code" : "Composition.author.name",
              "equivalence" : "equivalent",
              "comment" : "Human Author and author.ofType(Practitioner)"
            }
          ]
        },
        {
          "code" : "Author.name",
          "display" : "A.1.5.2 Author name",
          "target" : [
            {
              "code" : "Composition.author.Practitioner.name",
              "equivalence" : "equivalent",
              "comment" : "Human Author and  author.ofType(PractitionerRole)"
            }
          ]
        },
        {
          "code" : "Author.name",
          "display" : "A.1.5.2 Author name",
          "target" : [
            {
              "code" : "Composition.device.name",
              "equivalence" : "equivalent",
              "comment" : "Device Author, implies author.ofType(Device)"
            }
          ]
        },
        {
          "code" : "Author.organizationIdentifier",
          "display" : "A.1.5.3 Author organization identifier",
          "target" : [
            {
              "code" : "Composition.author.organization.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Author.organization",
          "display" : "A.1.5.4 Author organization",
          "target" : [
            {
              "code" : "Composition.author.organization",
              "equivalence" : "equivalent",
              "comment" : "Human Author and author.ofType(PractitionerRole)"
            }
          ]
        },
        {
          "code" : "Author.organization",
          "display" : "A.1.5.4 Author organization",
          "target" : [
            {
              "code" : "Composition.author.owner",
              "equivalence" : "equivalent",
              "comment" : "Device Author, implies author.ofType(Device)"
            }
          ]
        },
        {
          "code" : "Author.organization.dateOfSaving",
          "display" : "A.1.5.5 Date and time of saving.",
          "target" : [
            {
              "code" : "Composition.date",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/AuthorCz",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnostic-report-lab",
      "element" : [
        {
          "code" : "Author.identifier",
          "display" : "A.1.5.1 Author identifier",
          "target" : [
            {
              "code" : "DiagnosticReport.resultsInterpreter.identifier",
              "equivalence" : "relatedto",
              "comment" : "If the author is the interpreter"
            }
          ]
        },
        {
          "code" : "Author.identifier",
          "display" : "A.1.5.1 Author identifier",
          "target" : [
            {
              "code" : "DiagnosticReport.performer.identifier",
              "equivalence" : "relatedto",
              "comment" : "If the author is the performer"
            }
          ]
        },
        {
          "code" : "Author.name",
          "display" : "A.1.5.2 Author name",
          "target" : [
            {
              "code" : "DiagnosticReport.resultsInterpreter.name",
              "equivalence" : "relatedto",
              "comment" : "If the author is the interpreter and \nresultsInterpreter.resolve().ofType(Practitioner)"
            }
          ]
        },
        {
          "code" : "Author.name",
          "display" : "A.1.5.2 Author name",
          "target" : [
            {
              "code" : "DiagnosticReport.resultsInterpreter.practitioner.name",
              "equivalence" : "relatedto",
              "comment" : "If the author is the interpreter and resultsInterpreter.resolve().ofType(PractitionerRole)"
            }
          ]
        },
        {
          "code" : "Author.name",
          "display" : "A.1.5.2 Author name",
          "target" : [
            {
              "code" : "DiagnosticReport.performer.name",
              "equivalence" : "relatedto",
              "comment" : "If the author is the performer and performer.resolve().ofType(Practitioner)"
            }
          ]
        },
        {
          "code" : "Author.name",
          "display" : "A.1.5.2 Author name",
          "target" : [
            {
              "code" : "DiagnosticReport.performer.Practitioner.name",
              "equivalence" : "relatedto",
              "comment" : "If the author is the performer and performer.resolve().ofType(PractitionerRole)"
            }
          ]
        },
        {
          "code" : "Author.organization",
          "display" : "A.1.5.3 Author organization identifier",
          "target" : [
            {
              "code" : "DiagnosticReport.resultsInterpreter.organization.identifier",
              "equivalence" : "relatedto",
              "comment" : "If the author is the interpreter and resultsInterpreter.resolve().ofType(PractitionerRole)"
            }
          ]
        },
        {
          "code" : "Author.organization",
          "display" : "A.1.5.3 Author organization identifier",
          "target" : [
            {
              "code" : "DiagnosticReport.performer.organization.identifier",
              "equivalence" : "relatedto",
              "comment" : "If the author is the performer and performer.resolve().ofType(PractitionerRole)"
            }
          ]
        },
        {
          "code" : "Author.organization",
          "display" : "A.1.5.4 Author organization",
          "target" : [
            {
              "code" : "DiagnosticReport.resultsInterpreter.organization",
              "equivalence" : "relatedto",
              "comment" : "If the author is the interpreter and resultsInterpreter.resolve().ofType(PractitionerRole)"
            }
          ]
        },
        {
          "code" : "Author.organization",
          "display" : "A.1.5.4 Author organization",
          "target" : [
            {
              "code" : "DiagnosticReport.performer.organization",
              "equivalence" : "relatedto",
              "comment" : "If the author is the performer and performer.resolve().ofType(PractitionerRole)"
            }
          ]
        }
      ]
    }
  ]
}

```
