# Logical models - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* **Logical models**

## Logical models

This page lists HL7 FHIR logical models used to represent the laboratory report.

| | | |
| :--- | :--- | :--- |
| Name | Title | Description |
| [LogEnLabReportEhnCz](StructureDefinition-LabReportCz.md) | A - Laboratory Report | Laboratory Report. eHN guideline model. |
| [LogEnSubjectLabEhnCz](StructureDefinition-SubjectCz.md) | A.1.1, A1.2 - Subject of care | Patient or Subject of care. Sections A1.1 and A1.2 of the eHN guideline. |
| [LogEnPayerLabEhnCz](StructureDefinition-PayerCz.md) | A.1.3 - Health insurance and payment information | Health insurance and payment information. Section A1.3 of the eHN guideline. |
| [LogEnRecipientLabEhnCz](StructureDefinition-RecipientCz.md) | A.1.4 - Information recipient | Information recipient (intended recipient or recipients of the report, additional recipients might be identified by the ordering party, e.g. GP, other specialist), if applicable. Section A1.4 of the eHN guideline. |
| [LogEnAuthorLabEhnCz](StructureDefinition-AuthorCz.md) | A.1.5 - Author | Author (by whom the Laboratory result report or a subset of its results was authored). Section A1.5 of the eHN guideline. |
| [LogEnValidatorLabEhnCz](StructureDefinition-ValidatorCz.md) | A.1.6 - Result validator | Result validator. Section A1.6 of the eHN guideline. |
| [LogEnLegalAuthenticatorLabEhnCz](StructureDefinition-LegalAuthenticatorCz.md) | A.1.7 - Legal authenticator | Legal authenticator (The person taking responsibility for the medical content of the document). Section A1.7 of the eHN guideline. |
| [LogEnElectronicSignaturesLabEhnCz](StructureDefinition-ElectronicSignatures.md) | A.1.9 - Electronic signatures | Electronic signatures According to Act No. 327/2011, §54a Section A1.7 of the eHN guideline. |
| [LogEnOrderLabEhnCz](StructureDefinition-OrderCz.md) | A.2.1, A.2.2 - Order | Order information and reason. Sections A2 and A3 of the eHN guideline. |
| [LogEnSpecimenLabEhnCz](StructureDefinition-SpecimenLabCz.md) | A.2.3 - Specimen information | Specimen information. Section A4 of the eHN guideline. |
| [LogEnResultLabEhnCz](StructureDefinition-ResultCz.md) | A.2.4 - Results data elements | Results data elements. Section A5 of the eHN guideline. |
| [LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md) | A.3 - Presented form | Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended. |
| [LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md) | A.4 - Additional attachments | Laboratory Report - Laboratory Report additional attachments - A.4 |

