# Artifacts Summary - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Obligations 

Obligations used to describe the Imaging Report functional requirements for the specified data elements. Informative for this version of the guide.

| | |
| :--- | :--- |
| [Bundle: Obligations](StructureDefinition-cz-bundle-obl-lab.md) | This profile defines obligations for a bundle in FHIR for the purpose of this guide. |
| [Composition: Obligations](StructureDefinition-cz-composition-obl-lab.md) | This profile defines obligations for a composition in FHIR for the purpose of this guide. |
| [Diagnostic Report: Obligations](StructureDefinition-cz-diagnosticReport-obl-lab.md) | This profile defines obligations for a diagnostic report in FHIR for the purpose of this guide. |
| [DocumentReference: Obligations](StructureDefinition-cz-documentReference-obl-lab.md) | This profile defines obligations for a bundle in FHIR for the purpose of this guide. |
| [Encounter: Obligations](StructureDefinition-cz-encounter-obl-lab.md) | This profile defines obligations for an encounter in FHIR for the purpose of this guide. |
| [Organization: Obligations](StructureDefinition-cz-organization-obl-lab.md) | This profile defines obligations for an organization in FHIR for the purpose of this guide. |
| [Patient Animal: Obligations](StructureDefinition-cz-patientAnimal-obl-lab.md) | This profile defines obligations for an animal Patient in FHIR for the purpose of this guide. |
| [Patient: Obligations](StructureDefinition-cz-patient-obl-lab.md) | This profile defines obligations for an human Patient in FHIR for the purpose of this guide. |
| [Specimen: Obligations](StructureDefinition-cz-specimen-obl-lab.md) | This profile defines obligations for a specimen in FHIR for the purpose of this guide. |

### Czech logical model (Informative) 

Logical model in czech language. Informative for this version of the guide.

| | |
| :--- | :--- |
| [A - Laboratorní zpráva](StructureDefinition-LogLabReportCz.md) | Zpráva z laboratorního vyšetření |
| [A.1.1, A1.2 - Pacient](StructureDefinition-LogSubjectCz.md) | Pacient |
| [A.1.3 - Preferované systémy](StructureDefinition-LogPayerCz.md) | Informace o zdravotním pojištění |
| [A.1.4 - Příjemce dokumentu](StructureDefinition-LogRecipientCz.md) | Informace o zamýšleném příjemci dokumentu |
| [A.1.5 - Autor dokumentu](StructureDefinition-LogAuthorCz.md) | Autor dokumentu dle zákona 372/2011 §54 odst. (3) |
| [A.1.6 - Ověřil](StructureDefinition-LogValidatorCz.md) | Ověřil |
| [A.1.7 - Zodpovídá](StructureDefinition-LogLegalAuthenticatorCz.md) | Zodpovídá |
| [A.1.9 - Electronic signatures](StructureDefinition-LogElectronicSignatures.md) | Electronic signatures According to Act No. 327/2011, §54a Section A1.7 of the eHN guideline. |
| [A.2.1, A.2.2 - Objednávka](StructureDefinition-LogOrderCz.md) | Objednávka |
| [A.2.3 - Informace o vzorku](StructureDefinition-LogSpecimenLabCz.md) | Informace o vzorku |
| [A.2.4 - Datové elementy výsledku vyšetření](StructureDefinition-LogResultCz.md) | Datové elementy výsledku vyšetření |
| [A.3 - Presented form](StructureDefinition-LogPresentedFormCz.md) | Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended. |
| [A.4 - Additional attachments](StructureDefinition-LogAttachmentsCz.md) | Laboratory Report - Laboratory Report additional attachments - A.4 |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [A - Laboratory Report](StructureDefinition-LabReportCz.md) | Laboratory Report. eHN guideline model. |
| [A.1.1, A1.2 - Subject of care](StructureDefinition-SubjectCz.md) | Patient or Subject of care. Sections A1.1 and A1.2 of the eHN guideline. |
| [A.1.3 - Health insurance and payment information](StructureDefinition-PayerCz.md) | Health insurance and payment information. Section A1.3 of the eHN guideline. |
| [A.1.4 - Information recipient](StructureDefinition-RecipientCz.md) | Information recipient (intended recipient or recipients of the report, additional recipients might be identified by the ordering party, e.g. GP, other specialist), if applicable. Section A1.4 of the eHN guideline. |
| [A.1.5 - Author](StructureDefinition-AuthorCz.md) | Author (by whom the Laboratory result report or a subset of its results was authored). Section A1.5 of the eHN guideline. |
| [A.1.6 - Result validator](StructureDefinition-ValidatorCz.md) | Result validator. Section A1.6 of the eHN guideline. |
| [A.1.7 - Legal authenticator](StructureDefinition-LegalAuthenticatorCz.md) | Legal authenticator (The person taking responsibility for the medical content of the document). Section A1.7 of the eHN guideline. |
| [A.1.9 - Electronic signatures](StructureDefinition-ElectronicSignatures.md) | Electronic signatures According to Act No. 327/2011, §54a Section A1.7 of the eHN guideline. |
| [A.2.1, A.2.2 - Order](StructureDefinition-OrderCz.md) | Order information and reason. Sections A2 and A3 of the eHN guideline. |
| [A.2.3 - Specimen information](StructureDefinition-SpecimenLabCz.md) | Specimen information. Section A4 of the eHN guideline. |
| [A.2.4 - Results data elements](StructureDefinition-ResultCz.md) | Results data elements. Section A5 of the eHN guideline. |
| [A.3 - Presented form](StructureDefinition-PresentedFormCz.md) | Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended. |
| [A.4 - Additional attachments](StructureDefinition-AttachmentsCz.md) | Laboratory Report - Laboratory Report additional attachments - A.4 |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Attachment: Lab Report (CZ)](StructureDefinition-cz-attachment.md) | Czech profile for attachment. |
| [Attachment: Obligations](StructureDefinition-cz-attachment-obl-lab.md) | This profile defines obligations for an attachment in FHIR for the purpose of this guide. |
| [Bundle - Laboratory Result Report](StructureDefinition-cz-bundle-lab.md) | This profile represents the constraints applied to the Bundle resource by the Czech national laboratory report FHIR Implementation Guide. |
| [Composition: Laboratory Report](StructureDefinition-cz-composition-lab-report.md) | Clinical document used to represent a Laboratory Report in the scope of the Czech national interoperability project. |
| [Coverage: Obligations](StructureDefinition-cz-coverage-obl-lab.md) | This profile defines obligations for a coverage in FHIR for the purpose of this guide. |
| [DiagnosticReport: Laboratory Report](StructureDefinition-cz-diagnostic-report-lab.md) | Diagnostic Report used to represent an entry of a Laboratory Report, including its context, for the scope of the Czech national interoperability project. |
| [Observation Laboratory (CZ)](StructureDefinition-cz-observation-result-laboratory.md) | This profile constrains the Observation resource to represent results produced by laboratory tests or panels/studies.This observation may represent the result of a simple laboratory test such as hematocrit or it may group the set of results produced by a multi-test study or panel such as a complete blood count, a dynamic function test, a urine specimen study. In the latter case, the observation carries the overall conclusion of the study and or a global interpretation by the producer of the study in the comment element; and references the atomic results of the study as "has-member" child observations. |
| [Observation: Obligations](StructureDefinition-cz-observationResult-obl-lab.md) | This profile defines obligations for an observation result in FHIR for the purpose of this guide. |
| [Practitioner Role: Obligations](StructureDefinition-cz-practitionerRole-obl-img.md) | This profile defines obligations for a practitioner role in FHIR for the purpose of this guide. |
| [Practitioner: Obligations](StructureDefinition-cz-practitioner-obl-lab.md) | This profile defines obligations for a practitioner in FHIR for the purpose of this guide. |
| [Related Person: Obligations](StructureDefinition-cz-relatedPerson-obl-img.md) | This profile defines obligations for a related person in FHIR for the purpose of this guide. |
| [Service Request: Obligations](StructureDefinition-cz-serviceRequest-obl-lab.md) | This profile defines obligations for an order information in FHIR for the purpose of this guide. |
| [ServiceRequest: Laboratory Order](StructureDefinition-cz-service-request-lab.md) | ServiceRequest used to represent a Laboratory Order for the scope of the Czech national interoperability project. |
| [Specimen Laboratory (CZ)](StructureDefinition-cz-specimen-lab.md) | Czech profile for a specimen in a laboratory report. In some laboratory reports, specimen information is allowed to be minimal as many informations concerning the specimen are implied by the observations done. |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Address: Obligations](StructureDefinition-cz-address-obl-lab.md) | This profile defines obligations for an address in FHIR for the purpose of this guide. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Document Based On Order](StructureDefinition-composition-based-on-order-or-requisition.md) | This extension provides a link to the order [(Reference(ServiceRequest)] or requisition [ServiceRequest.requisition (i.e., 'Request.groupIdentifier')] that this report document is based on and fulfills. |
| [Document DiagnosticReport Reference](StructureDefinition-composition-DiagnosticReportReference.md) | This extension provides a reference to the DiagnosticReport instance that is associated with this document. |
| [ExtNote (CZ)](StructureDefinition-cz-ext-note.md) | CzExtNote |
| [Extension - Clinically Relevant Time](StructureDefinition-cz-lab-clinically-relevant-time.md) | Clinically Relevant Time Code |
| [Information recipient](StructureDefinition-information-recipient.md) | This extension applies to the Composition resource and is used to represent an intended recipient of the composition. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Laboratory Container Types (CZ)](ValueSet-cz-lab-container-types-VS.md) | Laboratory Container Types ValueSet |
| [Laboratory Report Types (CZ)](ValueSet-cz-lab-report-types-VS.md) | Typy laboratorních zpráv |
| [Laboratory Speciality Types (CZ)](ValueSet-cz-lab-speciality-types-VS.md) | Typy specializací laboratorní medicíny podle SNOMED CT pro použití v českých laboratorních implementacích (např. sekce v Composition, klasifikace laboratoře apod.). |
| [Laboratory Study Types (CZ)](ValueSet-cz-lab-study-types-VS.md) | Typy laboratorních vyšetření |
| [Laboratory Techniques](ValueSet-cz-lab-technique-vs.md) | Laboratory technique (method of measurement) used for the result measurement (based on SNOMED CT). |
| [Národní číselník laboratorních položek](ValueSet-cz-nclp-labpol-vs.md) | Sada obsahuje všechny položky kódového systému NČLP, které se používají pro identifikaci laboratorních testů, a to jak na laboratorních žádankách, tak v laboratorních nálezech a jiných typech zdravotnické dokumentace. |
| [ValueSet - Clinically Relevant Time](ValueSet-cz-lab-clinically-relevant-time-VS.md) | Codes of the clinically relevant times |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [CZ Attachment Model to this guide Map](ConceptMap-AttachmentImagingReport2FHIR-cz.md) | CZ Imaging Report Attachment Model to this guide mapping |
| [DiagnosticReport to Composition status](ConceptMap-ConceptMap-cz-diagRptStatus2CompStatus.md) | Proposed relationship between the statused used in the DiagnosticReport resource and that used for the Composition. |
| [eHN Author to this guide Map](ConceptMap-author2FHIR-cz-lab.md) | eHN Author Model to this guide Map |
| [eHN Lab Report to this guide Map](ConceptMap-labRpt2FHIR-cz-lab.md) | eHN Lab Report to this guide Map |
| [eHN Order to this guide Map](ConceptMap-order2FHIR-cz-lab.md) | eHN Order to this guide Map |
| [eHN Payer to this guide Map](ConceptMap-payer2FHIR-cz-lab.md) | eHN Payer Model to this guide Map |
| [eHN Recipient to this guide Map](ConceptMap-legalAuth2FHIR-cz-lab.md) | eHN Legal Authenticator Model to this guide Map |
| [eHN Recipient to this guide Map](ConceptMap-recipient2FHIR-cz-lab.md) | eHN Recipient Model to this guide Map |
| [eHN Result to this guide Map](ConceptMap-result2FHIR-cz-lab.md) | eHN Result Model to this guide Map |
| [eHN Specimen to this guide Map](ConceptMap-specimen2FHIR-cz-lab.md) | eHN Specimen Model to this guide Map |
| [eHN Subject to this guide Map](ConceptMap-subject2FHIR-cz-lab.md) | eHN Subject Model to this guide Map |
| [eHN Validator to this guide Map](ConceptMap-validator2FHIR-cz-lab.md) | eHN Validator Model to this guide Map |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Basic Lab Report Bundle Example](Bundle-CZ-LabReport-Bundle-Example.md) | Czech Lab Report - basic example of a bundle containing lab observation(s) |
| [Blood Type](Observation-5f3b0d47-2c3c-4c54-97f1-0bb8cc3e4e4f.md) | Example of a lab result – coded |
| [CZ Lab Order Specimen Example](Specimen-6e2c1f9a-54b7-4d3e-82a1-7c4f9e2b0d85.md) | Czech Lab Order - example of a specimen |
| [CZ Lab Order Specimen Example](Specimen-92f1c7b5-3a4e-4d8f-97c2-1b6e0f8d2a43.md) | Czech Lab Order - example of a specimen |
| [CZ Lab Order Specimen Example](Specimen-fa3d8c2e-71b4-4e9c-9d2f-85b0a1f7c934.md) | Czech Lab Order - example of a specimen |
| [CZ Lab Order Specimen Example - Urine](Specimen-4c7a1d2f-89b3-41e5-a6f2-3b9d7c5e0a21.md) | Czech Lab Order - example of a urine specimen |
| [Complex Report Bundle Example](Bundle-CZ-LabReport-Bundle-Example-Complex.md) | Czech Lab Report - example of a bundle containing containing several laboratory results as would occur in a real-life report |
| [Coverage example](Coverage-b4e1a7f0-93f3-4d86-a3b1-7d15e42b12f8.md) | Example of insurance by a health insurance company |
| [Example Laboratory Order](ServiceRequest-5f9c2e8d-0b74-4dbb-8af3-3e6d2c1191a7.md) | Example instance of CZ_ServiceRequestLab for a serum glucose test with urgent priority |
| [Hospital Žlábek Dolní](Organization-bc2b8a3e-999a-4f10-91ce-1dc12fa0e123.md) | Healthcare facility requesting a laboratory examination. |
| [L1 Lab Report Bundle Example](Bundle-CZ-LabReport-Bundle-Example-L1.md) | Czech Lab Report - example of a L1 Lab Report bundle |
| [Lab Report Bundle Example for Cumulative View](Bundle-CZ-LabReport-Bundle-Example-kn.md) | Czech Lab Report - example of a bundle for a cumulative view in combination with the Minimal Lab Report Bundle Example |
| [Lab Report Bundle Example with various result types](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md) | Czech Lab Report - example of a bundle containing lab observations of various result types |
| [Minimal Lab Report Bundle Example](Bundle-CZ-LabReport-Bundle-Example-Min.md) | Czech Lab Report - example of a minimal bundle containing lab observations |
| [Organization - Healthcare insurance company](Organization-d7a9324a-6d45-420a-bd8d-0a2c66e8e40c.md) | Example of insurance organisation |
| [Organization: Registering healthcare provider example](Organization-RegisteringProviderExample.md) | Fictional registering healthcare provider example |
| [Patient Mracena](Patient-3f2a1b9e-6d4f-4c2e-9a7b-2d8f0b3e1c9a.md) | Patient Mracena with contact information and practitioner |
| [Serum glucose](Observation-8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3.md) | Example of a lab result – numeric, scale-based evaluation, preliminary (unreleased), accredited, urgent priority |
| [Serum sodium](Observation-2fb0c9d4-7e12-47a6-9a3b-1c5e8d2f4a76.md) | Example of a lab result not delivered due to a broken tube, with a comment on the result |
| [Serum urea](Observation-d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35.md) | Example of a numeric lab result including measurement uncertainty, scale-based evaluation, reference ranges for a female aged 15–150 years, released |
| [Urine color](Observation-5c3e9a12-4f7b-41d0-86a2-9b7e4d2f1c08.md) | Example of a lab result – free text |
| [Urine nitrites](Observation-b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56.md) | Example of a lab result – coded text |
| [Zyrgana](Patient-c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c.md) | Fictional patient for the purpose of the example |
| [deviceAnalyzerUrea](Device-device-analyzer-urea.md) | Analyzátor BioAnalyt 6000 |
| [deviceKitUrea](Device-device-kit-urea.md) | Testovací souprava Urea enzymatic assay |
| [encounter-L1](Encounter-4d2447db-6692-40cd-a440-7544d48caa08.md) | Encounter |
| [practitionerFranc](Practitioner-c2a7b9de-3b44-4e6f-9e51-9a1b8f1c82f4.md) | Fictional physician MUDr. Kvido Zýbradlo |
| [practitionerRoleFranc](PractitionerRole-3e4f8b7c-9a25-49cf-8b2a-2a8f1e7f3d66.md) | Role of MUDr. Karel Franc (requesting physician) |
| [practitionerRoleSejdlova](PractitionerRole-aabbccdd-2222-3333-dddd-112233445566.md) | Role of Mgr. Kvilda Šejdlová (performing laboratory technician) |
| [practitionerRoleZybradlo](PractitionerRole-ff223344-5566-4777-8899-ccbbccddeeff.md) | Role of MUDr. Kvido Zýbradlo (legal authenticator of the result) |
| [practitionerSejdlova](Practitioner-fab321ab-7777-4444-cccc-abcdefabcdef.md) | Fictional laboratory technician Mgr. Kvilda Šejdlová |
| [practitionerZybradlo](Practitioner-aabbccdd-1111-4222-9333-ffeeddccbbcc.md) | Fictional physician MUDr. Kvido Zýbradlo |

