# Document DiagnosticReport Reference - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Document DiagnosticReport Reference**

## Extension: Document DiagnosticReport Reference 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/composition-DiagnosticReportReference | *Version*:0.5.0 |
| Draft as of 2025-12-10 | *Computable Name*:DiagnosticReportReference |

This extension provides a reference to the DiagnosticReport instance that is associated with this document.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Composition: Laboratory Report](StructureDefinition-cz-composition-lab-report.md)
* Examples for this Extension: [Bundle/CZ-LabReport-Bundle-Example-L1](Bundle-CZ-LabReport-Bundle-Example-L1.md), [Bundle/CZ-LabReport-Bundle-Example-Min](Bundle-CZ-LabReport-Bundle-Example-Min.md), [Bundle/CZ-LabReport-Bundle-Example-ObsTypes](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md), [Bundle/CZ-LabReport-Bundle-Example-kn](Bundle-CZ-LabReport-Bundle-Example-kn.md) and [Bundle/CZ-LabReport-Bundle-Example](Bundle-CZ-LabReport-Bundle-Example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/composition-DiagnosticReportReference)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-composition-DiagnosticReportReference.csv), [Excel](StructureDefinition-composition-DiagnosticReportReference.xlsx), [Schematron](StructureDefinition-composition-DiagnosticReportReference.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "composition-DiagnosticReportReference",
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/composition-DiagnosticReportReference",
  "version" : "0.5.0",
  "name" : "DiagnosticReportReference",
  "title" : "Document DiagnosticReport Reference",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "This extension provides a reference to the DiagnosticReport instance that is associated with this document.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Composition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Document DiagnosticReport Reference",
        "definition" : "This extension provides a reference to the DiagnosticReport instance that is associated with this document."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://hl7.cz/fhir/lab/StructureDefinition/composition-DiagnosticReportReference"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/DiagnosticReport"]
          }
        ]
      }
    ]
  }
}

```
