# A.2.4 - Datové elementy výsledku vyšetření - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.4 - Datové elementy výsledku vyšetření**

## Logical Model: A.2.4 - Datové elementy výsledku vyšetření 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LogResultCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzResultLabEhnCz |

 
Datové elementy výsledku vyšetření 

**Usages:**

* Use this Logical Model: [A - Laboratorní zpráva](StructureDefinition-LogLabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LogResultCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogResultCz.csv), [Excel](StructureDefinition-LogResultCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogResultCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LogResultCz",
  "version" : "0.5.0",
  "name" : "LogCzResultLabEhnCz",
  "title" : "A.2.4 - Datové elementy výsledku vyšetření",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Datové elementy výsledku vyšetření",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LogResultCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogResultCz",
        "path" : "LogResultCz",
        "short" : "A.2.4 - Datové elementy výsledku vyšetření",
        "definition" : "Datové elementy výsledku vyšetření"
      },
      {
        "id" : "LogResultCz.textoveCasti",
        "path" : "LogResultCz.textoveCasti",
        "short" : "A.2.4.1 Textové části",
        "definition" : "A.2.4.1 Textové části",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogResultCz.textoveCasti.zprava",
        "path" : "LogResultCz.textoveCasti.zprava",
        "short" : "A.2.4.1.1 Kompletní výsledková zpráva",
        "definition" : "Kompletní laboratorní zpráva, tak jak ji laboratoř vydala.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Narrative"
          }
        ]
      },
      {
        "id" : "LogResultCz.textoveCasti.poznamky",
        "path" : "LogResultCz.textoveCasti.poznamky",
        "short" : "A.2.4.1.2 Komentáře, interpretace a doporučení",
        "definition" : "Komentáře, například textové interpretace nebo doporučení, které jsou součástí výsledkové zprávy.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Narrative"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane",
        "path" : "LogResultCz.formalizovane",
        "short" : "A.2.4.2 Formalizovaná vyšetření",
        "definition" : "A.2.4.2 Formalizovaná vyšetření ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.datumAcas",
        "path" : "LogResultCz.formalizovane.datumAcas",
        "short" : "A.2.4.2.1 Datum a čas vyšetření",
        "definition" : "Datum a čas vyšetření",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.kod",
        "path" : "LogResultCz.formalizovane.kod",
        "short" : "A.2.4.2.2 Kód vyšetření",
        "definition" : "Kód reprezentující vyšetření v rámci dohodnutého číselníku.\n- Preferované systémy: NČLP",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.jemon",
        "path" : "LogResultCz.formalizovane.jemon",
        "short" : "A.2.4.2.3 Název vyšetření",
        "definition" : "Celý název vyšetření podle použitého číselníku.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.metoda",
        "path" : "LogResultCz.formalizovane.metoda",
        "short" : "A.2.4.2.4 Metoda vyšetření",
        "definition" : "Použitá metoda vyšetření (princip měření).\n- Preferované systémy: SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.zarizeni",
        "path" : "LogResultCz.formalizovane.zarizeni",
        "short" : "A.2.4.2.5 formalizovane device",
        "definition" : "Device (analyser), laboratory test kit and used calibrator information (identifier, type, name, model, manufacturer)\n- Preferované systémy: SNOMED CT\n- Preferované systémy: EMDN",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.kit",
        "path" : "LogResultCz.formalizovane.kit",
        "short" : "A.2.4.2.6 Testovací souprava",
        "definition" : "Informace o použité testovací soupravě (test-kit) - ID, typ, název, výrobce",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.kalibrator",
        "path" : "LogResultCz.formalizovane.kalibrator",
        "short" : "A.2.4.2.7 Kalibrátor",
        "definition" : "Informace o použitém kalibrátoru (pokud nejde o základní jednotky měření, např. IU) - ID, typ, název, výrobce",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.objednavka",
        "path" : "LogResultCz.formalizovane.objednavka",
        "short" : "A.2.4.2.8 Objednávka",
        "definition" : "Identifikuje objednávku a jejího zadavatele.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.provedl",
        "path" : "LogResultCz.formalizovane.provedl",
        "short" : "A.2.4.2.9 Provedl",
        "definition" : "Identifikuje pracovníka, který provedl laboratorní vyšetření, pokud není totožný s autorem laboratorní zprávy jako celku.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.vydal",
        "path" : "LogResultCz.formalizovane.vydal",
        "short" : "A.2.4.2.10 Vydal",
        "definition" : "Používá se u některých výsledků, například tam kde musí být interpretovány nebo kde existuje osoba zodpovědná za jejich validaci.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.vysledek",
        "path" : "LogResultCz.formalizovane.vysledek",
        "short" : "A.2.4.2.11 Výsledek vyšetření",
        "definition" : "Výsledek vyšetření, zahrnuje textové, číselné i kódované výsledky a též nejistoty měření. Obsah výsledku vyšetření se může lišit v závislosti na druhu vyšetření.\n- Preferované systémy: SNOMED CT (pro výsledky na ordinální nebo nominální škále a pro interpretaci výsledků)\n- Preferované systémy: UCUM (pro jednotky)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.interpretace",
        "path" : "LogResultCz.formalizovane.interpretace",
        "short" : "A.2.4.2.12 Interpretace naměřených hodnot",
        "definition" : "Informace o referenčních intervalech a interpretaci výsledků.\n - Preferované systémy: SNOMED CT",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.popis",
        "path" : "LogResultCz.formalizovane.popis",
        "short" : "A.2.4.2.13 Popis výsledku",
        "definition" : "Komentář a textová reprezentace výsledku vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Narrative"
          }
        ]
      },
      {
        "id" : "LogResultCz.formalizovane.stavAkreditace",
        "path" : "LogResultCz.formalizovane.stavAkreditace",
        "short" : "A.2.4.2.14 Stav akreditace",
        "definition" : "Informace o akreditaci laboratoře pro příslušné vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
