# A.3 - Presented form - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.3 - Presented form**

## Logical Model: A.3 - Presented form 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LogPresentedFormCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzPresentedFormCz |

 
Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended. 

**Usages:**

* Use this Logical Model: [A - Laboratorní zpráva](StructureDefinition-LogLabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LogPresentedFormCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogPresentedFormCz.csv), [Excel](StructureDefinition-LogPresentedFormCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogPresentedFormCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LogPresentedFormCz",
  "version" : "0.5.0",
  "name" : "LogCzPresentedFormCz",
  "title" : "A.3 - Presented form",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LogPresentedFormCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogPresentedFormCz",
        "path" : "LogPresentedFormCz",
        "short" : "A.3 - Presented form",
        "definition" : "Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended."
      },
      {
        "id" : "LogPresentedFormCz.typObsahu",
        "path" : "LogPresentedFormCz.typObsahu",
        "short" : "A.3.1 - Typ obsahu",
        "definition" : "Typ obsahu - je  požadován MIME typ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPresentedFormCz.jazyk",
        "path" : "LogPresentedFormCz.jazyk",
        "short" : "A.3.2 - Jazyk obsahu",
        "definition" : "Jazyk obsahu - je požadována hodnata z HL7 valueset Languages",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPresentedFormCz.data",
        "path" : "LogPresentedFormCz.data",
        "short" : "A.3.3 - Data obsahu",
        "definition" : "Data v base64",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      },
      {
        "id" : "LogPresentedFormCz.url",
        "path" : "LogPresentedFormCz.url",
        "short" : "A.3.3 - URL obsahu",
        "definition" : "Uri kde lze data nalézt",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "url"
          }
        ]
      },
      {
        "id" : "LogPresentedFormCz.nazev",
        "path" : "LogPresentedFormCz.nazev",
        "short" : "A.3.5 - Název obsahu",
        "definition" : "Titulek, který bude zobrazen před daty",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPresentedFormCz.vytvoreni",
        "path" : "LogPresentedFormCz.vytvoreni",
        "short" : "A.3.6 - Datum vytvoření",
        "definition" : "Datum, kdy byl obsah poprvé vytvořen",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
