# Patient Mracena - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient Mracena**

## Example Patient: Patient Mracena

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Mračena Mrakomorová Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rid#2066425387)

-------

| | |
| :--- | :--- |
| Other Id: | `https://ncez.mzcr.cz/fhir/sid/rcis`/7161264528 (use: official, ) |
| Contact Detail | * [+420 603 853 227](tel:+420603853227)
* Malé náměstí 13a, 150 00, Praha 5(home)
 |
| Languages: | * Czech (preferred)
* English
* German
 |
| Links: | * General Practitioner: MUDr. Josef Švejk (Identifier: `https://ncez.mzcr.cz/fhir/sid/krzp`/123456789)
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "3f2a1b9e-6d4f-4c2e-9a7b-2d8f0b3e1c9a",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "system" : "https://ncez.mzcr.cz/fhir/sid/rcis",
      "value" : "7161264528"
    },
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "2066425387"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Mrakomorová",
      "given" : ["Mračena"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420 603 853 227",
      "use" : "home"
    }
  ],
  "gender" : "female",
  "birthDate" : "1971-11-26",
  "address" : [
    {
      "use" : "home",
      "type" : "physical",
      "text" : "Malé náměstí 13a, 150 00, Praha 5",
      "line" : ["Malé náměstí 13a"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Malé náměstí"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "13a"
            }
          ]
        }
      ],
      "city" : "Praha",
      "postalCode" : "15000",
      "country" : "Česko",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "cs"
          }
        ]
      },
      "preferred" : true
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "en"
          }
        ]
      }
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "de"
          }
        ]
      }
    }
  ],
  "generalPractitioner" : [
    {
      "identifier" : {
        "system" : "https://ncez.mzcr.cz/fhir/sid/krzp",
        "value" : "123456789"
      },
      "display" : "MUDr. Josef Švejk"
    }
  ]
}

```
