# Serum glucose - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Serum glucose**

## Example Observation: Serum glucose

Profile: [Observation Laboratory (CZ)](StructureDefinition-cz-observation-result-laboratory.md)

**Accreditation Requirement**: true

**basedOn**: [ServiceRequest 01898](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md#urn-uuid-5f9c2e8d-0b74-4dbb-8af3-3e6d2c1191a7)

**status**: Preliminary

**category**: Laboratory, Laboratory studies (set)

**code**: S_Glukóza

**subject**: [Zyrgana Prouzdalová Female, DoB: 1982-03-17 ( Passport number (use: official, ))](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md#urn-uuid-c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c)

**effective**: 2025-04-24 08:45:00+0200

**issued**: 2025-04-24 09:30:00+0200

**performer**: [Practitioner Kvilda Šejdlová](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md#urn-uuid-fab321ab-7777-4444-cccc-abcdefabcdef)

**value**: 5.2 mmol/L(Details: UCUM codemmol/L = 'mmol/L')

**interpretation**: Normal

**specimen**: [Specimen: type = Whole blood; receivedTime = 2025-04-24 07:30:00+0200](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md#urn-uuid-fa3d8c2e-71b4-4e9c-9d2f-85b0a1f7c934)

### ReferenceRanges

| | | |
| :--- | :--- | :--- |
| - | **Low** | **High** |
| * | 3.9 mmol/L(Details: UCUM codemmol/L = 'mmol/L') | 5.8 mmol/L(Details: UCUM codemmol/L = 'mmol/L') |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
    ]
  },
  "extension" : [
    {
      "url" : "https://hl7.cz/fhir/core/StructureDefinition/accreditation-cz",
      "valueBoolean" : true
    }
  ],
  "basedOn" : [
    {
      "reference" : "urn:uuid:5f9c2e8d-0b74-4dbb-8af3-3e6d2c1191a7"
    }
  ],
  "status" : "preliminary",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory",
          "display" : "Laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "26436-6"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
        "code" : "12355",
        "display" : "Glukóza (S; látková konc. [mmol/l] Absorpční spektrofotometrie)"
      }
    ],
    "text" : "S_Glukóza"
  },
  "subject" : {
    "reference" : "urn:uuid:c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c"
  },
  "effectiveDateTime" : "2025-04-24T08:45:00+02:00",
  "issued" : "2025-04-24T09:30:00+02:00",
  "performer" : [
    {
      "reference" : "urn:uuid:fab321ab-7777-4444-cccc-abcdefabcdef"
    }
  ],
  "valueQuantity" : {
    "value" : 5.2,
    "unit" : "mmol/L",
    "system" : "http://unitsofmeasure.org",
    "code" : "mmol/L"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ]
    }
  ],
  "specimen" : {
    "reference" : "urn:uuid:fa3d8c2e-71b4-4e9c-9d2f-85b0a1f7c934"
  },
  "referenceRange" : [
    {
      "low" : {
        "value" : 3.9,
        "unit" : "mmol/L",
        "system" : "http://unitsofmeasure.org",
        "code" : "mmol/L"
      },
      "high" : {
        "value" : 5.8,
        "unit" : "mmol/L",
        "system" : "http://unitsofmeasure.org",
        "code" : "mmol/L"
      }
    }
  ]
}

```
