# DiagnosticReport to Composition status - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DiagnosticReport to Composition status**

## ConceptMap: DiagnosticReport to Composition status (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ConceptMap/ConceptMap-cz-diagRptStatus2CompStatus | *Version*:0.5.0 |
| Draft as of 2025-12-10 | *Computable Name*:ConceptMapDiagRptStatus2CompStatus |

 
Proposed relationship between the statused used in the DiagnosticReport resource and that used for the Composition. 

 
It shows how to value the Composition status element based on the DiagnosticReport element. 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "ConceptMap-cz-diagRptStatus2CompStatus",
  "url" : "https://hl7.cz/fhir/lab/ConceptMap/ConceptMap-cz-diagRptStatus2CompStatus",
  "version" : "0.5.0",
  "name" : "ConceptMapDiagRptStatus2CompStatus",
  "title" : "DiagnosticReport to Composition status",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Proposed relationship between the statused used in the DiagnosticReport resource and that used for the Composition.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "It shows how to value the Composition status element based on the DiagnosticReport element.",
  "group" : [
    {
      "source" : "http://hl7.org/fhir/diagnostic-report-status",
      "sourceVersion" : "4.0.1",
      "target" : "http://hl7.org/fhir/composition-status",
      "targetVersion" : "4.0.1",
      "element" : [
        {
          "code" : "registered",
          "display" : "Registered",
          "target" : [
            {
              "code" : "preliminary",
              "display" : "Preliminary",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "partial",
          "display" : "Partial",
          "target" : [
            {
              "code" : "preliminary",
              "display" : "Preliminary",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "preliminary",
          "display" : "Preliminary",
          "target" : [
            {
              "code" : "preliminary",
              "display" : "Preliminary",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "final",
          "display" : "Final",
          "target" : [
            {
              "code" : "final",
              "display" : "Final",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "amended",
          "display" : "Amended",
          "target" : [
            {
              "code" : "amended",
              "display" : "Amended",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "corrected",
          "display" : "Corrected",
          "target" : [
            {
              "code" : "amended",
              "display" : "Amended",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "appended",
          "display" : "Appended",
          "target" : [
            {
              "code" : "amended",
              "display" : "Amended",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "cancelled",
          "display" : "Cancelled",
          "target" : [
            {
              "code" : "final",
              "display" : "Final",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "entered-in-error",
          "display" : "Entered in Error",
          "target" : [
            {
              "code" : "entered-in-error",
              "display" : "Entered in Error",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "unknown",
          "display" : "Unknown",
          "target" : [
            {
              "equivalence" : "unmatched"
            }
          ]
        }
      ]
    }
  ]
}

```
