# CZ Attachment Model to this guide Map - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CZ Attachment Model to this guide Map**

## ConceptMap: CZ Attachment Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ConceptMap/AttachmentImagingReport2FHIR-cz | *Version*:0.5.0 |
| Draft as of 2025-12-10 | *Computable Name*:AttachmentImagingReport2FHIRcz |

 
CZ Imaging Report Attachment Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "AttachmentImagingReport2FHIR-cz",
  "url" : "https://hl7.cz/fhir/lab/ConceptMap/AttachmentImagingReport2FHIR-cz",
  "version" : "0.5.0",
  "name" : "AttachmentImagingReport2FHIRcz",
  "title" : "CZ Attachment Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "CZ Imaging Report Attachment Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/PresentedFormCz",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnostic-report",
      "element" : [
        {
          "code" : "PresentedForm",
          "display" : "A.3 - Presented Form",
          "target" : [
            {
              "code" : "DiagnosticReport.presentedForm",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/PresentedFormCz",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-attachment",
      "element" : [
        {
          "code" : "PresentedForm.contentType",
          "display" : "A.3.1 - Content type of presented form",
          "target" : [
            {
              "code" : "content.contentType",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.language",
          "display" : "A.3.2 - Language of presented form",
          "target" : [
            {
              "code" : "content.language",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.data",
          "display" : "A.3.3 - Data of presented form",
          "target" : [
            {
              "code" : "content.data",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.url",
          "display" : "A.3.4 - URL of presented form",
          "target" : [
            {
              "code" : "content.url",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.title",
          "display" : "A.3.5 - Title of presented form",
          "target" : [
            {
              "code" : "content.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.creation",
          "display" : "A.3.6 - Date and time of creation",
          "target" : [
            {
              "code" : "content.creation",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/AttachmentsCz",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnostic-report",
      "element" : [
        {
          "code" : "Attachments",
          "display" : "A.4 - Attachments",
          "target" : [
            {
              "code" : "DiagnosticReport.media.link.content.attachment",
              "display" : "If it is additional MEDIA attachments",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/lab/StructureDefinition/AttachmentsCz",
      "target" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-attachment",
      "element" : [
        {
          "code" : "Attachments.contentType",
          "display" : "A.4.1 - Content type of media attachments",
          "target" : [
            {
              "code" : "content.contentType",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Attachments.language",
          "display" : "A.4.2 - Language of media attachments",
          "target" : [
            {
              "code" : "content.language",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Attachments.data",
          "display" : "A.4.3 - Data of media attachments",
          "target" : [
            {
              "code" : "content.data",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Attachments.url",
          "display" : "A.4.4 - URL of media attachments",
          "target" : [
            {
              "code" : "content.url",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Attachments.title",
          "display" : "A.4.5 - Title of media attachments",
          "target" : [
            {
              "code" : "content.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Attachments.creation",
          "display" : "A.4.6 - Date and time of creation",
          "target" : [
            {
              "code" : "content.creation",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
