# Basic Lab Report Bundle Example - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Basic Lab Report Bundle Example**

## Example Bundle: Basic Lab Report Bundle Example



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "CZ-LabReport-Bundle-Example",
  "meta" : {
    "profile" : ["https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"]
  },
  "identifier" : {
    "system" : "http://hospital.example.org/lab-results",
    "value" : "LR123456"
  },
  "type" : "document",
  "timestamp" : "2025-04-25T10:30:00+01:00",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:05f95a04-cb07-4bd2-8833-c40521f1182c",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "05f95a04-cb07-4bd2-8833-c40521f1182c",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-composition-lab-report"
          ]
        },
        "language" : "cs",
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"cs\" lang=\"cs\"><a name=\"Composition_05f95a04-cb07-4bd2-8833-c40521f1182c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition 05f95a04-cb07-4bd2-8833-c40521f1182c</b></p><a name=\"05f95a04-cb07-4bd2-8833-c40521f1182c\"> </a><a name=\"hc05f95a04-cb07-4bd2-8833-c40521f1182c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Language: cs</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-composition-lab-report.html\">Composition: Laboratory Report</a></p></div><p><b>Document DiagnosticReport Reference</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-41ae1cd0-7f48-4d86-9643-21442d8e418e\">Diagnostic Report for 'Laboratory report' for '-&gt;Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)'</a></p><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 11502-2}\">Laboratory report</span></p><p><b>category</b>: <span title=\"Codes:{http://loinc.org 26436-6}\">Laboratory studies (set)</span></p><p><b>date</b>: 2025-04-25 10:00:00+0100</p><p><b>author</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-7e243f25-5292-4f5a-9a8c-2a2a9a3e8f7f\">Practitioner Záboj Šlofák </a></p><p><b>title</b>: Laboratorní nález</p><p><b>confidentiality</b>: normal</p><p><b>custodian</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-fd0cbd93-d65e-47b2-86c9-792268a2c1ff\">Organization Nemocnice Horní Dolní</a></p></div>"
        },
        "extension" : [
          {
            "url" : "https://hl7.cz/fhir/lab/StructureDefinition/composition-DiagnosticReportReference",
            "valueReference" : {
              "reference" : "urn:uuid:41ae1cd0-7f48-4d86-9643-21442d8e418e"
            }
          }
        ],
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11502-2"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "26436-6"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "date" : "2025-04-25T10:00:00+01:00",
        "author" : [
          {
            "reference" : "urn:uuid:7e243f25-5292-4f5a-9a8c-2a2a9a3e8f7f"
          }
        ],
        "title" : "Laboratorní nález",
        "confidentiality" : "N",
        "custodian" : {
          "reference" : "urn:uuid:fd0cbd93-d65e-47b2-86c9-792268a2c1ff"
        },
        "section" : [
          {
            "title" : "Hematologie",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "18723-7"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Výsledky krevního obrazu</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:172bc194-10b5-4e82-a9c3-2936b3b2523e"
              },
              {
                "reference" : "urn:uuid:b470bdf4-93ab-42d2-b5fb-c0dc69f87c72"
              },
              {
                "reference" : "urn:uuid:a6c9f96b-23ea-4644-aadc-b11b8d3a17e2"
              },
              {
                "reference" : "urn:uuid:c4a42d64-5e43-449a-9460-3fd15cbbeff1"
              },
              {
                "reference" : "urn:uuid:9b4c7d7f-8495-42bc-877f-b9864317ed38"
              }
            ]
          },
          {
            "title" : "Biochemie",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "18719-5"
                }
              ]
            },
            "section" : [
              {
                "title" : "Základní vyšetření sérum/plazma",
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "18719-5"
                    }
                  ]
                },
                "text" : {
                  "status" : "generated",
                  "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Základní vyšetření sérum/plazma</div>"
                },
                "entry" : [
                  {
                    "reference" : "urn:uuid:ad631612-fb27-4a7c-930e-73e22aff18f1"
                  },
                  {
                    "reference" : "urn:uuid:9ba0669f-1a1e-4361-8d9b-70af9225fb4b"
                  },
                  {
                    "reference" : "urn:uuid:5e058858-c126-4f0e-9202-ece18d3c9c3e"
                  }
                ]
              },
              {
                "title" : "Markery zánětu",
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "18719-5"
                    }
                  ]
                },
                "text" : {
                  "status" : "generated",
                  "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Markery zánětu</div>"
                },
                "entry" : [
                  {
                    "reference" : "urn:uuid:e2d39425-bc9b-4fcd-88fb-3499d14d8670"
                  },
                  {
                    "reference" : "urn:uuid:f53d66a1-c9c4-4b58-b04b-3c86a2ec0c16"
                  }
                ]
              },
              {
                "title" : "Serologická vyšetření",
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "18719-5"
                    }
                  ]
                },
                "text" : {
                  "status" : "generated",
                  "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Serologická vyšetření</div>"
                },
                "entry" : [
                  {
                    "reference" : "urn:uuid:b0f7fc5d-d204-4e1c-b72f-83736e73efa4"
                  },
                  {
                    "reference" : "urn:uuid:5eb7e3de-27a2-47bc-b67c-c085343f11eb"
                  },
                  {
                    "reference" : "urn:uuid:dd34ef38-f949-4cc7-9b98-e2e3b55c84d5"
                  }
                ]
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:41ae1cd0-7f48-4d86-9643-21442d8e418e",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "41ae1cd0-7f48-4d86-9643-21442d8e418e",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnostic-report-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_41ae1cd0-7f48-4d86-9643-21442d8e418e\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DiagnosticReport 41ae1cd0-7f48-4d86-9643-21442d8e418e</b></p><a name=\"41ae1cd0-7f48-4d86-9643-21442d8e418e\"> </a><a name=\"hc41ae1cd0-7f48-4d86-9643-21442d8e418e\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-diagnostic-report-lab.html\">DiagnosticReport: Laboratory Report</a></p></div><h2><span title=\"Codes:{http://loinc.org 11502-2}\">Laboratory report</span> (<span title=\"Codes:{http://loinc.org 26436-6}\">Laboratory studies (set)</span>) </h2><table class=\"grid\"><tr><td>Subject</td><td>Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</td></tr><tr><td>When For</td><td>2025-04-24 08:45:00+0100</td></tr><tr><td>Reported</td><td>2025-04-24 09:30:00+0100</td></tr><tr><td>Performers</td><td> <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-cc8e6b12-2b99-48cf-9c3c-3c8d74805821\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a> <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></td></tr></table><p><b>Report Details</b></p><table class=\"grid\"><tr><td><b>Code</b></td><td><b>Value</b></td><td><b>Reference Range</b></td><td><b>Flags</b></td><td><b>When For</b></td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-172bc194-10b5-4e82-a9c3-2936b3b2523e\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 05143}\">Specifická hustota</span></a></td><td>1.035 kg/m3<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codekg/m3 = 'kg/m3')</span></td><td/><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></td><td>2025-04-24 08:15:00+0200</td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-b470bdf4-93ab-42d2-b5fb-c0dc69f87c72\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 03410}\">pH</span></a></td><td>6 pH<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codepH = 'pH')</span></td><td>5.5 - 7</td><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></td><td>2025-04-24 08:15:00+0200</td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-ad631612-fb27-4a7c-930e-73e22aff18f1\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 05272}\">Sodík</span></a></td><td>146.2 mmol/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></td><td/><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation H}\">High</span></td><td>2025-04-24 08:00:00+0200</td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-9ba0669f-1a1e-4361-8d9b-70af9225fb4b\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 05254}\">Draslík</span></a></td><td>3.92 mmol/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></td><td/><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></td><td>2025-04-24 08:00:00+0200</td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-5e058858-c126-4f0e-9202-ece18d3c9c3e\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 05187}\">Chloridy</span></a></td><td>115.1 mmol/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></td><td/><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation HU}\">Significantly high</span></td><td>2025-04-24 08:00:00+0200</td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-e2d39425-bc9b-4fcd-88fb-3499d14d8670\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 01522}\">C-reaktivní protein</span></a></td><td>99.7 mg/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/L = 'mg/L')</span></td><td/><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation H}\">High</span></td><td>2025-04-24 08:00:00+0200</td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-f53d66a1-c9c4-4b58-b04b-3c86a2ec0c16\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 12233}\">Prokalcitonin</span></a></td><td>0.22 µg/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeug/L = 'ug/L')</span></td><td/><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></td><td>2025-04-24 08:00:00+0200</td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-b0f7fc5d-d204-4e1c-b72f-83736e73efa4\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 19353}\">Anti-HAV IgM</span></a></td><td><span title=\"Codes:{http://snomed.info/sct 260385009}\">Negative</span></td><td/><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation NEG}\">Negative</span></td><td>2025-04-24 08:00:00+0200</td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-5eb7e3de-27a2-47bc-b67c-c085343f11eb\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 16517}\">Anti-HAV IgG</span></a></td><td><span title=\"Codes:{http://snomed.info/sct 10828004}\">Positive</span></td><td/><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation POS}\">Positive</span></td><td>2025-04-24 08:00:00+0200</td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-dd34ef38-f949-4cc7-9b98-e2e3b55c84d5\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 00384}\">anti-HCV celkové</span></a></td><td><span title=\"Codes:{http://snomed.info/sct 260385009}\">Negative</span></td><td/><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation NEG}\">Negative</span></td><td>2025-04-24 08:00:00+0200</td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-a6c9f96b-23ea-4644-aadc-b11b8d3a17e2\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 13808}\">Leukocyty</span></a></td><td>6.9 10^9/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code10*9/L = '10*9/L')</span></td><td/><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></td><td>2025-04-24 08:00:00+0200</td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-c4a42d64-5e43-449a-9460-3fd15cbbeff1\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 01675}\">Erytrocyty</span></a></td><td>3.83 10^12/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code10*12/L = '10*12/L')</span></td><td/><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></td><td>2025-04-24 08:00:00+0200</td></tr><tr><td><a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-9b4c7d7f-8495-42bc-877f-b9864317ed38\"><span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 01991}\">Hemoglobin</span></a></td><td>92 g/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeg/L = 'g/L')</span></td><td/><td>Final, <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation L}\">Low</span></td><td>2025-04-24 08:00:00+0200</td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-DiagnosticReport.composition",
            "valueReference" : {
              "reference" : "urn:uuid:05f95a04-cb07-4bd2-8833-c40521f1182c"
            }
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "26436-6"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11502-2"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:45:00+01:00",
        "issued" : "2025-04-24T09:30:00+01:00",
        "performer" : [
          {
            "reference" : "urn:uuid:cc8e6b12-2b99-48cf-9c3c-3c8d74805821"
          },
          {
            "reference" : "urn:uuid:a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a"
          }
        ],
        "specimen" : [
          {
            "reference" : "urn:uuid:9014ce97-a357-4a4a-b0e0-32e7ba85801d"
          },
          {
            "reference" : "urn:uuid:b7a2f9d3-760f-4a89-bbbf-12199808f2e5"
          },
          {
            "reference" : "urn:uuid:04bb3e5b-83fb-41a5-b260-c91cdba5df80"
          }
        ],
        "result" : [
          {
            "reference" : "urn:uuid:172bc194-10b5-4e82-a9c3-2936b3b2523e"
          },
          {
            "reference" : "urn:uuid:b470bdf4-93ab-42d2-b5fb-c0dc69f87c72"
          },
          {
            "reference" : "urn:uuid:ad631612-fb27-4a7c-930e-73e22aff18f1"
          },
          {
            "reference" : "urn:uuid:9ba0669f-1a1e-4361-8d9b-70af9225fb4b"
          },
          {
            "reference" : "urn:uuid:5e058858-c126-4f0e-9202-ece18d3c9c3e"
          },
          {
            "reference" : "urn:uuid:e2d39425-bc9b-4fcd-88fb-3499d14d8670"
          },
          {
            "reference" : "urn:uuid:f53d66a1-c9c4-4b58-b04b-3c86a2ec0c16"
          },
          {
            "reference" : "urn:uuid:b0f7fc5d-d204-4e1c-b72f-83736e73efa4"
          },
          {
            "reference" : "urn:uuid:5eb7e3de-27a2-47bc-b67c-c085343f11eb"
          },
          {
            "reference" : "urn:uuid:dd34ef38-f949-4cc7-9b98-e2e3b55c84d5"
          },
          {
            "reference" : "urn:uuid:a6c9f96b-23ea-4644-aadc-b11b8d3a17e2"
          },
          {
            "reference" : "urn:uuid:c4a42d64-5e43-449a-9460-3fd15cbbeff1"
          },
          {
            "reference" : "urn:uuid:9b4c7d7f-8495-42bc-877f-b9864317ed38"
          }
        ],
        "presentedForm" : [
          {
            "contentType" : "application/pdf",
            "language" : "cs",
            "data" : "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"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "11af8e2a-3e10-426e-b80f-4c9f9c7de3c9",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 11af8e2a-3e10-426e-b80f-4c9f9c7de3c9</b></p><a name=\"11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\"> </a><a name=\"hc11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html\">Patient (CZ core)</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Other Id (see the one above)\">Other Id:</td><td colspan=\"3\"><code>https://ncez.mzcr.cz/fhir/sid/cpoj</code>/0998877665 (use: official, )</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li><a href=\"tel:+420777000999\">+420777000999</a></li><li><a href=\"mailto:drahovin.Virelan@example.cz\">drahovin.Virelan@example.cz</a></li><li>U Křivého stromu 99, 99999 Dolejší Lhoty(home)</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The nationality of the patient.\">Patient Nationality:</td><td colspan=\"3\"><ul><li>code: <span title=\"Codes:{urn:iso:std:iso:3166 CZ}\">Czechia</span></li></ul></td></tr></table></div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "CZ"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-nationality"
          }
        ],
        "identifier" : [
          {
            "use" : "official",
            "system" : "https://ncez.mzcr.cz/fhir/sid/cpoj",
            "value" : "0998877665"
          },
          {
            "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
            "value" : "1234567890"
          }
        ],
        "name" : [
          {
            "use" : "usual",
            "family" : "Drahovín",
            "given" : ["Virelan"],
            "prefix" : ["Bc."]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+420777000999",
            "use" : "mobile"
          },
          {
            "system" : "email",
            "value" : "drahovin.Virelan@example.cz",
            "use" : "home"
          }
        ],
        "gender" : "male",
        "birthDate" : "1980-01-23",
        "address" : [
          {
            "use" : "home",
            "type" : "physical",
            "text" : "U Křivého stromu 99, 99999 Dolejší Lhoty",
            "line" : ["U Křivého stromu 99"],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "U Křivého stromu"
                  },
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "99"
                  }
                ]
              }
            ],
            "city" : "Dolejší Lhoty",
            "postalCode" : "99999",
            "country" : "Česko",
            "_country" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
                  "valueCoding" : {
                    "system" : "urn:iso:std:iso:3166",
                    "code" : "CZ",
                    "display" : "Czechia"
                  }
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:8d08dca4-bf95-4b46-bcb4-e5b127aa2e30",
      "resource" : {
        "resourceType" : "Coverage",
        "id" : "8d08dca4-bf95-4b46-bcb4-e5b127aa2e30",
        "meta" : {
          "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-coverage"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Coverage_8d08dca4-bf95-4b46-bcb4-e5b127aa2e30\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Coverage 8d08dca4-bf95-4b46-bcb4-e5b127aa2e30</b></p><a name=\"8d08dca4-bf95-4b46-bcb4-e5b127aa2e30\"> </a><a name=\"hc8d08dca4-bf95-4b46-bcb4-e5b127aa2e30\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-coverage.html\">Coverage (CZ)</a></p></div><p><b>identifier</b>: <code>https://ncez.mzcr.cz/fhir/sid/rc</code>/8001231234 (use: official, )</p><p><b>status</b>: Active</p><p><b>beneficiary</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>payor</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-abcdef12-3456-7890-abcd-1234567890ab\">Organization Všeobecná zdravotní pojišťovna ČR</a></p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "https://ncez.mzcr.cz/fhir/sid/rc",
            "value" : "8001231234"
          }
        ],
        "status" : "active",
        "beneficiary" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "payor" : [
          {
            "reference" : "urn:uuid:abcdef12-3456-7890-abcd-1234567890ab"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:7e243f25-5292-4f5a-9a8c-2a2a9a3e8f7f",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "7e243f25-5292-4f5a-9a8c-2a2a9a3e8f7f",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_7e243f25-5292-4f5a-9a8c-2a2a9a3e8f7f\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 7e243f25-5292-4f5a-9a8c-2a2a9a3e8f7f</b></p><a name=\"7e243f25-5292-4f5a-9a8c-2a2a9a3e8f7f\"> </a><a name=\"hc7e243f25-5292-4f5a-9a8c-2a2a9a3e8f7f\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html\">Practitioner (CZ core)</a></p></div><p><b>identifier</b>: <code>https://ncez.mzcr.cz/fhir/sid/krzp</code>/123456789</p><p><b>name</b>: Záboj Šlofák </p><p><b>gender</b>: Male</p></div>"
        },
        "identifier" : [
          {
            "system" : "https://ncez.mzcr.cz/fhir/sid/krzp",
            "value" : "123456789"
          }
        ],
        "name" : [
          {
            "use" : "usual",
            "family" : "Šlofák",
            "given" : ["Záboj"],
            "prefix" : ["MUDr."]
          }
        ],
        "gender" : "male"
      }
    },
    {
      "fullUrl" : "urn:uuid:fa4f28b1-1234-4f78-9cda-dcf01f228acf",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "fa4f28b1-1234-4f78-9cda-dcf01f228acf",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_fa4f28b1-1234-4f78-9cda-dcf01f228acf\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner fa4f28b1-1234-4f78-9cda-dcf01f228acf</b></p><a name=\"fa4f28b1-1234-4f78-9cda-dcf01f228acf\"> </a><a name=\"hcfa4f28b1-1234-4f78-9cda-dcf01f228acf\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html\">Practitioner (CZ core)</a></p></div><p><b>identifier</b>: <code>https://ncez.mzcr.cz/fhir/sid/krzp</code>/987654321</p><p><b>name</b>: Milbožena Hrčálková </p><p><b>gender</b>: Female</p></div>"
        },
        "identifier" : [
          {
            "system" : "https://ncez.mzcr.cz/fhir/sid/krzp",
            "value" : "987654321"
          }
        ],
        "name" : [
          {
            "use" : "usual",
            "family" : "Hrčálková",
            "given" : ["Milbožena"],
            "prefix" : ["MUDr."]
          }
        ],
        "gender" : "female"
      }
    },
    {
      "fullUrl" : "urn:uuid:cc8e6b12-2b99-48cf-9c3c-3c8d74805821",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "cc8e6b12-2b99-48cf-9c3c-3c8d74805821",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_cc8e6b12-2b99-48cf-9c3c-3c8d74805821\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole cc8e6b12-2b99-48cf-9c3c-3c8d74805821</b></p><a name=\"cc8e6b12-2b99-48cf-9c3c-3c8d74805821\"> </a><a name=\"hccc8e6b12-2b99-48cf-9c3c-3c8d74805821\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html\">Practitioner Role (CZ core)</a></p></div><p><b>active</b>: true</p><p><b>practitioner</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-7e243f25-5292-4f5a-9a8c-2a2a9a3e8f7f\">Practitioner Záboj Šlofák </a></p><p><b>organization</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-fd0cbd93-d65e-47b2-86c9-792268a2c1ff\">Organization Nemocnice Horní Dolní</a></p><p><b>code</b>: <span title=\"Codes:{https://ncez.mzcr.cz/terminology/CodeSystem/nrzp-povolani NL25}\">Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</span></p><p><b>telecom</b>: <a href=\"tel:+420775111222\">+420775111222</a></p></div>"
        },
        "active" : true,
        "practitioner" : {
          "reference" : "urn:uuid:7e243f25-5292-4f5a-9a8c-2a2a9a3e8f7f"
        },
        "organization" : {
          "reference" : "urn:uuid:fd0cbd93-d65e-47b2-86c9-792268a2c1ff"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/nrzp-povolani",
                "code" : "NL25",
                "display" : "Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků"
              }
            ]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+420775111222"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a</b></p><a name=\"a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\"> </a><a name=\"hca03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html\">Practitioner Role (CZ core)</a></p></div><p><b>active</b>: true</p><p><b>practitioner</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-fa4f28b1-1234-4f78-9cda-dcf01f228acf\">Practitioner Milbožena Hrčálková </a></p><p><b>organization</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-fd0cbd93-d65e-47b2-86c9-792268a2c1ff\">Organization Nemocnice Horní Dolní</a></p><p><b>code</b>: <span title=\"Codes:{https://ncez.mzcr.cz/terminology/CodeSystem/nrzp-povolani NL25}\">Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</span></p><p><b>telecom</b>: <a href=\"mailto:milbozena.hrcalkova@vzor-nemocnice.cz\">milbozena.hrcalkova@vzor-nemocnice.cz</a></p></div>"
        },
        "active" : true,
        "practitioner" : {
          "reference" : "urn:uuid:fa4f28b1-1234-4f78-9cda-dcf01f228acf"
        },
        "organization" : {
          "reference" : "urn:uuid:fd0cbd93-d65e-47b2-86c9-792268a2c1ff"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/nrzp-povolani",
                "code" : "NL25",
                "display" : "Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků"
              }
            ]
          }
        ],
        "telecom" : [
          {
            "system" : "email",
            "value" : "milbozena.hrcalkova@vzor-nemocnice.cz"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:fd0cbd93-d65e-47b2-86c9-792268a2c1ff",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "fd0cbd93-d65e-47b2-86c9-792268a2c1ff",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_fd0cbd93-d65e-47b2-86c9-792268a2c1ff\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization fd0cbd93-d65e-47b2-86c9-792268a2c1ff</b></p><a name=\"fd0cbd93-d65e-47b2-86c9-792268a2c1ff\"> </a><a name=\"hcfd0cbd93-d65e-47b2-86c9-792268a2c1ff\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html\">Organization (CZ core)</a></p></div><p><b>identifier</b>: <code>https://ncez.mzcr.cz/fhir/sid/ico</code>/12345678, <code>https://ncez.mzcr.cz/fhir/sid/krpzs</code>/ICZ123456</p><p><b>active</b>: true</p><p><b>name</b>: Nemocnice Horní Dolní</p><p><b>telecom</b>: <a href=\"tel:+420555123456\">+420555123456</a>, <a href=\"mailto:info@horni-dolni.eu\">info@horni-dolni.eu</a></p><p><b>address</b>: Masarykova 1 Horní Dolní 12345 Česko (work)</p></div>"
        },
        "identifier" : [
          {
            "system" : "https://ncez.mzcr.cz/fhir/sid/ico",
            "value" : "12345678"
          },
          {
            "system" : "https://ncez.mzcr.cz/fhir/sid/krpzs",
            "value" : "ICZ123456"
          }
        ],
        "active" : true,
        "name" : "Nemocnice Horní Dolní",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+420555123456"
          },
          {
            "system" : "email",
            "value" : "info@horni-dolni.eu"
          }
        ],
        "address" : [
          {
            "use" : "work",
            "line" : ["Masarykova 1"],
            "city" : "Horní Dolní",
            "postalCode" : "12345",
            "country" : "Česko",
            "_country" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
                  "valueCoding" : {
                    "system" : "urn:iso:std:iso:3166",
                    "code" : "CZ",
                    "display" : "Czechia"
                  }
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:abcdef12-3456-7890-abcd-1234567890ab",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "abcdef12-3456-7890-abcd-1234567890ab",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_abcdef12-3456-7890-abcd-1234567890ab\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization abcdef12-3456-7890-abcd-1234567890ab</b></p><a name=\"abcdef12-3456-7890-abcd-1234567890ab\"> </a><a name=\"hcabcdef12-3456-7890-abcd-1234567890ab\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html\">Organization (CZ core)</a></p></div><p><b>identifier</b>: <code>https://ncez.mzcr.cz/fhir/sid/kp</code>/111</p><p><b>name</b>: Všeobecná zdravotní pojišťovna ČR</p></div>"
        },
        "identifier" : [
          {
            "system" : "https://ncez.mzcr.cz/fhir/sid/kp",
            "value" : "111"
          }
        ],
        "name" : "Všeobecná zdravotní pojišťovna ČR"
      }
    },
    {
      "fullUrl" : "urn:uuid:9014ce97-a357-4a4a-b0e0-32e7ba85801d",
      "resource" : {
        "resourceType" : "Specimen",
        "id" : "9014ce97-a357-4a4a-b0e0-32e7ba85801d",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab"
          ]
        },
        "text" : {
          "status" : "empty",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Specimen_9014ce97-a357-4a4a-b0e0-32e7ba85801d\"> </a>-</div>"
        },
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0487",
              "code" : "BLDV",
              "display" : "Blood venous"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "receivedTime" : "2025-04-24T09:30:00+02:00",
        "collection" : {
          "collectedDateTime" : "2025-04-24T08:00:00+02:00"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:b7a2f9d3-760f-4a89-bbbf-12199808f2e5",
      "resource" : {
        "resourceType" : "Specimen",
        "id" : "b7a2f9d3-760f-4a89-bbbf-12199808f2e5",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab"
          ]
        },
        "text" : {
          "status" : "empty",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Specimen_b7a2f9d3-760f-4a89-bbbf-12199808f2e5\"> </a>Vzorek nesrážlivé žilní krve pro hematologii</div>"
        },
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0487",
              "code" : "BLDV",
              "display" : "Blood venous"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "receivedTime" : "2025-04-24T09:30:00+02:00",
        "collection" : {
          "collectedDateTime" : "2025-04-24T08:00:00+02:00"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:04bb3e5b-83fb-41a5-b260-c91cdba5df80",
      "resource" : {
        "resourceType" : "Specimen",
        "id" : "04bb3e5b-83fb-41a5-b260-c91cdba5df80",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab"
          ]
        },
        "text" : {
          "status" : "empty",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Specimen_04bb3e5b-83fb-41a5-b260-c91cdba5df80\"> </a>-</div>"
        },
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0487",
              "code" : "URINM",
              "display" : "Urine, Midstream"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "receivedTime" : "2025-04-24T09:30:00+02:00",
        "collection" : {
          "collectedDateTime" : "2025-04-24T08:15:00+02:00"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:172bc194-10b5-4e82-a9c3-2936b3b2523e",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "172bc194-10b5-4e82-a9c3-2936b3b2523e",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_172bc194-10b5-4e82-a9c3-2936b3b2523e\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation 172bc194-10b5-4e82-a9c3-2936b3b2523e</b></p><a name=\"172bc194-10b5-4e82-a9c3-2936b3b2523e\"> </a><a name=\"hc172bc194-10b5-4e82-a9c3-2936b3b2523e\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 05143}\">Specifická hustota</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:15:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: 1.035 kg/m3<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codekg/m3 = 'kg/m3')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-04bb3e5b-83fb-41a5-b260-c91cdba5df80\">Specimen: type = Urine, Midstream; receivedTime = 2025-04-24 09:30:00+0200</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "05143"
            }
          ],
          "text" : "Specifická hustota"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:15:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a"
          }
        ],
        "valueQuantity" : {
          "value" : 1.035,
          "system" : "http://unitsofmeasure.org",
          "code" : "kg/m3"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:04bb3e5b-83fb-41a5-b260-c91cdba5df80"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:b470bdf4-93ab-42d2-b5fb-c0dc69f87c72",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "b470bdf4-93ab-42d2-b5fb-c0dc69f87c72",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_b470bdf4-93ab-42d2-b5fb-c0dc69f87c72\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation b470bdf4-93ab-42d2-b5fb-c0dc69f87c72</b></p><a name=\"b470bdf4-93ab-42d2-b5fb-c0dc69f87c72\"> </a><a name=\"hcb470bdf4-93ab-42d2-b5fb-c0dc69f87c72\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 03410}\">pH</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:15:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: 6 pH<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codepH = 'pH')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-04bb3e5b-83fb-41a5-b260-c91cdba5df80\">Specimen: type = Urine, Midstream; receivedTime = 2025-04-24 09:30:00+0200</a></p><h3>ReferenceRanges</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Low</b></td><td><b>High</b></td></tr><tr><td style=\"display: none\">*</td><td>5.5</td><td>7</td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "03410"
            }
          ],
          "text" : "pH"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:15:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a"
          }
        ],
        "valueQuantity" : {
          "value" : 6,
          "unit" : "pH",
          "system" : "http://unitsofmeasure.org",
          "code" : "pH"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:04bb3e5b-83fb-41a5-b260-c91cdba5df80"
        },
        "referenceRange" : [
          {
            "low" : {
              "value" : 5.5
            },
            "high" : {
              "value" : 7
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:ad631612-fb27-4a7c-930e-73e22aff18f1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "ad631612-fb27-4a7c-930e-73e22aff18f1",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_ad631612-fb27-4a7c-930e-73e22aff18f1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation ad631612-fb27-4a7c-930e-73e22aff18f1</b></p><a name=\"ad631612-fb27-4a7c-930e-73e22aff18f1\"> </a><a name=\"hcad631612-fb27-4a7c-930e-73e22aff18f1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 05272}\">Sodík</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:00:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: 146.2 mmol/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation H}\">High</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-9014ce97-a357-4a4a-b0e0-32e7ba85801d\">Specimen: type = Blood venous; receivedTime = 2025-04-24 09:30:00+0200</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "05272"
            }
          ],
          "text" : "Sodík"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:00:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a"
          }
        ],
        "valueQuantity" : {
          "value" : 146.2,
          "unit" : "mmol/L",
          "system" : "http://unitsofmeasure.org",
          "code" : "mmol/L"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "H",
                "display" : "High"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:9014ce97-a357-4a4a-b0e0-32e7ba85801d"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:9ba0669f-1a1e-4361-8d9b-70af9225fb4b",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "9ba0669f-1a1e-4361-8d9b-70af9225fb4b",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_9ba0669f-1a1e-4361-8d9b-70af9225fb4b\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation 9ba0669f-1a1e-4361-8d9b-70af9225fb4b</b></p><a name=\"9ba0669f-1a1e-4361-8d9b-70af9225fb4b\"> </a><a name=\"hc9ba0669f-1a1e-4361-8d9b-70af9225fb4b\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 05254}\">Draslík</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:00:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: 3.92 mmol/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-9014ce97-a357-4a4a-b0e0-32e7ba85801d\">Specimen: type = Blood venous; receivedTime = 2025-04-24 09:30:00+0200</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "05254"
            }
          ],
          "text" : "Draslík"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:00:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a"
          }
        ],
        "valueQuantity" : {
          "value" : 3.92,
          "unit" : "mmol/L",
          "system" : "http://unitsofmeasure.org",
          "code" : "mmol/L"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:9014ce97-a357-4a4a-b0e0-32e7ba85801d"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:5e058858-c126-4f0e-9202-ece18d3c9c3e",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "5e058858-c126-4f0e-9202-ece18d3c9c3e",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_5e058858-c126-4f0e-9202-ece18d3c9c3e\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation 5e058858-c126-4f0e-9202-ece18d3c9c3e</b></p><a name=\"5e058858-c126-4f0e-9202-ece18d3c9c3e\"> </a><a name=\"hc5e058858-c126-4f0e-9202-ece18d3c9c3e\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 05187}\">Chloridy</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:00:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: 115.1 mmol/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemmol/L = 'mmol/L')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation HU}\">Significantly high</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-9014ce97-a357-4a4a-b0e0-32e7ba85801d\">Specimen: type = Blood venous; receivedTime = 2025-04-24 09:30:00+0200</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "05187"
            }
          ],
          "text" : "Chloridy"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:00:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a"
          }
        ],
        "valueQuantity" : {
          "value" : 115.1,
          "unit" : "mmol/L",
          "system" : "http://unitsofmeasure.org",
          "code" : "mmol/L"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "HU",
                "display" : "Significantly high"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:9014ce97-a357-4a4a-b0e0-32e7ba85801d"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:e2d39425-bc9b-4fcd-88fb-3499d14d8670",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "e2d39425-bc9b-4fcd-88fb-3499d14d8670",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_e2d39425-bc9b-4fcd-88fb-3499d14d8670\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation e2d39425-bc9b-4fcd-88fb-3499d14d8670</b></p><a name=\"e2d39425-bc9b-4fcd-88fb-3499d14d8670\"> </a><a name=\"hce2d39425-bc9b-4fcd-88fb-3499d14d8670\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 01522}\">C-reaktivní protein</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:00:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: 99.7 mg/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/L = 'mg/L')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation H}\">High</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-9014ce97-a357-4a4a-b0e0-32e7ba85801d\">Specimen: type = Blood venous; receivedTime = 2025-04-24 09:30:00+0200</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "01522"
            }
          ],
          "text" : "C-reaktivní protein"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:00:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a"
          }
        ],
        "valueQuantity" : {
          "value" : 99.7,
          "unit" : "mg/L",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/L"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "H",
                "display" : "High"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:9014ce97-a357-4a4a-b0e0-32e7ba85801d"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:f53d66a1-c9c4-4b58-b04b-3c86a2ec0c16",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "f53d66a1-c9c4-4b58-b04b-3c86a2ec0c16",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_f53d66a1-c9c4-4b58-b04b-3c86a2ec0c16\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation f53d66a1-c9c4-4b58-b04b-3c86a2ec0c16</b></p><a name=\"f53d66a1-c9c4-4b58-b04b-3c86a2ec0c16\"> </a><a name=\"hcf53d66a1-c9c4-4b58-b04b-3c86a2ec0c16\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 12233}\">Prokalcitonin</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:00:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: 0.22 µg/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeug/L = 'ug/L')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-9014ce97-a357-4a4a-b0e0-32e7ba85801d\">Specimen: type = Blood venous; receivedTime = 2025-04-24 09:30:00+0200</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "12233"
            }
          ],
          "text" : "Prokalcitonin"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:00:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a"
          }
        ],
        "valueQuantity" : {
          "value" : 0.22,
          "unit" : "µg/L",
          "system" : "http://unitsofmeasure.org",
          "code" : "ug/L"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:9014ce97-a357-4a4a-b0e0-32e7ba85801d"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:b0f7fc5d-d204-4e1c-b72f-83736e73efa4",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "b0f7fc5d-d204-4e1c-b72f-83736e73efa4",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_b0f7fc5d-d204-4e1c-b72f-83736e73efa4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation b0f7fc5d-d204-4e1c-b72f-83736e73efa4</b></p><a name=\"b0f7fc5d-d204-4e1c-b72f-83736e73efa4\"> </a><a name=\"hcb0f7fc5d-d204-4e1c-b72f-83736e73efa4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 19353}\">Anti-HAV IgM</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:00:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 260385009}\">Negative</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation NEG}\">Negative</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-9014ce97-a357-4a4a-b0e0-32e7ba85801d\">Specimen: type = Blood venous; receivedTime = 2025-04-24 09:30:00+0200</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "19353"
            }
          ],
          "text" : "Anti-HAV IgM"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:00:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "260385009",
              "display" : "Negative"
            }
          ]
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "NEG",
                "display" : "Negative"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:9014ce97-a357-4a4a-b0e0-32e7ba85801d"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:5eb7e3de-27a2-47bc-b67c-c085343f11eb",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "5eb7e3de-27a2-47bc-b67c-c085343f11eb",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_5eb7e3de-27a2-47bc-b67c-c085343f11eb\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation 5eb7e3de-27a2-47bc-b67c-c085343f11eb</b></p><a name=\"5eb7e3de-27a2-47bc-b67c-c085343f11eb\"> </a><a name=\"hc5eb7e3de-27a2-47bc-b67c-c085343f11eb\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 16517}\">Anti-HAV IgG</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:00:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 10828004}\">Positive</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation POS}\">Positive</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-9014ce97-a357-4a4a-b0e0-32e7ba85801d\">Specimen: type = Blood venous; receivedTime = 2025-04-24 09:30:00+0200</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "16517"
            }
          ],
          "text" : "Anti-HAV IgG"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:00:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "10828004",
              "display" : "Positive"
            }
          ]
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "POS",
                "display" : "Positive"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:9014ce97-a357-4a4a-b0e0-32e7ba85801d"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:dd34ef38-f949-4cc7-9b98-e2e3b55c84d5",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "dd34ef38-f949-4cc7-9b98-e2e3b55c84d5",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_dd34ef38-f949-4cc7-9b98-e2e3b55c84d5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation dd34ef38-f949-4cc7-9b98-e2e3b55c84d5</b></p><a name=\"dd34ef38-f949-4cc7-9b98-e2e3b55c84d5\"> </a><a name=\"hcdd34ef38-f949-4cc7-9b98-e2e3b55c84d5\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 00384}\">anti-HCV celkové</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:00:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 260385009}\">Negative</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation NEG}\">Negative</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-9014ce97-a357-4a4a-b0e0-32e7ba85801d\">Specimen: type = Blood venous; receivedTime = 2025-04-24 09:30:00+0200</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "00384"
            }
          ],
          "text" : "anti-HCV celkové"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:00:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:a03d1fcb-c3dc-4c3f-803f-3b7ae3b5e47a"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "260385009",
              "display" : "Negative"
            }
          ]
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "NEG",
                "display" : "Negative"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:9014ce97-a357-4a4a-b0e0-32e7ba85801d"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:a6c9f96b-23ea-4644-aadc-b11b8d3a17e2",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "a6c9f96b-23ea-4644-aadc-b11b8d3a17e2",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_a6c9f96b-23ea-4644-aadc-b11b8d3a17e2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation a6c9f96b-23ea-4644-aadc-b11b8d3a17e2</b></p><a name=\"a6c9f96b-23ea-4644-aadc-b11b8d3a17e2\"> </a><a name=\"hca6c9f96b-23ea-4644-aadc-b11b8d3a17e2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 13808}\">Leukocyty</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:00:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-cc8e6b12-2b99-48cf-9c3c-3c8d74805821\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: 6.9 10^9/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code10*9/L = '10*9/L')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-b7a2f9d3-760f-4a89-bbbf-12199808f2e5\">Specimen: type = Blood venous; receivedTime = 2025-04-24 09:30:00+0200</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "13808"
            }
          ],
          "text" : "Leukocyty"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:00:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:cc8e6b12-2b99-48cf-9c3c-3c8d74805821"
          }
        ],
        "valueQuantity" : {
          "value" : 6.9,
          "unit" : "10^9/L",
          "system" : "http://unitsofmeasure.org",
          "code" : "10*9/L"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:b7a2f9d3-760f-4a89-bbbf-12199808f2e5"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:c4a42d64-5e43-449a-9460-3fd15cbbeff1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "c4a42d64-5e43-449a-9460-3fd15cbbeff1",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_c4a42d64-5e43-449a-9460-3fd15cbbeff1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation c4a42d64-5e43-449a-9460-3fd15cbbeff1</b></p><a name=\"c4a42d64-5e43-449a-9460-3fd15cbbeff1\"> </a><a name=\"hcc4a42d64-5e43-449a-9460-3fd15cbbeff1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 01675}\">Erytrocyty</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:00:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-cc8e6b12-2b99-48cf-9c3c-3c8d74805821\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: 3.83 10^12/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code10*12/L = '10*12/L')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation N}\">Normal</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-b7a2f9d3-760f-4a89-bbbf-12199808f2e5\">Specimen: type = Blood venous; receivedTime = 2025-04-24 09:30:00+0200</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "01675"
            }
          ],
          "text" : "Erytrocyty"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:00:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:cc8e6b12-2b99-48cf-9c3c-3c8d74805821"
          }
        ],
        "valueQuantity" : {
          "value" : 3.83,
          "unit" : "10^12/L",
          "system" : "http://unitsofmeasure.org",
          "code" : "10*12/L"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "N",
                "display" : "Normal"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:b7a2f9d3-760f-4a89-bbbf-12199808f2e5"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:9b4c7d7f-8495-42bc-877f-b9864317ed38",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "9b4c7d7f-8495-42bc-877f-b9864317ed38",
        "meta" : {
          "profile" : [
            "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_9b4c7d7f-8495-42bc-877f-b9864317ed38\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation 9b4c7d7f-8495-42bc-877f-b9864317ed38</b></p><a name=\"9b4c7d7f-8495-42bc-877f-b9864317ed38\"> </a><a name=\"hc9b4c7d7f-8495-42bc-877f-b9864317ed38\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-cz-observation-result-laboratory.html\">Observation Laboratory (CZ)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{https://nclp.ncez.mzcr.cz/CodeSystem/nclppol 01991}\">Hemoglobin</span></p><p><b>subject</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-11af8e2a-3e10-426e-b80f-4c9f9c7de3c9\">Virelan Drahovín  Male, DoB: 1980-01-23 ( https://ncez.mzcr.cz/fhir/sid/rid#1234567890)</a></p><p><b>effective</b>: 2025-04-24 08:00:00+0200</p><p><b>performer</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-cc8e6b12-2b99-48cf-9c3c-3c8d74805821\">PractitionerRole Odborný pracovník v laboratorních metodách a v přípravě léčivých přípravků</a></p><p><b>value</b>: 92 g/L<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeg/L = 'g/L')</span></p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation L}\">Low</span></p><p><b>specimen</b>: <a href=\"Bundle-CZ-LabReport-Bundle-Example.html#urn-uuid-b7a2f9d3-760f-4a89-bbbf-12199808f2e5\">Specimen: type = Blood venous; receivedTime = 2025-04-24 09:30:00+0200</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
              "code" : "01991"
            }
          ],
          "text" : "Hemoglobin"
        },
        "subject" : {
          "reference" : "urn:uuid:11af8e2a-3e10-426e-b80f-4c9f9c7de3c9"
        },
        "effectiveDateTime" : "2025-04-24T08:00:00+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:cc8e6b12-2b99-48cf-9c3c-3c8d74805821"
          }
        ],
        "valueQuantity" : {
          "value" : 92,
          "unit" : "g/L",
          "system" : "http://unitsofmeasure.org",
          "code" : "g/L"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "L",
                "display" : "Low"
              }
            ]
          }
        ],
        "specimen" : {
          "reference" : "urn:uuid:b7a2f9d3-760f-4a89-bbbf-12199808f2e5"
        }
      }
    }
  ]
}

```
