# Příklady užití - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* **Příklady užití**

## Příklady užití

### Společní aktéři laboratorní domény

Aktéři popisovaní v této kapitole reprezentují formu abstrakce uživatelů a informačních systémů, kteří se zapojují do různých laboratorních procesů. Jména aktérů vycházejí z dokumentace relevantních IHE profilů (XDS, XD-LAB).

**Objednatel** (Order Placer): Order Placer představuje specializovanou softwarovou aplikaci pro tvorbu žádanek laboratorních vyšetření, která umožnuje tvorbu a předání objednávky do laboratoře.

**Zpracovatel** (Order Filler): Order Filler je laboratorní aplikace odpovědná za rozdělení každé objednávky nebo skupiny objednávek, které obdržela od Order Placer aplikace, a to na vhodné sady pracovních příkazů pro jednotlivé části laboratoře. Tyto příkazy jsou předány příslušné komponentě informačního systému laboratoře zodpovědné za provedení vyšetření a registraci výsledků (Automation Manager). Po obdržení výsledků testů provede Order Filler jejich konsolidaci dle příslušné objednávky nebo skupiny objednávek, zajistí validaci a předání do Order Result Tracker aplikace na klinické straně.

**LIMS** (Automation Manager): Automation Manager je implementován jako součást laboratorního informačního systému a zodpovídá za provádění analýz vzorků a zaznamenání výsledků testů. Automation Manager řídí automatizaci v celé laboratoři nebo její části. Automatizace zahrnuje integraci a propojení automatických nebo robotických transportních systémů, analytických systému a zařízení provádějící pre – nebo post-analytické procesy, jako jsou automatické centrifugy, zařízení na alikvotaci vzorků, odstraňování nebo nasazování víček, třídičky a systémy na ukládání a uchovávání vzorků. Přijímá pracovní příkazy od Order Filler. Řídí zpracování objednaných testů v příslušných analyzátorech a odesílá technicky validované výsledky zpět do aplikace Order Filler.

**Příjemce výsledků** (Order Result Tracker): Systém, který přijímá výsledky testů a zaznamenává všechny změny stavů výsledků oznámených aplikací Order Filler. Měření jsou vždy uložena v kontextu objednávky, která jejich provedení požaduje, a se všemi informacemi, které se k příslušné objednávce pojí. Order Result Tracker pracuje s výsledkovými zprávami obdrženými z laboratoře. Může být také centrálním/regionálním nebo lokálním uložištěm dokumentů (EHR), z něhož může objednatel nebo jiná oprávněná osoba později výsledky vyzvednout.

Do výsledků může nahlížet nebo je obdržet také pacient.

**Zdroj dokumentu** (Document source): Zdroj dokumentu je tvůrce a vydavatel dokumentu. Je odpovědný za předávání dokumentů do uložiště dokumentů (viz následující aktér). Též poskytuje metadata pro uložiště dokumentů pro jejich následnou registraci v registru dokumentů (viz aktér uvedený níže).

**Uživatel dokumentu** (Document consumer): Uživatel dokumentu dotazuje registr dokumentů k vydání dokumentů, které splňují zadáná kritéria, a získává vybrané dokumenty z jednoho nebo více uložišť dokumentů.

**Registr dokumentů** (Document registry): Registr dokumentů uchovává metadata o každém registrovaném dokumentu v jeho položce. To může také zahrnovat odkaz na dokument v uložišti, kde je uchováván. Registr dokumentů odpovídá na dotazy od uživatele dokumentu týkající se dokumentů, které splňují specifická kritéria. Při registraci dokumentu také vyžaduje některá technická pravidla specifické pro zdravotní péči.

**Uložiště dokumentů** (Document repository): Uložiště dokumentů je odpovědné jak za jejich trvalé uložení, tak za jejich registraci v příslušném registru dokumentů. Dokumentům přiřazuje specifické Id sloužící k pozdějšímu vyhledávání a získávaní dokumentů uživatelem dokumentu.

### Popis use case „Laboratorní výsledková zpráva“

| | |
| :--- | :--- |
| Účel | Tento use case popisuje způsob, jakým poskytovatel zdravotní péče (zadavatel objednávky) obdrží výsledky laboratorních analýz. Výsledky mohou být distribuovány přímo zadavateli objednávky nebo prostřednictvím úložiště laboratorních výsledků (centrální, regionální nebo lokální EHR systém), ze kterého je zadavatel nebo jiný subjekt účastnící se zdravotní péče může vyzvednout.Výsledky může obdržet a nahlížet do nich také pacient. |
| Význam | Laboratorní medicína je jedním ze základních prvků každého systému zdravotní péče. Je nedílnou součástí mnoha klinických rozhodnutí, často poskytuje lékařům, sestrám a dalším poskytovatelům zdravotní péče klíčové informace nutné k prevenci, diagnostice, léčbě a managementu onemocnění.Spektrum poskytovaných testů je široké, pohybuje se od vysoce standardizovaných a cenově výhodných testů, jako je vyšetření krevního obrazu nebo základní testy z oblasti klinické biochemie, až po inovativní a personalizované testování v rámci lékařské genetiky. Všichni zdravotničtí pracovníci, kteří se účastní epizody poskytování zdravotní péče pacientovi, by měli mít, v rámci své role v procesu poskytování zdravotní péče, přístup ke příslušným výsledkům laboratorních vyšetření.Informace o laboratorních výsledcích často pocházejí z různých zdrojů. Pro koncové uživatele poskytuje transparentní, na zdroji nezávislé prohlížení všech výsledků a nezbytné informace potřebné při procesu rozhodování. K výsledkům laboratorních vyšetření by měl mít přístup také pacient.Dostupnost elektronických strukturovaných laboratorních výsledkových zpráv pomáhá redukovat počet chyb vznikajících při přepisu výsledků testů do pacientské dokumentace ze zpráv papírových. Možnost přístupu ke všem pacientským výsledkům laboratorních testů, bez ohledu na zadavatele, snižuje zbytečná duplicitní vyšetření a tím šetří náklady při poskytování péče i zátěž pro pacienty.Laboratorní zprávy jsou explicitně zmíněny v paragrafu 11c Nařízení EK o evropském formátu výměny elektronické dokumentace (EHRxF) z 6.2.2019. |
| Doména | Laboratoře |
| Rozsah | Národní/regionální/lokální |
| Kontext | Poptávka po online přístupu k výsledkům laboratorních testů existuje jak ze strany poskytovatelů zdravotní péče, tak i jako součást elektronických zdravotních záznamů pacientů. Současné řešení zahrnují především point-to-point komunikaci mezi laboratoří a informačním systémem poskytovatele zdravotní péče. Poskytovatel obvykle nemá přístup k jiným výsledkům laboratorních testů než k těm, které sám objednal. Kromě toho roste i poptávka po sekundárním využití těchto výsledků.Zde uváděný use case je použitelný pro případ jakéhokoliv původu laboratorní výsledkové zprávy, ať už ji poskytne laboratoř, nebo jakýkoliv systém/úložiště laboratorních výsledků (centrální, regionální či lokálním EHR). |
| Informace | Laboratorní výsledková zpráva |
| Aktéři | • Pacient• Poskytovatel zdravotní péče• Systém elektronických žádanek poskytovatele zdravotní péče• Laboratorní pracovník• Laboratorní informační systém |
| Předpoklady | Oprávněným subjektem byla laboratoři nebo jinému zdroji laboratorní výsledkové zprávy zadána objednávka na test/testy nebo požadavek na výsledkovou zprávu. |
| Funkční popis procesu | Proces vzniku laboratorní výsledkové zprávy obvykle navazuje na use case laboratorní objednávky. Interní systém laboratoře (Automation manager) zapíše výsledky laboratorních testů do laboratorní aplikace (Order Filler) zodpovědné za správu objednávek. Zde jsou výsledky zkonsolidovány do příslušné objednávky nebo skupiny objednávek. Výsledková zpráva, sestavená na základě objednávky laboratorních vyšetření a vnitřních pravidel laboratoře, je odeslána do klinického systému žadatele (nazývané Order Result Tracker).Order Filler aplikace též upozorní jak Order Placer (aplikace klinické praxe, které objednávku generuje), tak Order Result Tracker o všech změnách stavu každé objednávky a s ní spojených výsledků. |

