# Home - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ImplementationGuide/hl7.fhir.cz.lab | *Version*:0.5.0 |
| Draft as of 2025-12-10 | *Computable Name*:HL7CzLaboratoryImplementationGuide |

### Introduction

This implementation guide is based on [FHIR version R4](https://hl7.org/fhir/R4/). Specify a set of rules that will be used for HL7 FHIR to define how to represent Laboratory Report in the Czech national context, in line with European eHN guidelines.

Its main objective is to define the content components and the preferred structure to be used to construct a laboratory report. The purpose of this standard is to define the representation of the laboratory report as a patient's medical record for the purpose of electronic exchange of health information between individuals, healthcare providers and infrastructure in the Czech Republic.

This guide does not describe how to exchange this message.

### Content Overview

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction, scope short, references, dependencies, cross version analysis and IP statement for this guide.
* Introduction: 
* [Scope and content](scope-and-content-en.md): This segment contains general information about Laboratory Report.
* [Background](background-en.md): This segment contains background information about Laboratory Report.
 
* Functional: 
* [Use cases](use-cases-en.md): This segment contains information about use cases.
* [Workflow](workflow-en.md): This segment contains information about workflow.
* [Logical models](logical-models-en.md): This segment contains information about logical models.
* [Terminology considerations](terminology-considerations-en.md): This segment contains information about terminology.
 
* Implementation: 
* [Mapping to profiles](model-map-en.md): This segment contains information about logical model maps to profiles.
* [Examples](examples-en.md): This segment contains information about examples.
* [Obligations](obligations-en.md): This segment contains information about obligations.
 
* About: 
* [Authors](authors-en.md): This segment contains informaction about authors.
* [Downloads](downloads-en.md): This segment contains informaction about downloads.
* [Dependencies](dependencies-en.md): This segment contains informaction about dependencies.
* [Copyright](copyright-en.md): This segment contains informaction about copyright.
 
* [Artifacts](artifacts.md): This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### References

* Related specifications: 
* [EHDS Logical Information Models](http://build.fhir.org/ig/Xt-EHR/xt-ehr-common/index.html) 
* This specification has inspired many of the design patterns defined in this IG.
 
* [HL7 Czech Laboratory Order IG](http://build.fhir.org/ig/HL7-cz/lab-order/index.html) 
* This specification has many of together design patterns defined in this IG.
 
* [HL7 Europe Laboratory Report](https://hl7.eu/fhir/laboratory/) 
* This specification has many of together design patterns defined in this IG.
 
* [HL7 Czech Base and Core Implementation Guide](http://build.fhir.org/ig/HL7-cz/cz-core/index.html) 
* Where possible this specification has been aligned with choices made in CZ core.
 
 

### Dependencies















### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cz.lab.r4)](package.r4.tgz) and [R4B (hl7.fhir.cz.lab.r4b)](package.r4b.tgz) are available.

### IP statements

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [specimenType](http://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/CodeSystem-v2-0487.html): [Bundle/CZ-LabReport-Bundle-Example](Bundle-CZ-LabReport-Bundle-Example.md), [Bundle/CZ-LabReport-Bundle-Example-ObsTypes](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md)...Show 4 more,[Specimen/4c7a1d2f-89b3-41e5-a6f2-3b9d7c5e0a21](Specimen-4c7a1d2f-89b3-41e5-a6f2-3b9d7c5e0a21.md),[Specimen/6e2c1f9a-54b7-4d3e-82a1-7c4f9e2b0d85](Specimen-6e2c1f9a-54b7-4d3e-82a1-7c4f9e2b0d85.md),[Specimen/92f1c7b5-3a4e-4d8f-97c2-1b6e0f8d2a43](Specimen-92f1c7b5-3a4e-4d8f-97c2-1b6e0f8d2a43.md)and[Specimen/fa3d8c2e-71b4-4e9c-9d2f-85b0a1f7c934](Specimen-fa3d8c2e-71b4-4e9c-9d2f-85b0a1f7c934.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AttachmentImagingReport2FHIRcz](ConceptMap-AttachmentImagingReport2FHIR-cz.md), [Bundle/CZ-LabReport-Bundle-Example](Bundle-CZ-LabReport-Bundle-Example.md)...Show 81 more,[Bundle/CZ-LabReport-Bundle-Example-L1](Bundle-CZ-LabReport-Bundle-Example-L1.md),[Bundle/CZ-LabReport-Bundle-Example-Min](Bundle-CZ-LabReport-Bundle-Example-Min.md),[Bundle/CZ-LabReport-Bundle-Example-ObsTypes](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md),[Bundle/CZ-LabReport-Bundle-Example-kn](Bundle-CZ-LabReport-Bundle-Example-kn.md),[CZ_AddressObligationsLab](StructureDefinition-cz-address-obl-lab.md),[CZ_Attachment](StructureDefinition-cz-attachment.md),[CZ_AttachmentObligationsLab](StructureDefinition-cz-attachment-obl-lab.md),[CZ_BundleLab](StructureDefinition-cz-bundle-lab.md),[CZ_BundleObligationsLab](StructureDefinition-cz-bundle-obl-lab.md),[CZ_CompositionLabReport](StructureDefinition-cz-composition-lab-report.md),[CZ_CompositionObligationsLab](StructureDefinition-cz-composition-obl-lab.md),[CZ_CoverageObligationsLab](StructureDefinition-cz-coverage-obl-lab.md),[CZ_DiagnosticReportLab](StructureDefinition-cz-diagnostic-report-lab.md),[CZ_DiagnosticReportObligationsLab](StructureDefinition-cz-diagnosticReport-obl-lab.md),[CZ_DocumentReferenceObligationsLab](StructureDefinition-cz-documentReference-obl-lab.md),[CZ_EncounterObligationsLab](StructureDefinition-cz-encounter-obl-lab.md),[CZ_ExtNote](StructureDefinition-cz-ext-note.md),[CZ_LabClinicallyRelevantTime](StructureDefinition-cz-lab-clinically-relevant-time.md),[CZ_LabClinicallyRelevantTimeVS](ValueSet-cz-lab-clinically-relevant-time-VS.md),[CZ_LabContainerTypesVS](ValueSet-cz-lab-container-types-VS.md),[CZ_LabReportTypesVS](ValueSet-cz-lab-report-types-VS.md),[CZ_LabSpecialityTypesVS](ValueSet-cz-lab-speciality-types-VS.md),[CZ_LabStudyTypesVS](ValueSet-cz-lab-study-types-VS.md),[CZ_LabTechniqueVs](ValueSet-cz-lab-technique-vs.md),[CZ_NclpLabpolVS](ValueSet-cz-nclp-labpol-vs.md),[CZ_ObservationResultLaboratory](StructureDefinition-cz-observation-result-laboratory.md),[CZ_ObservationResultObligationsLab](StructureDefinition-cz-observationResult-obl-lab.md),[CZ_OrganizationObligationsLab](StructureDefinition-cz-organization-obl-lab.md),[CZ_PatientAnimalObligationsLab](StructureDefinition-cz-patientAnimal-obl-lab.md),[CZ_PatientObligationsLab](StructureDefinition-cz-patient-obl-lab.md),[CZ_PractitionerObligationsLab](StructureDefinition-cz-practitioner-obl-lab.md),[CZ_PractitionerRoleObligationsImg](StructureDefinition-cz-practitionerRole-obl-img.md),[CZ_RelatedPersonObligationsImg](StructureDefinition-cz-relatedPerson-obl-img.md),[CZ_ServiceRequestLab](StructureDefinition-cz-service-request-lab.md),[CZ_ServiceRequestObligationsLab](StructureDefinition-cz-serviceRequest-obl-lab.md),[CZ_SpecimenLab](StructureDefinition-cz-specimen-lab.md),[CZ_SpecimenObligationsLab](StructureDefinition-cz-specimen-obl-lab.md),[CompositionBasedOnOrderOrRequisition](StructureDefinition-composition-based-on-order-or-requisition.md),[ConceptMapDiagRptStatus2CompStatus](ConceptMap-ConceptMap-cz-diagRptStatus2CompStatus.md),[DiagnosticReportReference](StructureDefinition-composition-DiagnosticReportReference.md),[HL7CzLaboratoryImplementationGuide](index.md),[InformationRecipient](StructureDefinition-information-recipient.md),[LabRpt2FHIR](ConceptMap-labRpt2FHIR-cz-lab.md),[LabRptAuthor2FHIR](ConceptMap-author2FHIR-cz-lab.md),[LabRptResult2FHIR](ConceptMap-result2FHIR-cz-lab.md),[LabRptSubject2Fhir](ConceptMap-subject2FHIR-cz-lab.md),[LegalAuth2Fhir](ConceptMap-legalAuth2FHIR-cz-lab.md),[LogCzAttachmentsCz](StructureDefinition-LogAttachmentsCz.md),[LogCzAuthorLabEhnCz](StructureDefinition-LogAuthorCz.md),[LogCzElectronicSignaturesLabEhnCz](StructureDefinition-LogElectronicSignatures.md),[LogCzLabReportEhnCz](StructureDefinition-LogLabReportCz.md),[LogCzLegalAuthenticatorLabEhnCz](StructureDefinition-LogLegalAuthenticatorCz.md),[LogCzOrderLabEhnCz](StructureDefinition-LogOrderCz.md),[LogCzPayerLabEhnCz](StructureDefinition-LogPayerCz.md),[LogCzPresentedFormCz](StructureDefinition-LogPresentedFormCz.md),[LogCzRecipientLabEhnCz](StructureDefinition-LogRecipientCz.md),[LogCzResultLabEhnCz](StructureDefinition-LogResultCz.md),[LogCzSpecimenLabEhnCz](StructureDefinition-LogSpecimenLabCz.md),[LogCzSubjectLabEhnCz](StructureDefinition-LogSubjectCz.md),[LogCzValidatorLabEhnCz](StructureDefinition-LogValidatorCz.md),[LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md),[LogEnAuthorLabEhnCz](StructureDefinition-AuthorCz.md),[LogEnElectronicSignaturesLabEhnCz](StructureDefinition-ElectronicSignatures.md),[LogEnLabReportEhnCz](StructureDefinition-LabReportCz.md),[LogEnLegalAuthenticatorLabEhnCz](StructureDefinition-LegalAuthenticatorCz.md),[LogEnOrderLabEhnCz](StructureDefinition-OrderCz.md),[LogEnPayerLabEhnCz](StructureDefinition-PayerCz.md),[LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md),[LogEnRecipientLabEhnCz](StructureDefinition-RecipientCz.md),[LogEnResultLabEhnCz](StructureDefinition-ResultCz.md),[LogEnSpecimenLabEhnCz](StructureDefinition-SpecimenLabCz.md),[LogEnSubjectLabEhnCz](StructureDefinition-SubjectCz.md),[LogEnValidatorLabEhnCz](StructureDefinition-ValidatorCz.md),[Nemocnice Žlábek Dolní](Organization-bc2b8a3e-999a-4f10-91ce-1dc12fa0e123.md),[Order2Fhir](ConceptMap-order2FHIR-cz-lab.md),[Patient/3f2a1b9e-6d4f-4c2e-9a7b-2d8f0b3e1c9a](Patient-3f2a1b9e-6d4f-4c2e-9a7b-2d8f0b3e1c9a.md),[Patient/c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c](Patient-c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c.md),[Payer2Fhir](ConceptMap-payer2FHIR-cz-lab.md),[Recipient2FHIR](ConceptMap-recipient2FHIR-cz-lab.md),[Specimen2Fhir](ConceptMap-specimen2FHIR-cz-lab.md)and[Validator2Fhir](ConceptMap-validator2FHIR-cz-lab.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/CodeSystem-v3-ucum.html): [Bundle/CZ-LabReport-Bundle-Example](Bundle-CZ-LabReport-Bundle-Example.md), [Bundle/CZ-LabReport-Bundle-Example-Complex](Bundle-CZ-LabReport-Bundle-Example-Complex.md)...Show 5 more,[Bundle/CZ-LabReport-Bundle-Example-Min](Bundle-CZ-LabReport-Bundle-Example-Min.md),[Bundle/CZ-LabReport-Bundle-Example-ObsTypes](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md),[Bundle/CZ-LabReport-Bundle-Example-kn](Bundle-CZ-LabReport-Bundle-Example-kn.md),[Observation/8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3](Observation-8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3.md)and[Observation/d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35](Observation-d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/CZ-LabReport-Bundle-Example](Bundle-CZ-LabReport-Bundle-Example.md), [Bundle/CZ-LabReport-Bundle-Example-Complex](Bundle-CZ-LabReport-Bundle-Example-Complex.md)...Show 16 more,[Bundle/CZ-LabReport-Bundle-Example-L1](Bundle-CZ-LabReport-Bundle-Example-L1.md),[Bundle/CZ-LabReport-Bundle-Example-Min](Bundle-CZ-LabReport-Bundle-Example-Min.md),[Bundle/CZ-LabReport-Bundle-Example-ObsTypes](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md),[Bundle/CZ-LabReport-Bundle-Example-kn](Bundle-CZ-LabReport-Bundle-Example-kn.md),[CZ_CompositionLabReport](StructureDefinition-cz-composition-lab-report.md),[CZ_CompositionObligationsLab](StructureDefinition-cz-composition-obl-lab.md),[CZ_DiagnosticReportLab](StructureDefinition-cz-diagnostic-report-lab.md),[CZ_LabReportTypesVS](ValueSet-cz-lab-report-types-VS.md),[CZ_LabStudyTypesVS](ValueSet-cz-lab-study-types-VS.md),[CZ_ObservationResultLaboratory](StructureDefinition-cz-observation-result-laboratory.md),[Observation/2fb0c9d4-7e12-47a6-9a3b-1c5e8d2f4a76](Observation-2fb0c9d4-7e12-47a6-9a3b-1c5e8d2f4a76.md),[Observation/5c3e9a12-4f7b-41d0-86a2-9b7e4d2f1c08](Observation-5c3e9a12-4f7b-41d0-86a2-9b7e4d2f1c08.md),[Observation/5f3b0d47-2c3c-4c54-97f1-0bb8cc3e4e4f](Observation-5f3b0d47-2c3c-4c54-97f1-0bb8cc3e4e4f.md),[Observation/8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3](Observation-8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3.md),[Observation/b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56](Observation-b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56.md)and[Observation/d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35](Observation-d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [Bundle/CZ-LabReport-Bundle-Example](Bundle-CZ-LabReport-Bundle-Example.md), [Bundle/CZ-LabReport-Bundle-Example-ObsTypes](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md)...Show 14 more,[CZ_CompositionLabReport](StructureDefinition-cz-composition-lab-report.md),[CZ_DiagnosticReportLab](StructureDefinition-cz-diagnostic-report-lab.md),[CZ_LabClinicallyRelevantTime](StructureDefinition-cz-lab-clinically-relevant-time.md),[CZ_LabClinicallyRelevantTimeVS](ValueSet-cz-lab-clinically-relevant-time-VS.md),[CZ_LabContainerTypesVS](ValueSet-cz-lab-container-types-VS.md),[CZ_LabSpecialityTypesVS](ValueSet-cz-lab-speciality-types-VS.md),[CZ_LabTechniqueVs](ValueSet-cz-lab-technique-vs.md),[CZ_ObservationResultLaboratory](StructureDefinition-cz-observation-result-laboratory.md),[Device/device-analyzer-urea](Device-device-analyzer-urea.md),[Device/device-kit-urea](Device-device-kit-urea.md),[Observation/5f3b0d47-2c3c-4c54-97f1-0bb8cc3e4e4f](Observation-5f3b0d47-2c3c-4c54-97f1-0bb8cc3e4e4f.md),[Observation/b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56](Observation-b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56.md),[Observation/d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35](Observation-d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35.md)and[ServiceRequest/5f9c2e8d-0b74-4dbb-8af3-3e6d2c1191a7](ServiceRequest-5f9c2e8d-0b74-4dbb-8af3-3e6d2c1191a7.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [DataAbsentReason](http://terminology.hl7.org/7.0.0/CodeSystem-data-absent-reason.html): [Bundle/CZ-LabReport-Bundle-Example-ObsTypes](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md) and [Observation/2fb0c9d4-7e12-47a6-9a3b-1c5e8d2f4a76](Observation-2fb0c9d4-7e12-47a6-9a3b-1c5e8d2f4a76.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html): [Bundle/CZ-LabReport-Bundle-Example](Bundle-CZ-LabReport-Bundle-Example.md), [Bundle/CZ-LabReport-Bundle-Example-Complex](Bundle-CZ-LabReport-Bundle-Example-Complex.md)...Show 11 more,[Bundle/CZ-LabReport-Bundle-Example-Min](Bundle-CZ-LabReport-Bundle-Example-Min.md),[Bundle/CZ-LabReport-Bundle-Example-ObsTypes](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md),[Bundle/CZ-LabReport-Bundle-Example-kn](Bundle-CZ-LabReport-Bundle-Example-kn.md),[CZ_ObservationResultLaboratory](StructureDefinition-cz-observation-result-laboratory.md),[CZ_ObservationResultObligationsLab](StructureDefinition-cz-observationResult-obl-lab.md),[Observation/2fb0c9d4-7e12-47a6-9a3b-1c5e8d2f4a76](Observation-2fb0c9d4-7e12-47a6-9a3b-1c5e8d2f4a76.md),[Observation/5c3e9a12-4f7b-41d0-86a2-9b7e4d2f1c08](Observation-5c3e9a12-4f7b-41d0-86a2-9b7e4d2f1c08.md),[Observation/5f3b0d47-2c3c-4c54-97f1-0bb8cc3e4e4f](Observation-5f3b0d47-2c3c-4c54-97f1-0bb8cc3e4e4f.md),[Observation/8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3](Observation-8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3.md),[Observation/b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56](Observation-b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56.md)and[Observation/d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35](Observation-d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35.md)
* [identifierType](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0203.html): [Bundle/CZ-LabReport-Bundle-Example-ObsTypes](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md), [CZ_PatientObligationsLab](StructureDefinition-cz-patient-obl-lab.md), [CZ_RelatedPersonObligationsImg](StructureDefinition-cz-relatedPerson-obl-img.md) and [Patient/c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c](Patient-c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c.md)
* [ActCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html): [Bundle/CZ-LabReport-Bundle-Example-L1](Bundle-CZ-LabReport-Bundle-Example-L1.md) and [Encounter/4d2447db-6692-40cd-a440-7544d48caa08](Encounter-4d2447db-6692-40cd-a440-7544d48caa08.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ObservationInterpretation.html): [Bundle/CZ-LabReport-Bundle-Example](Bundle-CZ-LabReport-Bundle-Example.md), [Bundle/CZ-LabReport-Bundle-Example-Complex](Bundle-CZ-LabReport-Bundle-Example-Complex.md)...Show 7 more,[Bundle/CZ-LabReport-Bundle-Example-Min](Bundle-CZ-LabReport-Bundle-Example-Min.md),[Bundle/CZ-LabReport-Bundle-Example-ObsTypes](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md),[Bundle/CZ-LabReport-Bundle-Example-kn](Bundle-CZ-LabReport-Bundle-Example-kn.md),[Observation/5c3e9a12-4f7b-41d0-86a2-9b7e4d2f1c08](Observation-5c3e9a12-4f7b-41d0-86a2-9b7e4d2f1c08.md),[Observation/8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3](Observation-8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3.md),[Observation/b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56](Observation-b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56.md)and[Observation/d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35](Observation-d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35.md)
* [ParticipationType](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ParticipationType.html): [Bundle/CZ-LabReport-Bundle-Example-ObsTypes](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md), [Observation/5c3e9a12-4f7b-41d0-86a2-9b7e4d2f1c08](Observation-5c3e9a12-4f7b-41d0-86a2-9b7e4d2f1c08.md), [Observation/b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56](Observation-b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56.md) and [Observation/d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35](Observation-d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35.md)




## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.cz.lab",
  "url" : "https://hl7.cz/fhir/lab/ImplementationGuide/hl7.fhir.cz.lab",
  "version" : "0.5.0",
  "name" : "HL7CzLaboratoryImplementationGuide",
  "title" : "HL7 CZ Laboratory IG",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Czech Laboratory Implementation Guide",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.cz.lab",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.0"
    },
    {
      "id" : "hl7_fhir_uv_ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "1.1.0"
    },
    {
      "id" : "hl7_fhir_eu_laboratory",
      "uri" : "http://hl7.eu/fhir/laboratory/ImplementationGuide/hl7.fhir.eu.laboratory",
      "packageId" : "hl7.fhir.eu.laboratory",
      "version" : "current"
    },
    {
      "id" : "hl7_fhir_uv_extensions_r4",
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_eu_base",
      "uri" : "http://hl7.eu/fhir/base/ImplementationGuide/hl7.fhir.eu.base",
      "packageId" : "hl7.fhir.eu.base",
      "version" : "0.1.0-ballot"
    },
    {
      "id" : "hl7_fhir_cz_core",
      "uri" : "https://hl7.cz/fhir/core/ImplementationGuide/hl7.fhir.cz.core",
      "packageId" : "hl7.fhir.cz.core",
      "version" : "current"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2023+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.eu/fhir/StructureDefinition/information-recipient"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.eu/fhir/StructureDefinition/composition-basedOn-order-or-requisition"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../expansion-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/lab/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2023+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.eu/fhir/StructureDefinition/information-recipient"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.eu/fhir/StructureDefinition/composition-basedOn-order-or-requisition"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../expansion-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/lab/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "obligations",
        "name" : "Obligations",
        "description" : "Obligations used to describe the Imaging Report functional requirements for the specified data elements. Informative for this version of the guide."
      },
      {
        "id" : "czech-logical-model",
        "name" : "Czech logical model (Informative)",
        "description" : "Logical model in czech language. Informative for this version of the guide."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogLabReportCz"
        },
        "name" : "A - Laboratorní zpráva",
        "description" : "Zpráva z laboratorního vyšetření",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LabReportCz"
        },
        "name" : "A - Laboratory Report",
        "description" : "Laboratory Report. eHN guideline model.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogSubjectCz"
        },
        "name" : "A.1.1, A1.2 - Pacient",
        "description" : "Pacient",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SubjectCz"
        },
        "name" : "A.1.1, A1.2 - Subject of care",
        "description" : "Patient or Subject of care. Sections A1.1 and A1.2 of the eHN guideline.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PayerCz"
        },
        "name" : "A.1.3 - Health insurance and payment information",
        "description" : "Health insurance and payment information.  Section A1.3 of the eHN guideline.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogPayerCz"
        },
        "name" : "A.1.3 - Preferované systémy",
        "description" : "Informace o zdravotním pojištění",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/RecipientCz"
        },
        "name" : "A.1.4 - Information recipient",
        "description" : "Information recipient (intended recipient or recipients of the report, additional recipients might be identified by the ordering party, e.g. GP, other specialist), if applicable.\nSection A1.4 of the eHN guideline.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogRecipientCz"
        },
        "name" : "A.1.4 - Příjemce dokumentu",
        "description" : "Informace o zamýšleném příjemci dokumentu",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AuthorCz"
        },
        "name" : "A.1.5 - Author",
        "description" : "Author (by whom the Laboratory result report or a subset of its results was authored). Section A1.5 of the eHN guideline.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogAuthorCz"
        },
        "name" : "A.1.5 - Autor dokumentu",
        "description" : "Autor dokumentu dle zákona 372/2011 §54 odst. (3)",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogValidatorCz"
        },
        "name" : "A.1.6 - Ověřil",
        "description" : "Ověřil",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ValidatorCz"
        },
        "name" : "A.1.6 - Result validator",
        "description" : "Result validator. Section A1.6 of the eHN guideline.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LegalAuthenticatorCz"
        },
        "name" : "A.1.7 - Legal authenticator",
        "description" : "Legal authenticator (The person taking responsibility for the medical content of the document).\nSection A1.7 of the eHN guideline.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogLegalAuthenticatorCz"
        },
        "name" : "A.1.7 - Zodpovídá",
        "description" : "Zodpovídá",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ElectronicSignatures"
        },
        "name" : "A.1.9 - Electronic signatures",
        "description" : "Electronic signatures According to Act No. 327/2011, §54a\nSection A1.7 of the eHN guideline.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogElectronicSignatures"
        },
        "name" : "A.1.9 - Electronic signatures",
        "description" : "Electronic signatures According to Act No. 327/2011, §54a\nSection A1.7 of the eHN guideline.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogOrderCz"
        },
        "name" : "A.2.1, A.2.2 - Objednávka",
        "description" : "Objednávka",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/OrderCz"
        },
        "name" : "A.2.1, A.2.2 - Order",
        "description" : "Order information and reason. Sections A2 and A3 of the eHN guideline.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogSpecimenLabCz"
        },
        "name" : "A.2.3 - Informace o vzorku",
        "description" : "Informace o vzorku",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SpecimenLabCz"
        },
        "name" : "A.2.3 - Specimen information",
        "description" : "Specimen information. Section A4 of the eHN guideline.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogResultCz"
        },
        "name" : "A.2.4 - Datové elementy výsledku vyšetření",
        "description" : "Datové elementy výsledku vyšetření",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/ResultCz"
        },
        "name" : "A.2.4 - Results data elements",
        "description" : "Results data elements. Section A5 of the eHN guideline.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PresentedFormCz"
        },
        "name" : "A.3 - Presented form",
        "description" : "Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogPresentedFormCz"
        },
        "name" : "A.3 - Presented form",
        "description" : "Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AttachmentsCz"
        },
        "name" : "A.4 - Additional attachments",
        "description" : "Laboratory Report - Laboratory Report additional attachments - A.4",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogAttachmentsCz"
        },
        "name" : "A.4 - Additional attachments",
        "description" : "Laboratory Report - Laboratory Report additional attachments - A.4",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-address-obl-lab"
        },
        "name" : "Address: Obligations",
        "description" : "This profile defines obligations for an address in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-attachment"
        },
        "name" : "Attachment: Lab Report (CZ)",
        "description" : "Czech profile for attachment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-attachment-obl-lab"
        },
        "name" : "Attachment: Obligations",
        "description" : "This profile defines obligations for an attachment in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/CZ-LabReport-Bundle-Example"
        },
        "name" : "Basic Lab Report Bundle Example",
        "description" : "Czech Lab Report - basic example of a bundle containing lab observation(s)",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/5f3b0d47-2c3c-4c54-97f1-0bb8cc3e4e4f"
        },
        "name" : "Blood Type",
        "description" : "Example of a lab result – coded",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-bundle-lab"
        },
        "name" : "Bundle - Laboratory Result Report",
        "description" : "This profile represents the constraints applied to the Bundle resource by the Czech national laboratory report FHIR Implementation Guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-bundle-obl-lab"
        },
        "name" : "Bundle: Obligations",
        "description" : "This profile defines obligations for a bundle in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/CZ-LabReport-Bundle-Example-Complex"
        },
        "name" : "Complex Report Bundle Example",
        "description" : "Czech Lab Report - example of a bundle containing containing several laboratory results as would occur in a real-life report",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-composition-lab-report"
        },
        "name" : "Composition: Laboratory Report",
        "description" : "Clinical document used to represent a Laboratory Report in the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-composition-obl-lab"
        },
        "name" : "Composition: Obligations",
        "description" : "This profile defines obligations for a composition in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Coverage"
          }
        ],
        "reference" : {
          "reference" : "Coverage/b4e1a7f0-93f3-4d86-a3b1-7d15e42b12f8"
        },
        "name" : "Coverage example",
        "description" : "Example of insurance by a health insurance company",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-coverage-obl-lab"
        },
        "name" : "Coverage: Obligations",
        "description" : "This profile defines obligations for a coverage in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/AttachmentImagingReport2FHIR-cz"
        },
        "name" : "CZ Attachment Model to this guide Map",
        "description" : "CZ Imaging Report Attachment Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/fa3d8c2e-71b4-4e9c-9d2f-85b0a1f7c934"
        },
        "name" : "CZ Lab Order Specimen Example",
        "description" : "Czech Lab Order - example of a specimen",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/92f1c7b5-3a4e-4d8f-97c2-1b6e0f8d2a43"
        },
        "name" : "CZ Lab Order Specimen Example",
        "description" : "Czech Lab Order - example of a specimen",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/6e2c1f9a-54b7-4d3e-82a1-7c4f9e2b0d85"
        },
        "name" : "CZ Lab Order Specimen Example",
        "description" : "Czech Lab Order - example of a specimen",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/4c7a1d2f-89b3-41e5-a6f2-3b9d7c5e0a21"
        },
        "name" : "CZ Lab Order Specimen Example - Urine",
        "description" : "Czech Lab Order - example of a urine specimen",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/device-analyzer-urea"
        },
        "name" : "deviceAnalyzerUrea",
        "description" : "Analyzátor BioAnalyt 6000",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/device-kit-urea"
        },
        "name" : "deviceKitUrea",
        "description" : "Testovací souprava Urea enzymatic assay",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-diagnosticReport-obl-lab"
        },
        "name" : "Diagnostic Report: Obligations",
        "description" : "This profile defines obligations for a diagnostic report in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/ConceptMap-cz-diagRptStatus2CompStatus"
        },
        "name" : "DiagnosticReport to Composition status",
        "description" : "Proposed relationship between the statused used in the DiagnosticReport resource and that used for the Composition.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-diagnostic-report-lab"
        },
        "name" : "DiagnosticReport: Laboratory Report",
        "description" : "Diagnostic Report used to represent an entry of a Laboratory Report, including its context, for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/composition-based-on-order-or-requisition"
        },
        "name" : "Document Based On Order",
        "description" : "This extension provides a link to the order [(Reference(ServiceRequest)] or requisition [ServiceRequest.requisition (i.e., 'Request.groupIdentifier')] that this report document is based on and fulfills.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/composition-DiagnosticReportReference"
        },
        "name" : "Document DiagnosticReport Reference",
        "description" : "This extension provides a reference to the DiagnosticReport instance that is associated with this document.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-documentReference-obl-lab"
        },
        "name" : "DocumentReference: Obligations",
        "description" : "This profile defines obligations for a bundle in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/author2FHIR-cz-lab"
        },
        "name" : "eHN Author to this guide Map",
        "description" : "eHN Author Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/labRpt2FHIR-cz-lab"
        },
        "name" : "eHN Lab Report to this guide Map",
        "description" : "eHN Lab Report to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/order2FHIR-cz-lab"
        },
        "name" : "eHN Order to this guide Map",
        "description" : "eHN Order to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/payer2FHIR-cz-lab"
        },
        "name" : "eHN Payer to this guide Map",
        "description" : "eHN Payer Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/legalAuth2FHIR-cz-lab"
        },
        "name" : "eHN Recipient to this guide Map",
        "description" : "eHN Legal Authenticator Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/recipient2FHIR-cz-lab"
        },
        "name" : "eHN Recipient to this guide Map",
        "description" : "eHN Recipient Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/result2FHIR-cz-lab"
        },
        "name" : "eHN Result to this guide Map",
        "description" : "eHN Result Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/specimen2FHIR-cz-lab"
        },
        "name" : "eHN Specimen to this guide Map",
        "description" : "eHN Specimen Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/subject2FHIR-cz-lab"
        },
        "name" : "eHN Subject to this guide Map",
        "description" : "eHN Subject Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/validator2FHIR-cz-lab"
        },
        "name" : "eHN Validator to this guide Map",
        "description" : "eHN Validator Model to this guide Map",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/4d2447db-6692-40cd-a440-7544d48caa08"
        },
        "name" : "encounter-L1",
        "description" : "Encounter",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-encounter-obl-lab"
        },
        "name" : "Encounter: Obligations",
        "description" : "This profile defines obligations for an encounter in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/5f9c2e8d-0b74-4dbb-8af3-3e6d2c1191a7"
        },
        "name" : "Example Laboratory Order",
        "description" : "Example instance of CZ_ServiceRequestLab for a serum glucose test with urgent priority",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-service-request-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-lab-clinically-relevant-time"
        },
        "name" : "Extension - Clinically Relevant Time",
        "description" : "Clinically Relevant Time Code",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-ext-note"
        },
        "name" : "ExtNote (CZ)",
        "description" : "CzExtNote",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/bc2b8a3e-999a-4f10-91ce-1dc12fa0e123"
        },
        "name" : "Hospital Žlábek Dolní",
        "description" : "Healthcare facility requesting a laboratory examination.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/information-recipient"
        },
        "name" : "Information recipient",
        "description" : "This extension applies to the Composition resource and is used to represent an intended recipient of the composition.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/CZ-LabReport-Bundle-Example-L1"
        },
        "name" : "L1 Lab Report Bundle Example",
        "description" : "Czech Lab Report - example of a L1 Lab Report bundle",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/CZ-LabReport-Bundle-Example-kn"
        },
        "name" : "Lab Report Bundle Example for Cumulative View",
        "description" : "Czech Lab Report - example of a bundle for a cumulative view in combination with the Minimal Lab Report Bundle Example",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/CZ-LabReport-Bundle-Example-ObsTypes"
        },
        "name" : "Lab Report Bundle Example with various result types",
        "description" : "Czech Lab Report - example of a bundle containing lab observations of various result types",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-lab-container-types-VS"
        },
        "name" : "Laboratory Container Types (CZ)",
        "description" : "Laboratory Container Types ValueSet",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-lab-report-types-VS"
        },
        "name" : "Laboratory Report Types (CZ)",
        "description" : "Typy laboratorních zpráv",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-lab-speciality-types-VS"
        },
        "name" : "Laboratory Speciality Types (CZ)",
        "description" : "Typy specializací laboratorní medicíny podle SNOMED CT pro použití v českých laboratorních implementacích (např. sekce v Composition, klasifikace laboratoře apod.).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-lab-study-types-VS"
        },
        "name" : "Laboratory Study Types (CZ)",
        "description" : "Typy laboratorních vyšetření",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-lab-technique-vs"
        },
        "name" : "Laboratory Techniques",
        "description" : "Laboratory technique (method of measurement) used for the result measurement (based on SNOMED CT).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/CZ-LabReport-Bundle-Example-Min"
        },
        "name" : "Minimal Lab Report Bundle Example",
        "description" : "Czech Lab Report - example of a minimal bundle containing lab observations",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-nclp-labpol-vs"
        },
        "name" : "Národní číselník laboratorních položek",
        "description" : "Sada obsahuje všechny položky kódového systému NČLP, které se používají pro identifikaci laboratorních testů, a to jak na laboratorních žádankách, tak v laboratorních nálezech a jiných typech zdravotnické dokumentace.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-result-laboratory"
        },
        "name" : "Observation Laboratory (CZ)",
        "description" : "This profile constrains the Observation resource to represent results produced by laboratory tests or panels/studies.\n\nThis observation may represent the result of a simple laboratory test such as hematocrit or it may group the set of results produced by a multi-test study or panel such as a complete blood count, a dynamic function test, a urine specimen study. In the latter case, the observation carries the overall conclusion of the study and or a global interpretation by the producer of the study in the comment element; and references the atomic results of the study as \"has-member\" child observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observationResult-obl-lab"
        },
        "name" : "Observation: Obligations",
        "description" : "This profile defines obligations for an observation result in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/d7a9324a-6d45-420a-bd8d-0a2c66e8e40c"
        },
        "name" : "Organization - Healthcare insurance company",
        "description" : "Example of insurance organisation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-organization-obl-lab"
        },
        "name" : "Organization: Obligations",
        "description" : "This profile defines obligations for an organization in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/RegisteringProviderExample"
        },
        "name" : "Organization: Registering healthcare provider example",
        "description" : "Fictional registering healthcare provider example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-patientAnimal-obl-lab"
        },
        "name" : "Patient Animal: Obligations",
        "description" : "This profile defines obligations for an animal Patient in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/3f2a1b9e-6d4f-4c2e-9a7b-2d8f0b3e1c9a"
        },
        "name" : "Patient Mracena",
        "description" : "Patient Mracena with contact information and practitioner",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-patient-obl-lab"
        },
        "name" : "Patient: Obligations",
        "description" : "This profile defines obligations for an human Patient in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-practitionerRole-obl-img"
        },
        "name" : "Practitioner Role: Obligations",
        "description" : "This profile defines obligations for a practitioner role in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-practitioner-obl-lab"
        },
        "name" : "Practitioner: Obligations",
        "description" : "This profile defines obligations for a practitioner in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/c2a7b9de-3b44-4e6f-9e51-9a1b8f1c82f4"
        },
        "name" : "practitionerFranc",
        "description" : "Fictional physician MUDr. Kvido Zýbradlo",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/3e4f8b7c-9a25-49cf-8b2a-2a8f1e7f3d66"
        },
        "name" : "practitionerRoleFranc",
        "description" : "Role of MUDr. Karel Franc (requesting physician)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/aabbccdd-2222-3333-dddd-112233445566"
        },
        "name" : "practitionerRoleSejdlova",
        "description" : "Role of Mgr. Kvilda Šejdlová (performing laboratory technician)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/ff223344-5566-4777-8899-ccbbccddeeff"
        },
        "name" : "practitionerRoleZybradlo",
        "description" : "Role of MUDr. Kvido Zýbradlo (legal authenticator of the result)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/fab321ab-7777-4444-cccc-abcdefabcdef"
        },
        "name" : "practitionerSejdlova",
        "description" : "Fictional laboratory technician Mgr. Kvilda Šejdlová",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/aabbccdd-1111-4222-9333-ffeeddccbbcc"
        },
        "name" : "practitionerZybradlo",
        "description" : "Fictional physician MUDr. Kvido Zýbradlo",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-relatedPerson-obl-img"
        },
        "name" : "Related Person: Obligations",
        "description" : "This profile defines obligations for a related person in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/8d6e1f2b-3a84-4c9d-bc2e-5f71a9d4e6c3"
        },
        "name" : "Serum glucose",
        "description" : "Example of a lab result – numeric, scale-based evaluation, preliminary (unreleased), accredited, urgent priority",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/2fb0c9d4-7e12-47a6-9a3b-1c5e8d2f4a76"
        },
        "name" : "Serum sodium",
        "description" : "Example of a lab result not delivered due to a broken tube, with a comment on the result",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/d1a7f3c8-0e5b-4b2a-8c91-6f4e2d7a9b35"
        },
        "name" : "Serum urea",
        "description" : "Example of a numeric lab result including measurement uncertainty, scale-based evaluation, reference ranges for a female aged 15–150 years, released",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-serviceRequest-obl-lab"
        },
        "name" : "Service Request: Obligations",
        "description" : "This profile defines obligations for an order information in FHIR for the purpose of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-service-request-lab"
        },
        "name" : "ServiceRequest: Laboratory Order",
        "description" : "ServiceRequest used to represent a Laboratory Order for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-specimen-lab"
        },
        "name" : "Specimen Laboratory (CZ)",
        "description" : "Czech profile for a specimen in a laboratory report. In some laboratory reports, specimen information is allowed to be minimal as many informations concerning the specimen are implied by the observations done.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-specimen-obl-lab"
        },
        "name" : "Specimen: Obligations",
        "description" : "This profile defines obligations for a specimen in FHIR for the purpose of this guide.",
        "exampleBoolean" : false,
        "groupingId" : "obligations"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/5c3e9a12-4f7b-41d0-86a2-9b7e4d2f1c08"
        },
        "name" : "Urine color",
        "description" : "Example of a lab result – free text",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/b4e2d7a9-63c1-44f8-b0a5-2e9d1c7a3f56"
        },
        "name" : "Urine nitrites",
        "description" : "Example of a lab result – coded text",
        "exampleCanonical" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-lab-clinically-relevant-time-VS"
        },
        "name" : "ValueSet - Clinically Relevant Time",
        "description" : "Codes of the clinically relevant times",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/c60b7c0e-0d8c-4e43-9f52-86d1dcf1a43c"
        },
        "name" : "Zyrgana",
        "description" : "Fictional patient for the purpose of the example",
        "exampleBoolean" : true
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index-cs.html"
            }
          ],
          "nameUrl" : "index-cs.html",
          "title" : "Domovská stránka",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "scope-and-content-en.html"
            }
          ],
          "nameUrl" : "scope-and-content-en.html",
          "title" : "Scope and content",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "scope-and-content-cs.html"
            }
          ],
          "nameUrl" : "scope-and-content-cs.html",
          "title" : "Oblasti a obsah",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background-en.html"
            }
          ],
          "nameUrl" : "background-en.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background-cs.html"
            }
          ],
          "nameUrl" : "background-cs.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors-en.html"
            }
          ],
          "nameUrl" : "authors-en.html",
          "title" : "Authors",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors-cs.html"
            }
          ],
          "nameUrl" : "authors-cs.html",
          "title" : "Autoři",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright-en.html"
            }
          ],
          "nameUrl" : "copyright-en.html",
          "title" : "Copyright",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright-cs.html"
            }
          ],
          "nameUrl" : "copyright-cs.html",
          "title" : "Autorská práva",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies-en.html"
            }
          ],
          "nameUrl" : "dependencies-en.html",
          "title" : "Dependencies",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies-cs.html"
            }
          ],
          "nameUrl" : "dependencies-cs.html",
          "title" : "Závislosti",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples-en.html"
            }
          ],
          "nameUrl" : "examples-en.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples-cs.html"
            }
          ],
          "nameUrl" : "examples-cs.html",
          "title" : "Příklady",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "logical-models-en.html"
            }
          ],
          "nameUrl" : "logical-models-en.html",
          "title" : "Logical models",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "logical-models-cs.html"
            }
          ],
          "nameUrl" : "logical-models-cs.html",
          "title" : "Datová sada - logické modely",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "model-map-en.html"
            }
          ],
          "nameUrl" : "model-map-en.html",
          "title" : "Model maps",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "model-map-cs.html"
            }
          ],
          "nameUrl" : "model-map-cs.html",
          "title" : "Mapování logického modelu",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "obligations-en.html"
            }
          ],
          "nameUrl" : "obligations-en.html",
          "title" : "Obligations",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "obligations-cs.html"
            }
          ],
          "nameUrl" : "obligations-cs.html",
          "title" : "Obligations",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminology-considerations-en.html"
            }
          ],
          "nameUrl" : "terminology-considerations-en.html",
          "title" : "Terminology considerations",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminology-considerations-cs.html"
            }
          ],
          "nameUrl" : "terminology-considerations-cs.html",
          "title" : "Terminologické aspekty",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "use-cases-en.html"
            }
          ],
          "nameUrl" : "use-cases-en.html",
          "title" : "Use cases",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "use-cases-cs.html"
            }
          ],
          "nameUrl" : "use-cases-cs.html",
          "title" : "Příklady užití",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "workflow-en.html"
            }
          ],
          "nameUrl" : "workflow-en.html",
          "title" : "Workflow",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "workflow-cs.html"
            }
          ],
          "nameUrl" : "workflow-cs.html",
          "title" : "Workflow",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads-en.html"
            }
          ],
          "nameUrl" : "downloads-en.html",
          "title" : "Download",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads-cs.html"
            }
          ],
          "nameUrl" : "downloads-cs.html",
          "title" : "Download",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
