# Národní číselník laboratorních položek - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Národní číselník laboratorních položek**

## ValueSet: Národní číselník laboratorních položek 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ValueSet/cz-nclp-labpol-vs | *Version*:0.5.0 |
| Active as of 2023-01-01 | *Computable Name*:CZ_NclpLabpolVS |

 
Sada obsahuje všechny položky kódového systému NČLP, které se používají pro identifikaci laboratorních testů, a to jak na laboratorních žádankách, tak v laboratorních nálezech a jiných typech zdravotnické dokumentace. 

 **References** 

* [Observation Laboratory (CZ)](StructureDefinition-cz-observation-result-laboratory.md)
* [ServiceRequest: Laboratory Order](StructureDefinition-cz-service-request-lab.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-nclp-labpol-vs",
  "url" : "https://hl7.cz/fhir/lab/ValueSet/cz-nclp-labpol-vs",
  "version" : "0.5.0",
  "name" : "CZ_NclpLabpolVS",
  "title" : "Národní číselník laboratorních položek",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-01-01",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Sada obsahuje všechny položky kódového systému NČLP, které se používají pro identifikaci laboratorních testů, a to jak na laboratorních žádankách, tak v laboratorních nálezech a jiných typech zdravotnické dokumentace.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol"
      }
    ]
  }
}

```
