# Laboratory Speciality Types (CZ) - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Laboratory Speciality Types (CZ)**

## ValueSet: Laboratory Speciality Types (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/ValueSet/cz-lab-speciality-types-VS | *Version*:0.5.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:CZ_LabSpecialityTypesVS |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | | |

 
Typy specializací laboratorní medicíny podle SNOMED CT pro použití v českých laboratorních implementacích (např. sekce v Composition, klasifikace laboratoře apod.). 

 **References** 

* [Composition: Laboratory Report](StructureDefinition-cz-composition-lab-report.md)
* [DiagnosticReport: Laboratory Report](StructureDefinition-cz-diagnostic-report-lab.md)
* [Observation Laboratory (CZ)](StructureDefinition-cz-observation-result-laboratory.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-lab-speciality-types-VS",
  "language" : "cs-CZ",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/ValueSet/cz-lab-speciality-types-VS",
  "version" : "0.5.0",
  "name" : "CZ_LabSpecialityTypesVS",
  "title" : "Laboratory Speciality Types (CZ)",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-08-11",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Typy specializací laboratorní medicíny podle SNOMED CT pro použití v českých laboratorních implementacích (např. sekce v Composition, klasifikace laboratoře apod.).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "394596001",
            "display" : "Chemical pathology"
          },
          {
            "code" : "394916005",
            "display" : "Hematopathology"
          },
          {
            "code" : "421661004",
            "display" : "Blood banking and transfusion medicine"
          },
          {
            "code" : "394915009",
            "display" : "General pathology"
          },
          {
            "code" : "394598000",
            "display" : "Immunopathology"
          },
          {
            "code" : "408454008",
            "display" : "Clinical microbiology"
          },
          {
            "code" : "1236877003",
            "display" : "Genetic pathology"
          },
          {
            "code" : "1236878008",
            "display" : "Histocompatibility and Immunogenetics"
          }
        ]
      }
    ]
  }
}

```
