# DiagnosticReport: Laboratory Report - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DiagnosticReport: Laboratory Report**

## Resource Profile: DiagnosticReport: Laboratory Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnostic-report-lab | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_DiagnosticReportLab |
| **Copyright/Legal**: HL7 Czech Republic | | |

 
Diagnostic Report used to represent an entry of a Laboratory Report, including its context, for the scope of the Czech national interoperability project. 

**Usages:**

* Derived from this Profile: [Diagnostic Report: Obligations](StructureDefinition-cz-diagnosticReport-obl-lab.md)
* Use this Profile: [Bundle - Laboratory Result Report](StructureDefinition-cz-bundle-lab.md)
* Refer to this Profile: [Composition: Laboratory Report](StructureDefinition-cz-composition-lab-report.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/cz-diagnostic-report-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-diagnostic-report-lab.csv), [Excel](StructureDefinition-cz-diagnostic-report-lab.xlsx), [Schematron](StructureDefinition-cz-diagnostic-report-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-diagnostic-report-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/laboratory/StructureDefinition/DiagnosticReport-eu-lab"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnostic-report-lab",
  "version" : "0.5.0",
  "name" : "CZ_DiagnosticReportLab",
  "title" : "DiagnosticReport: Laboratory Report",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Diagnostic Report used to represent an entry of a Laboratory Report, including its context, for the scope of the Czech national interoperability project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "copyright" : "HL7 Czech Republic",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DiagnosticReport",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DiagnosticReport",
        "path" : "DiagnosticReport",
        "short" : "Laboratory Report DiagnosticReport",
        "definition" : "Laboratory Report DiagnosticReport",
        "constraint" : [
          {
            "key" : "presentedform-01",
            "severity" : "warning",
            "human" : "At least one of presented form has PDF format",
            "expression" : "presentedForm.where(contentType = 'application/pdf').count() > 0",
            "source" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnostic-report-lab"
          }
        ]
      },
      {
        "id" : "DiagnosticReport.extension",
        "path" : "DiagnosticReport.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "DiagnosticReport.extension:DiagnosticReportCompositionR5",
        "path" : "DiagnosticReport.extension",
        "sliceName" : "DiagnosticReportCompositionR5",
        "short" : "Associated Lab Report Composition",
        "definition" : "This extension implements the R5 composition element. It allow to link this DiagnosticReport with the Composition documenting this Laboratory Report.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-DiagnosticReport.composition"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.extension:DiagnosticReportCompositionR5.value[x]",
        "path" : "DiagnosticReport.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-composition-lab-report"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.identifier",
        "path" : "DiagnosticReport.identifier",
        "short" : "Report identifier",
        "definition" : "Identifiers assigned to this Laboratory Report by the performer or other systems. It shall be common to several report versions",
        "comment" : "Composition.identifier SHALL be equal to one of the DiagnosticReport.identifier, if at least one exists"
      },
      {
        "id" : "DiagnosticReport.basedOn",
        "path" : "DiagnosticReport.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-service-request-lab"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.status",
        "path" : "DiagnosticReport.status",
        "short" : "Status of the Report",
        "comment" : "DiagnosticReport.status and Composition.status shall be aligned, based on the http://hl7.eu/fhir/laboratory/ConceptMap/ConceptMap-eu-diagRptStatus2CompStatus mapping"
      },
      {
        "id" : "DiagnosticReport.category",
        "path" : "DiagnosticReport.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "Report Category",
        "definition" : "A code that classifies this laboratory report. Two basic categories has been selected in this guide: laboratory specialty and Study type. Laboratory specialty is characteristic of the laboratory that produced the test result while Study type is an arbitrary classificion of the test type.",
        "comment" : "DiagnosticReport.category and Composition.category shall be aligned",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.category:studyType",
        "path" : "DiagnosticReport.category",
        "sliceName" : "studyType",
        "short" : "The way of grouping of the test results into clinically meaningful domains (e.g. hematology study, microbiology study, etc.)",
        "definition" : "Laboratory services, i.e., results of tests performed, could be characterized using typology of services, commonly called study types. Study type could be seen as an attribute or grouping mechanism that assigns a common clinical sense to certain types of laboratory test results., e.g., Hemoglobin, Platelet count, etc. belongs to 'Hematology study'.",
        "comment" : "In comparison to the laboratory specialty which is an attribute of laboratory, study type is a categorization of laboratory service. It needs to be mentioned that classification of test to study types in not standardized.",
        "min" : 0,
        "max" : "*",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/lab/ValueSet/cz-lab-study-types-VS"
        }
      },
      {
        "id" : "DiagnosticReport.category:specialty",
        "path" : "DiagnosticReport.category",
        "sliceName" : "specialty",
        "short" : "The clinical domain of the laboratory performing the observation (e.g. microbiology, toxicology, chemistry)",
        "definition" : "Laboratory specialty is an attribute of any laboratory setting representing professional qualification of the laboratory to execute certain kind of laboratory tests.",
        "comment" : "Specialty could be used as parameter for searching/querying of laboratory test results.",
        "min" : 0,
        "max" : "*",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/lab/ValueSet/cz-lab-speciality-types-VS"
        }
      },
      {
        "id" : "DiagnosticReport.code",
        "path" : "DiagnosticReport.code",
        "short" : "Type of (Laboratory) Report",
        "definition" : "Specifies that it refers to a Laboratory Report",
        "comment" : "At least one DiagnosticReport.code.coding and Composition.type.coding SHALL be equal",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://hl7.cz/fhir/lab/ValueSet/cz-lab-report-types-VS"
        }
      },
      {
        "id" : "DiagnosticReport.subject",
        "path" : "DiagnosticReport.subject",
        "short" : "Who and/or what this report is about",
        "definition" : "Who or what this report is about. The report can be about a human patient, a living subject, a device (e.g. a machine), a location or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).",
        "comment" : "DiagnosticReport and Composition SHALL have the same subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-animal",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.encounter",
        "path" : "DiagnosticReport.encounter",
        "short" : "The healthcare event which this Laboratory Report is about (when test ordered).",
        "definition" : "The healthcare event (e.g. a patient and healthcare provider interaction) which this DiagnosticReport is about.",
        "comment" : "This will typically be the encounter the event occurred within, but some events may be initiated prior to or after the official completion of an encounter but still be tied to the context of the encounter (e.g. pre-admission laboratory tests).\n\n  DiagnosticReport and Composition SHALL have the same encounter."
      },
      {
        "id" : "DiagnosticReport.effective[x]",
        "path" : "DiagnosticReport.effective[x]",
        "short" : "Clinically relevant time/time-period for report."
      },
      {
        "id" : "DiagnosticReport.performer",
        "path" : "DiagnosticReport.performer",
        "short" : "Responsible Diagnostic Service.",
        "comment" : "If a DiagnosticReport.resultsInterpreter exists this is expected to be a Composition.author; otherwise a DiagnosticReport.performer should be an author.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
              "http://hl7.org/fhir/StructureDefinition/CareTeam"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.resultsInterpreter",
        "path" : "DiagnosticReport.resultsInterpreter",
        "comment" : "If a DiagnosticReport.resultsInterpreter exists this is expected to be a Composition.author; otherwise a DiagnosticReport.performer should be an author.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
              "http://hl7.org/fhir/StructureDefinition/CareTeam"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.specimen",
        "path" : "DiagnosticReport.specimen",
        "short" : "Specimens this report is based on.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result",
        "path" : "DiagnosticReport.result",
        "short" : "results",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.media",
        "path" : "DiagnosticReport.media",
        "short" : "Additional data (like images, diagrams or documents) associated with this report",
        "definition" : "A list of additional data, other then presented form of the report, associated with this report. This data is generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).",
        "requirements" : "Some diagnostic reports may include additional data such as images, diagrams or documents that are relevant to the report. This additional information can provide further context and support for the findings presented in the report.",
        "alias" : [
          "DICOM; Slides; Scans; Pictures; Documents; Diagrams",
          "Slides",
          "Scans"
        ]
      },
      {
        "id" : "DiagnosticReport.media.comment",
        "path" : "DiagnosticReport.media.comment",
        "short" : "Comment about the image or data (e.g. explanation)",
        "definition" : "Allows for a comment about the image or data, such as an explanation of its significance or context within the diagnostic report.",
        "requirements" : "The provider of the report should make a comment about each image or data included in the report. This comment can provide valuable context and help the reader understand the significance of the image or data in relation to the overall findings of the report."
      },
      {
        "id" : "DiagnosticReport.media.link",
        "path" : "DiagnosticReport.media.link",
        "short" : "Reference to the image or data",
        "definition" : "A reference to the image or data associated with this report."
      },
      {
        "id" : "DiagnosticReport.presentedForm",
        "path" : "DiagnosticReport.presentedForm",
        "short" : "Entire report as issued (pdf recommended)",
        "min" : 1
      }
    ]
  }
}

```
