# Composition: Obligations - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Composition: Obligations**

## Resource Profile: Composition: Obligations 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/cz-composition-obl-lab | *Version*:0.5.0 |
| Draft as of 2025-12-10 | *Computable Name*:CZ_CompositionObligationsLab |

 
This profile defines obligations for a composition in FHIR for the purpose of this guide. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/cz-composition-obl-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-composition-obl-lab.csv), [Excel](StructureDefinition-cz-composition-obl-lab.xlsx), [Schematron](StructureDefinition-cz-composition-obl-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-composition-obl-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/laboratory/StructureDefinition/Composition-eu-lab"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-composition-obl-lab",
  "version" : "0.5.0",
  "name" : "CZ_CompositionObligationsLab",
  "title" : "Composition: Obligations",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "This profile defines obligations for a composition in FHIR for the purpose of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-composition-lab-report",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition"
      },
      {
        "id" : "Composition.meta",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.meta"
      },
      {
        "id" : "Composition.language",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.language"
      },
      {
        "id" : "Composition.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.text"
      },
      {
        "id" : "Composition.extension:versionNumber",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.extension",
        "sliceName" : "versionNumber"
      },
      {
        "id" : "Composition.status",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.status"
      },
      {
        "id" : "Composition.type",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.type"
      },
      {
        "id" : "Composition.category",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.category"
      },
      {
        "id" : "Composition.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.subject"
      },
      {
        "id" : "Composition.date",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.date"
      },
      {
        "id" : "Composition.title",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.title"
      },
      {
        "id" : "Composition.confidentiality",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.confidentiality"
      },
      {
        "id" : "Composition.custodian",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L1"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.custodian"
      },
      {
        "id" : "Composition.section:lab-no-subsections",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "lab-no-subsections"
      },
      {
        "id" : "Composition.section:lab-subsections",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "lab-subsections"
      },
      {
        "id" : "Composition.section:annotations",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Composition.section",
        "sliceName" : "annotations"
      }
    ]
  }
}

```
