# Bundle - Laboratory Result Report - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle - Laboratory Result Report**

## Resource Profile: Bundle - Laboratory Result Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_BundleLab |
| **Copyright/Legal**: HL7 CZ | | |

 
This profile represents the constraints applied to the Bundle resource by the Czech national laboratory report FHIR Implementation Guide. 

 
Laboratory result report bundle is an electronic health record extract containing results of laboratory testing of specimens from a subject of care, comprising at least the required elements of the lab dataset. 

**Usages:**

* Derived from this Profile: [Bundle: Obligations](StructureDefinition-cz-bundle-obl-lab.md)
* Examples for this Profile: [Bundle/CZ-LabReport-Bundle-Example-Complex](Bundle-CZ-LabReport-Bundle-Example-Complex.md), [Bundle/CZ-LabReport-Bundle-Example-L1](Bundle-CZ-LabReport-Bundle-Example-L1.md), [Bundle/CZ-LabReport-Bundle-Example-Min](Bundle-CZ-LabReport-Bundle-Example-Min.md), [Bundle/CZ-LabReport-Bundle-Example-ObsTypes](Bundle-CZ-LabReport-Bundle-Example-ObsTypes.md)...Show 2 more,[Bundle/CZ-LabReport-Bundle-Example-kn](Bundle-CZ-LabReport-Bundle-Example-kn.md)and[Bundle/CZ-LabReport-Bundle-Example](Bundle-CZ-LabReport-Bundle-Example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/cz-bundle-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-bundle-lab.csv), [Excel](StructureDefinition-cz-bundle-lab.xlsx), [Schematron](StructureDefinition-cz-bundle-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-bundle-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/laboratory/StructureDefinition/Bundle-eu-lab"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab",
  "version" : "0.5.0",
  "name" : "CZ_BundleLab",
  "title" : "Bundle - Laboratory Result Report",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "This profile represents the constraints applied to the Bundle resource by the Czech national laboratory report FHIR Implementation Guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "Laboratory result report bundle is an electronic health record extract containing results of laboratory testing of specimens from a subject of care, comprising at least the required elements of the lab dataset.",
  "copyright" : "HL7 CZ",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "short" : "Laboratory Result Report Bundle",
        "definition" : "Laboratory Result Report Bundle. \r\nA container for a collection of resources in the laboratory result document.",
        "constraint" : [
          {
            "key" : "one-comp",
            "severity" : "error",
            "human" : "A laboratory report bundle SHALL include one and only one Composition",
            "expression" : "entry.resource.ofType(Composition).count() = 1",
            "source" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
          },
          {
            "key" : "one-dr",
            "severity" : "error",
            "human" : "A laboratory report SHALL include one and only one DiagnosticReport",
            "expression" : "entry.resource.ofType(DiagnosticReport).count() = 1",
            "source" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
          },
          {
            "key" : "dr-comp-identifier",
            "severity" : "error",
            "human" : "If one or more DiagnosticReport.identifiers are given, at least one of them SHALL be equal to the Composition.identifier",
            "expression" : "(entry.resource.ofType(Composition).identifier.exists() or entry.resource.ofType(DiagnosticReport).identifier.exists()) implies entry.resource.ofType(Composition).identifier.intersect(entry.resource.ofType(DiagnosticReport).identifier).exists()",
            "source" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
          },
          {
            "key" : "dr-comp-type",
            "severity" : "error",
            "human" : "At least one DiagnosticReport.code.coding and Composition.type.coding SHALL be equal",
            "expression" : "entry.resource.ofType(Composition).type.coding.intersect(entry.resource.ofType(DiagnosticReport).code.coding).exists()",
            "source" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
          },
          {
            "key" : "dr-comp-category",
            "severity" : "error",
            "human" : "At least one DiagnosticReport.category.coding and Composition.category.coding SHALL be equal",
            "expression" : "(entry.resource.ofType(Composition).category.exists() or entry.resource.ofType(DiagnosticReport).category.exists()) implies entry.resource.ofType(Composition).category.coding.intersect(entry.resource.ofType(DiagnosticReport).category.coding).exists()",
            "source" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
          },
          {
            "key" : "dr-comp-subj",
            "severity" : "error",
            "human" : "DiagnosticReport and Composition SHALL have the same subject",
            "expression" : "( (entry.resource.ofType(Composition).subject.empty() and entry.resource.ofType(DiagnosticReport).subject.empty() ) or entry.resource.ofType(Composition).subject = entry.resource.ofType(DiagnosticReport).subject )",
            "source" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
          },
          {
            "key" : "dr-comp-enc",
            "severity" : "error",
            "human" : "DiagnosticReport and Composition SHALL have the same encounter",
            "expression" : "( (entry.resource.ofType(Composition).encounter.empty() and entry.resource.ofType(DiagnosticReport).encounter.empty() ) or entry.resource.ofType(Composition).encounter = entry.resource.ofType(DiagnosticReport).encounter )",
            "source" : "https://hl7.cz/fhir/lab/StructureDefinition/cz-bundle-lab"
          }
        ]
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "short" : "Business identifier for this Laboratory Report",
        "min" : 1
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "patternCode" : "document"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "min" : 1
      },
      {
        "id" : "Bundle.total",
        "path" : "Bundle.total",
        "max" : "0"
      },
      {
        "id" : "Bundle.link",
        "path" : "Bundle.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 3
      },
      {
        "id" : "Bundle.entry.link",
        "path" : "Bundle.entry.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:composition",
        "path" : "Bundle.entry",
        "sliceName" : "composition",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:composition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-composition-lab-report"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:diagnosticReport",
        "path" : "Bundle.entry",
        "sliceName" : "diagnosticReport",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:diagnosticReport.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DiagnosticReport",
            "profile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-diagnostic-report-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-animal"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation",
        "path" : "Bundle.entry",
        "sliceName" : "observation",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:specimen",
        "path" : "Bundle.entry",
        "sliceName" : "specimen",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:specimen.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Specimen",
            "profile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-specimen-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:serviceRequest",
        "path" : "Bundle.entry",
        "sliceName" : "serviceRequest",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:serviceRequest.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "ServiceRequest",
            "profile" : [
              "https://hl7.cz/fhir/lab/StructureDefinition/cz-service-request-lab"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:organization.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitionerRole",
        "path" : "Bundle.entry",
        "sliceName" : "practitionerRole",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitionerRole.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "PractitionerRole",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:bodyStructure",
        "path" : "Bundle.entry",
        "sliceName" : "bodyStructure",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:bodyStructure.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "BodyStructure",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/BodyStructure-cz"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:encounter",
        "path" : "Bundle.entry",
        "sliceName" : "encounter",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:encounter.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Encounter",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-encounter"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:location",
        "path" : "Bundle.entry",
        "sliceName" : "location",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:location.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Location",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:provenance",
        "path" : "Bundle.entry",
        "sliceName" : "provenance",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:provenance.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Provenance",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-provenance"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:coverage",
        "path" : "Bundle.entry",
        "sliceName" : "coverage",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:coverage.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Coverage",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-coverage"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:device",
        "path" : "Bundle.entry",
        "sliceName" : "device",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:device.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Device",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:attachment",
        "path" : "Bundle.entry",
        "sliceName" : "attachment",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:attachment.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Media",
            "profile" : ["https://hl7.cz/fhir/lab/StructureDefinition/cz-attachment"]
          }
        ]
      },
      {
        "id" : "Bundle.signature",
        "path" : "Bundle.signature",
        "short" : "Digital Signature of this report"
      }
    ]
  }
}

```
