# A.1.1, A1.2 - Subject of care - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.1, A1.2 - Subject of care**

## Logical Model: A.1.1, A1.2 - Subject of care 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/SubjectCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnSubjectLabEhnCz |

 
Patient or Subject of care. Sections A1.1 and A1.2 of the eHN guideline. 

**Usages:**

* Use this Logical Model: [A - Laboratory Report](StructureDefinition-LabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/SubjectCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SubjectCz.csv), [Excel](StructureDefinition-SubjectCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SubjectCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/SubjectCz",
  "version" : "0.5.0",
  "name" : "LogEnSubjectLabEhnCz",
  "title" : "A.1.1, A1.2 - Subject of care",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Patient or Subject of care. Sections A1.1 and A1.2 of the eHN guideline.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/SubjectCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "SubjectCz",
        "path" : "SubjectCz",
        "short" : "A.1.1, A1.2 - Subject of care",
        "definition" : "Patient or Subject of care. Sections A1.1 and A1.2 of the eHN guideline."
      },
      {
        "id" : "SubjectCz.identification",
        "path" : "SubjectCz.identification",
        "short" : "A.1.1 Identification of the patient/subject",
        "definition" : "A.1.1 Identification of the patient/subject",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SubjectCz.identification.givenName",
        "path" : "SubjectCz.identification.givenName",
        "short" : "A.1.1.1 Given name",
        "definition" : "The given name/first name of the patient (also known as forename or first name). This field can contain more than one element. ",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SubjectCz.identification.familyName",
        "path" : "SubjectCz.identification.familyName",
        "short" : "A.1.1.2 Familyname/surname",
        "definition" : "The family name/surname/last name of the patient. This field can contain more than one element or multiple fields could be present.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SubjectCz.identification.dateOfBirth",
        "path" : "SubjectCz.identification.dateOfBirth",
        "short" : "A.1.1.3 Date of birth",
        "definition" : "The date  if applicable, time of birth of the patient [ISO TS 22220]. As age of the patient might be important for correct interpretation of the test result values, complete date of birth should be provided. \n- Preferred system(s): Complete date following the ISO 8601 ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "SubjectCz.identification.identifier",
        "path" : "SubjectCz.identification.identifier",
        "short" : "A.1.1.4 Patient identifier",
        "definition" : "An identifier of the patient that is unique within a defined scope. At least one national or international identifier is mandatory (birth number, passport number, etc.). Multiple identifiers could be provided. ",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SubjectCz.identification.citizenship",
        "path" : "SubjectCz.identification.citizenship",
        "short" : "A.1.1.5 Citizenship",
        "definition" : "Citizenship according to Act No. 186/2013. Citizenship as stated on official documents for identity verification.\n- Preferred system(s): eHDSICountry (ISO 3166)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SubjectCz.identification.gender",
        "path" : "SubjectCz.identification.gender",
        "short" : "A.1.1.6 Gender",
        "definition" : "This field must contain a recognised valid value for 'administrative gender'. \nIf different, 'physiological gender' should be communicated elsewhere\n- Preferred system(s): HL7 Administrative Gender ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SubjectCz.identification.languageOfCommunication",
        "path" : "SubjectCz.identification.languageOfCommunication",
        "short" : "A.1.1.7 Language of communication",
        "definition" : "Language(s) in which the patient communicates\n- Preferred system(s): NCLP EJAZYK",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo",
        "path" : "SubjectCz.contactInfo",
        "short" : "A.1.2 Patient/subject related contact information",
        "definition" : "A.1.2 Patient/subject related contact information",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.address",
        "path" : "SubjectCz.contactInfo.address",
        "short" : "A.1.2.1 Address",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, ZIP code, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose. - Preferred system(s):  eHDSICountry (ISO 3166)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.telecom",
        "path" : "SubjectCz.contactInfo.telecom",
        "short" : "A.1.2.2 Telecom",
        "definition" : "Telecommunication contact information (e-mail, phone number, etc.) associated to a person. Multiple telecommunication addresses might be provided. - Preferred system(s): ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.preferedPhysician",
        "path" : "SubjectCz.contactInfo.preferedPhysician",
        "short" : "A.1.2.3 Prefered physician",
        "definition" : "The registering general practitioner or another physician who can provide information about the patient. Particularly important for patients with rare diseases.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.preferedPhysician.Identifier",
        "path" : "SubjectCz.contactInfo.preferedPhysician.Identifier",
        "short" : "A.1.2.3.1 Identification of the prefered physician",
        "definition" : "Identification number of the health care professional according to the National Register of Health Care Professionals (NRZP).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.preferedPhysician.Name",
        "path" : "SubjectCz.contactInfo.preferedPhysician.Name",
        "short" : "A.1.2.3.2 Name of the prefered physician",
        "definition" : "The name of the physician with whom the patient is under the care of or who is registering the patient.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.preferedPhysician.Specialization",
        "path" : "SubjectCz.contactInfo.preferedPhysician.Specialization",
        "short" : "A.1.2.3.3 Specialization of the prefered physician",
        "definition" : "Specialization of the doctor (Practical medicine for children and adolescents, General medicine for adults, internal medicine, gynaecology and obstetrics, etc.)\n- Preferred system(s): NR-ZP Specializace lékařů",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.preferedPhysician.providerIdentifierName",
        "path" : "SubjectCz.contactInfo.preferedPhysician.providerIdentifierName",
        "short" : "A.1.2.3.4 Identification and name of the provider the doctor represents",
        "definition" : "Identifier (IČO, NRPZS) and name of the provider the doctor represents",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.preferedPhysician.providerAddress",
        "path" : "SubjectCz.contactInfo.preferedPhysician.providerAddress",
        "short" : "A.1.2.3.5 Provider address",
        "definition" : "Mailing, home and/or office address. Addresses are always a sequence of parts of an address (e.g. address line, country, zip code, city), although the format of the postal address may vary depending on the country. The address may contain information about the type of address; if this attribute is not present, it is assumed to be a default address usable for any purpose.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.preferedPhysician.telecom",
        "path" : "SubjectCz.contactInfo.preferedPhysician.telecom",
        "short" : "A.1.2.3.6 Telecom",
        "definition" : "Telecommunication contact (e-mail, phone, etc.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.legalRepresent",
        "path" : "SubjectCz.contactInfo.legalRepresent",
        "short" : "A.1.2.4 Legal representatives and other contact persons",
        "definition" : "A.1.2.4 Legal representatives and other contact persons",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.legalRepresent.type",
        "path" : "SubjectCz.contactInfo.legalRepresent.type",
        "short" : "A.1.2.4.1 Contact type",
        "definition" : "Type of contact person distinguishing emergent contacts, legal guardians and other persons with a relationship to the patient.\n- Preferred system(s): HL7 Role",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.legalRepresent.relationToSubject",
        "path" : "SubjectCz.contactInfo.legalRepresent.relationToSubject",
        "short" : "A.1.2.4.2 Relationship to the patient",
        "definition" : "Relationship of the person to the patient (father, son, daughter, etc.).\n- Preferred system(s): eHDSIPersonalRelationship",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.legalRepresent.identifier",
        "path" : "SubjectCz.contactInfo.legalRepresent.identifier",
        "short" : "A.1.2.4.3 Person identifier",
        "definition" : "An identifier of the patient that is unique within a defined scope (birth number, passport number, etc.). Multiple identifiers could be provided. ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.legalRepresent.givenName",
        "path" : "SubjectCz.contactInfo.legalRepresent.givenName",
        "short" : "A.1.2.4.4 Given name",
        "definition" : "The given name/first name of the person (also known as forename or first name).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.legalRepresent.familyName",
        "path" : "SubjectCz.contactInfo.legalRepresent.familyName",
        "short" : "A.1.2.4.5 Family name/surname",
        "definition" : "The family name/surname/last name of the person.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.legalRepresent.address",
        "path" : "SubjectCz.contactInfo.legalRepresent.address",
        "short" : "A.1.2.4.6 Contact person address",
        "definition" : "Mailing, home and/or office address. Addresses are always a sequence of parts of an address (e.g. address line, country, zip code, city), although the format of the postal address may vary depending on the country. The address may contain information about the type of address; if this attribute is not present, it is assumed to be a default address usable for any purpose.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "SubjectCz.contactInfo.legalRepresent.telecom",
        "path" : "SubjectCz.contactInfo.legalRepresent.telecom",
        "short" : "A.1.2.4.7 Telecom",
        "definition" : "Telecommunication contact (e-mail, phone, etc.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      }
    ]
  }
}

```
