# A.2.4 - Results data elements - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.4 - Results data elements**

## Logical Model: A.2.4 - Results data elements 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/ResultCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnResultLabEhnCz |

 
Results data elements. Section A5 of the eHN guideline. 

**Usages:**

* Use this Logical Model: [A - Laboratory Report](StructureDefinition-LabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/ResultCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ResultCz.csv), [Excel](StructureDefinition-ResultCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ResultCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/ResultCz",
  "version" : "0.5.0",
  "name" : "LogEnResultLabEhnCz",
  "title" : "A.2.4 - Results data elements",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Results data elements. Section A5 of the eHN guideline.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/ResultCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ResultCz",
        "path" : "ResultCz",
        "short" : "A.2.4 - Results data elements",
        "definition" : "Results data elements. Section A5 of the eHN guideline."
      },
      {
        "id" : "ResultCz.narrative",
        "path" : "ResultCz.narrative",
        "short" : "A.2.4.1 Laboratory report narrative",
        "definition" : "A.2.4.1 Laboratory report narrative",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ResultCz.narrative.report",
        "path" : "ResultCz.narrative.report",
        "short" : "A.2.4.1.1 Narrative report",
        "definition" : "Entire report (textual summary inside the laboratory result report document) as issued by the laboratory.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Narrative"
          }
        ]
      },
      {
        "id" : "ResultCz.narrative.notes",
        "path" : "ResultCz.narrative.notes",
        "short" : "A.2.4.1.2 Comments, interpretation and recommendations",
        "definition" : "Comments, such as a textual interpretation or advice accompanying the result report, for example.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Narrative"
          }
        ]
      },
      {
        "id" : "ResultCz.observation",
        "path" : "ResultCz.observation",
        "short" : "A.2.4.2 Observation details",
        "definition" : "A.2.4.2 Observation details (report could consist of multiple observations) ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.dateTime",
        "path" : "ResultCz.observation.dateTime",
        "short" : "A.2.4.2.1 Observation date",
        "definition" : "Date and time of the observation - Preferred system(s): ISO 8601",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.code",
        "path" : "ResultCz.observation.code",
        "short" : "A.2.4.2.2 Observation code",
        "definition" : "Code representing the observation using the agreed code systems.\n- Preferred system(s): NČLP",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.code.name",
        "path" : "ResultCz.observation.code.name",
        "short" : "A.2.4.2.3 Observation name",
        "definition" : "Full name of the observation according to the used test coding standard.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.method",
        "path" : "ResultCz.observation.method",
        "short" : "A.2.4.2.4 Observation method",
        "definition" : "Observation method (measurement principle) to obtain the result.\n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.device",
        "path" : "ResultCz.observation.device",
        "short" : "A.2.4.2.5 Observation device",
        "definition" : "Device (analyser), laboratory test kit and used calibrator information (identifier, type, name, model, manufacturer)\n- Preferred system(s): SNOMED CT\n- Preferred system(s): EMDN",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.testKit",
        "path" : "ResultCz.observation.testKit",
        "short" : "A.2.4.2.6 Test kit",
        "definition" : "Information about the test kit used – ID, type, name, manufacturer",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.calibrator",
        "path" : "ResultCz.observation.calibrator",
        "short" : "A.2.4.2.7 Calibrator",
        "definition" : "Information about the calibrator used (unless it is a basic unit of measurement, e.g. IU) - ID, type, name, manufacturer",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.order",
        "path" : "ResultCz.observation.order",
        "short" : "A.2.4.2.8 Order",
        "definition" : "Identifies order and order placer this observation belongs to.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.performer",
        "path" : "ResultCz.observation.performer",
        "short" : "A.2.4.2.9 Performer",
        "definition" : "Identifies the originator/author and provides provenance information about the source of the results data that may have not originated with the source of the whole Laboratory Report document. ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.reporter",
        "path" : "ResultCz.observation.reporter",
        "short" : "A.2.4.2.10 Reporter",
        "definition" : "With certain observation results, e.g. there may also be an interpreter or a person responsible for validation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.result",
        "path" : "ResultCz.observation.result",
        "short" : "A.2.4.2.11 Observation result",
        "definition" : "Result of the observation including text, numeric and coded results of the measurement and measurement uncertainty. Content of the observation result will vary according to the type of the observation. \n- Preferred system(s): SNOMED CT (for ordinal or nominal scale results and result interpretation)\n- Preferred system(s): UCUM (for units)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.interpretation",
        "path" : "ResultCz.observation.interpretation",
        "short" : "A.2.4.2.12 Observation interpretation",
        "definition" : "Information about reference intervals and result interpretation.\n - Preferred system(s): SNOMED CT",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.description",
        "path" : "ResultCz.observation.description",
        "short" : "A.2.4.2.13 Result description",
        "definition" : "Comments and narrative representation of the observation result and findings.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Narrative"
          }
        ]
      },
      {
        "id" : "ResultCz.observation.accreditationStatus",
        "path" : "ResultCz.observation.accreditationStatus",
        "short" : "A.2.4.2.14 Accreditation status",
        "definition" : "Accreditation status of the laboratory for the particular observation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
