# A.2.1, A.2.2 - Order - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.1, A.2.2 - Order**

## Logical Model: A.2.1, A.2.2 - Order 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/OrderCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnOrderLabEhnCz |

 
Order information and reason. Sections A2 and A3 of the eHN guideline. 

**Usages:**

* Use this Logical Model: [A - Laboratory Report](StructureDefinition-LabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/OrderCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-OrderCz.csv), [Excel](StructureDefinition-OrderCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "OrderCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/OrderCz",
  "version" : "0.5.0",
  "name" : "LogEnOrderLabEhnCz",
  "title" : "A.2.1, A.2.2 - Order",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Order information and reason. Sections A2 and A3 of the eHN guideline.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/OrderCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "OrderCz",
        "path" : "OrderCz",
        "short" : "A.2.1, A.2.2 - Order",
        "definition" : "Order information and reason. Sections A2 and A3 of the eHN guideline."
      },
      {
        "id" : "OrderCz.orderDetails",
        "path" : "OrderCz.orderDetails",
        "short" : "A.2.1 Order information",
        "definition" : "A.2 Order information (Laboratory Result Report could respond to multiple test orders) ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OrderCz.orderDetails.identifier",
        "path" : "OrderCz.orderDetails.identifier",
        "short" : "A.2.1.1 Order Id",
        "definition" : "An identifier of the laboratory test order. Laboratory Result Report may respond to multiple orders.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "OrderCz.orderDetails.dateTime",
        "path" : "OrderCz.orderDetails.dateTime",
        "short" : "A.2.1.2 Order date and time",
        "definition" : "Date and time of the order placement.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "OrderCz.orderDetails.orderPlacerIdentifier",
        "path" : "OrderCz.orderDetails.orderPlacerIdentifier",
        "short" : "A.2.1.3 Order placer identifier",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the license or registration number. In case the order placer is not a health professional, e.g. by patients themselves where applicable, an appropriate personal identifier should be used. ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "OrderCz.orderDetails.orderPlacerName",
        "path" : "OrderCz.orderDetails.orderPlacerName",
        "short" : "A.2.1.4 Order placer name",
        "definition" : "Person name.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "OrderCz.orderDetails.orderPlacerContacts",
        "path" : "OrderCz.orderDetails.orderPlacerContacts",
        "short" : "A.2.1.5 Order placer contact details",
        "definition" : "Contact details of order placer (address and telecom details).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OrderCz.orderDetails.orderPlacerOrganization",
        "path" : "OrderCz.orderDetails.orderPlacerOrganization",
        "short" : "A.2.1.6 Order placer organization",
        "definition" : "Order placer organization information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "OrderCz.reason",
        "path" : "OrderCz.reason",
        "short" : "A.2.2 Order reason",
        "definition" : "A.2.2 Order reason (Laboratory Result Report could respond to multiple reasons) ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "OrderCz.reason.code",
        "path" : "OrderCz.reason.code",
        "short" : "A.2.2.1 Problem / diagnosis / condition description",
        "definition" : "Health conditions affecting the health of the patient and are important to be known for a health professional during a health encounter. Clinical conditions of the subject relevant for the results interpretation.\n- Preferred system(s): MKN-10\n- Preferred system(s): Orphacode",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
