# A.2.1, A.2.2 - Objednávka - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.1, A.2.2 - Objednávka**

## Logical Model: A.2.1, A.2.2 - Objednávka 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LogOrderCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzOrderLabEhnCz |

 
Objednávka 

**Usages:**

* Use this Logical Model: [A - Laboratorní zpráva](StructureDefinition-LogLabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LogOrderCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogOrderCz.csv), [Excel](StructureDefinition-LogOrderCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogOrderCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LogOrderCz",
  "version" : "0.5.0",
  "name" : "LogCzOrderLabEhnCz",
  "title" : "A.2.1, A.2.2 - Objednávka",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Objednávka",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LogOrderCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogOrderCz",
        "path" : "LogOrderCz",
        "short" : "A.2.1, A.2.2 - Objednávka",
        "definition" : "Objednávka"
      },
      {
        "id" : "LogOrderCz.detailyObjednavky",
        "path" : "LogOrderCz.detailyObjednavky",
        "short" : "A.2.1 Informace o objednávce",
        "definition" : "A.2 Výsledková listina může odpovídat více objednávkám",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogOrderCz.detailyObjednavky.id",
        "path" : "LogOrderCz.detailyObjednavky.id",
        "short" : "A.2.1.1 ID objednávky",
        "definition" : "Identifikátor objednávky laboratorního vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogOrderCz.detailyObjednavky.datumAcas",
        "path" : "LogOrderCz.detailyObjednavky.datumAcas",
        "short" : "A.2.1.2 Datum a čas objednávky",
        "definition" : "Datum a čas zadání objednávky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogOrderCz.detailyObjednavky.idZadavatele",
        "path" : "LogOrderCz.detailyObjednavky.idZadavatele",
        "short" : "A.2.1.3 Identifikátor zadavatele objednávky",
        "definition" : "Identifikační číslo zdravotnického pracovníka - jedná se buď o interní identifikátor přidělený provozovatelem zdravotní péče nebo (nejlépe) národní ID zdravotnického pracovníka jako například licence nebo registrační číslo. V případě, že není objednávka zadána zdravotnickým pracovníkem ale například samotným pacientem, měl by být použit vhodný osobní identifikátor.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogOrderCz.detailyObjednavky.jmenoZadavatele",
        "path" : "LogOrderCz.detailyObjednavky.jmenoZadavatele",
        "short" : "A.2.1.4 Jméno zadavatele objednávky",
        "definition" : "Jméno osoby.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogOrderCz.detailyObjednavky.kontaktyZadavatele",
        "path" : "LogOrderCz.detailyObjednavky.kontaktyZadavatele",
        "short" : "A.2.1.5 Kontaktní údaje zadavatele objednávky",
        "definition" : "Kontaktní údaje zadavatele objednávky (adresa a telekomunikační údaje).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogOrderCz.detailyObjednavky.organizaceZadavatele",
        "path" : "LogOrderCz.detailyObjednavky.organizaceZadavatele",
        "short" : "A.2.1.6 Organizace zadavatele objednávky",
        "definition" : "Organizace zadavatele objednávky (poskytovatel zdravotních služeb).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "LogOrderCz.duvodObjednavky",
        "path" : "LogOrderCz.duvodObjednavky",
        "short" : "A.2.2 Důvod objednávky",
        "definition" : "A.2.2 Důvod objednávky",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogOrderCz.duvodObjednavky.kod",
        "path" : "LogOrderCz.duvodObjednavky.kod",
        "short" : "A.2.2.1 Popis problému / diagnózy / stavu",
        "definition" : "Okolnosti zdravotního stavu pacienta, které ovlivňují jeho zdraví a znalost kterých je zásadní pro práci zdravotnického pracovníka během kontaktu s pacientem. Klinický stav subjektu relevantní pro interpretaci výsledků.\n- Preferované systémy: MKN-10\n- Preferované systémy: Orphacode",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
