# A - Laboratorní zpráva - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A - Laboratorní zpráva**

## Logical Model: A - Laboratorní zpráva 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LogLabReportCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzLabReportEhnCz |

 
Zpráva z laboratorního vyšetření 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LogLabReportCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogLabReportCz.csv), [Excel](StructureDefinition-LogLabReportCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogLabReportCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LogLabReportCz",
  "version" : "0.5.0",
  "name" : "LogCzLabReportEhnCz",
  "title" : "A - Laboratorní zpráva",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Zpráva z laboratorního vyšetření",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LogLabReportCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogLabReportCz",
        "path" : "LogLabReportCz",
        "short" : "A - Laboratorní zpráva",
        "definition" : "Zpráva z laboratorního vyšetření"
      },
      {
        "id" : "LogLabReportCz.hlavicka",
        "path" : "LogLabReportCz.hlavicka",
        "short" : "A.1 Hlavička dokumentu",
        "definition" : "A.1 Záhlaví dokumentu s administrativními údaji",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.pacient",
        "path" : "LogLabReportCz.hlavicka.pacient",
        "short" : "A.1.1 - A1.2 Pacient/subjekt",
        "definition" : "A.1.1 Identifikace pacienta and A.1.2 Kontaktní informace pacienta",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/LogSubjectCz"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.zdravotniPojisteni",
        "path" : "LogLabReportCz.hlavicka.zdravotniPojisteni",
        "short" : "A.1.3 Zdravotní pojištění",
        "definition" : "A.1.3 Informace o zdravotním pojištění",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/LogPayerCz"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.prijemce",
        "path" : "LogLabReportCz.hlavicka.prijemce",
        "short" : "A.1.4 Příjemce dokumentu",
        "definition" : "A.1.4 Informace o zamýšleném příjemci dokumentu",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/LogRecipientCz"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.autor",
        "path" : "LogLabReportCz.hlavicka.autor",
        "short" : "A.1.5 Autor dokumentu",
        "definition" : "A.1.5 Autor dokumentu dle zákona 372/2011 §54 odst. (3)",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/LogAuthorCz"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.overil",
        "path" : "LogLabReportCz.hlavicka.overil",
        "short" : "A.1.6 Ověřil",
        "definition" : "A.1.7 Ověřil",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/LogValidatorCz"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.zodpovida",
        "path" : "LogLabReportCz.hlavicka.zodpovida",
        "short" : "A.1.7 Zodpovídá",
        "definition" : "A.1.7 Zodpovídá",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/LogLegalAuthenticatorCz"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.metadata",
        "path" : "LogLabReportCz.hlavicka.metadata",
        "short" : "A.1.8 Metadata dokumentu",
        "definition" : "A.1.8 Metadata dokumentu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.metadata.id",
        "path" : "LogLabReportCz.hlavicka.metadata.id",
        "short" : "A.1.8.1 ID dokumentu",
        "definition" : "Identifikátor dokumentu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.metadata.typ",
        "path" : "LogLabReportCz.hlavicka.metadata.typ",
        "short" : "A.1.8.2 Kategorie dokumentu",
        "definition" : "Kategorie elektronického zdravotního záznamu (EHR).\n- Preferované systémy: LOINC",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.metadata.status",
        "path" : "LogLabReportCz.hlavicka.metadata.status",
        "short" : "A.1.8.3 Stav dokumentu",
        "definition" : "Stav dokumentu (předběžný, finální, doplněný, opravený atp.)\n- Preferované systémy: hl7:DiagnosticReportStatus",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.metadata.datumAcas",
        "path" : "LogLabReportCz.hlavicka.metadata.datumAcas",
        "short" : "A.1.8.4 Datum a čas vytvoření",
        "definition" : "Datum a čas vytvoření dokumentu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.metadata.titulek",
        "path" : "LogLabReportCz.hlavicka.metadata.titulek",
        "short" : "A.1.8.5 Název dokumentu",
        "definition" : "Název dokumentu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.metadata.spravce",
        "path" : "LogLabReportCz.hlavicka.metadata.spravce",
        "short" : "A.1.8.6 Správce dokumentu",
        "definition" : "Název a identifikační údaje subjektu, který dokument spravuje. Alias technický správce dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.metadata.duvernost",
        "path" : "LogLabReportCz.hlavicka.metadata.duvernost",
        "short" : "A.1.8.7 Důvěrnost dokumentu",
        "definition" : "Stupeň důvěrnosti dokumentu (a jeho obsahu).\n- Preferované systémy: hl7:Confidentiality",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.metadata.jazyk",
        "path" : "LogLabReportCz.hlavicka.metadata.jazyk",
        "short" : "A.1.8.8 Jazyk dokumentu",
        "definition" : "Jazyk, v němž je dokument napsán (narativní část dokumentu).\n- Preferované systémy:  NCLP EJAZYK",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.metadata.verze",
        "path" : "LogLabReportCz.hlavicka.metadata.verze",
        "short" : "A.1.8.9 Verze",
        "definition" : "Verze dokumentu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.hlavicka.elektronickePodpisy",
        "path" : "LogLabReportCz.hlavicka.elektronickePodpisy",
        "short" : "A.1.9 Elektronické podpisy",
        "definition" : "dle zákona 327/2011 §54a",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.telo",
        "path" : "LogLabReportCz.telo",
        "short" : "A.2 Tělo dokumentu",
        "definition" : "A.2 Tělo dokumentu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.telo.objednavka",
        "path" : "LogLabReportCz.telo.objednavka",
        "short" : "A.2.1-A.2.2 Objednávka",
        "definition" : "A.2.1 Informace o objednávce, A.2.2 Důvod objednávky",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/LogOrderCz"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.telo.vzorek",
        "path" : "LogLabReportCz.telo.vzorek",
        "short" : "A.2.3 Informace o vzorku",
        "definition" : "A.2.3 Informace o vzorku",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/LogSpecimenLabCz"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.telo.vysledek",
        "path" : "LogLabReportCz.telo.vysledek",
        "short" : "A.2.4 Datové elementy výsledku vyšetření",
        "definition" : "A.2.4 Datové elementy výsledku vyšetření",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/LogResultCz"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.presentedForm",
        "path" : "LogLabReportCz.presentedForm",
        "short" : "A.3 - Vizuální podoba dokumentu",
        "definition" : "Zpráva čitelná lidským okem, je požadován PDF formát.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/LogPresentedFormCz"
          }
        ]
      },
      {
        "id" : "LogLabReportCz.attachments",
        "path" : "LogLabReportCz.attachments",
        "short" : "A.4 - Přílohy",
        "definition" : "Ostatní přílohy",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/lab/StructureDefinition/LogAttachmentsCz"
          }
        ]
      }
    ]
  }
}

```
