# A.1.9 - Electronic signatures - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.9 - Electronic signatures**

## Logical Model: A.1.9 - Electronic signatures 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LogElectronicSignatures | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzElectronicSignaturesLabEhnCz |

 
Electronic signatures According to Act No. 327/2011, §54a Section A1.7 of the eHN guideline. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LogElectronicSignatures)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogElectronicSignatures.csv), [Excel](StructureDefinition-LogElectronicSignatures.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogElectronicSignatures",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LogElectronicSignatures",
  "version" : "0.5.0",
  "name" : "LogCzElectronicSignaturesLabEhnCz",
  "title" : "A.1.9 - Electronic signatures",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Electronic signatures According to Act No. 327/2011, §54a\nSection A1.7 of the eHN guideline.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LogElectronicSignatures",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogElectronicSignatures",
        "path" : "LogElectronicSignatures",
        "short" : "A.1.9 - Electronic signatures",
        "definition" : "Electronic signatures According to Act No. 327/2011, §54a\nSection A1.7 of the eHN guideline."
      },
      {
        "id" : "LogElectronicSignatures.elektronickyPodpis",
        "path" : "LogElectronicSignatures.elektronickyPodpis",
        "short" : "A.1.9.1 - Elektronický podpis",
        "definition" : "Elektronický podpis nebo pečeť dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Signature"
          }
        ]
      },
      {
        "id" : "LogElectronicSignatures.casoveRazitko",
        "path" : "LogElectronicSignatures.casoveRazitko",
        "short" : "A.1.9.2 - Elektronické časové razítko",
        "definition" : "Elektronické časové razítko ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      }
    ]
  }
}

```
