# A.1.5 - Autor dokumentu - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.5 - Autor dokumentu**

## Logical Model: A.1.5 - Autor dokumentu 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LogAuthorCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzAuthorLabEhnCz |

 
Autor dokumentu dle zákona 372/2011 §54 odst. (3) 

**Usages:**

* Use this Logical Model: [A - Laboratorní zpráva](StructureDefinition-LogLabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LogAuthorCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogAuthorCz.csv), [Excel](StructureDefinition-LogAuthorCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogAuthorCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LogAuthorCz",
  "version" : "0.5.0",
  "name" : "LogCzAuthorLabEhnCz",
  "title" : "A.1.5 - Autor dokumentu",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Autor dokumentu dle zákona 372/2011 §54 odst. (3)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LogAuthorCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogAuthorCz",
        "path" : "LogAuthorCz",
        "short" : "A.1.5 - Autor dokumentu",
        "definition" : "Autor dokumentu dle zákona 372/2011 §54 odst. (3)"
      },
      {
        "id" : "LogAuthorCz.id",
        "path" : "LogAuthorCz.id",
        "short" : "A.1.5.1 Identifikátor autora",
        "definition" : "Identifikační číslo zdravotnického pracovníka (nebo informačního systému), který provedl zápis do zdravotnické dokumentace. Buď interní identifikátor přidělený institucí poskytovatele zdravotní péče, nebo (nejlépe) národní ID zdravotnického pracovníka, jako je číslo licence nebo registrační číslo.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogAuthorCz.jmeno",
        "path" : "LogAuthorCz.jmeno",
        "short" : "A.1.5.2 Jméno autora",
        "definition" : "Jméno autora či informačního systému (např. software, který dokument automatizovaně sestavil)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogAuthorCz.idOrganizace",
        "path" : "LogAuthorCz.idOrganizace",
        "short" : "A.1.5.3 ID organizace",
        "definition" : "Identifikátor organizace, kterou autor reprezentuje",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogAuthorCz.organizace",
        "path" : "LogAuthorCz.organizace",
        "short" : "A.1.5.4 Organizace autora",
        "definition" : "Název a identifikační údaje zdravotnického zařízení které je reprezentováno autorem dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "LogAuthorCz.datumUlozeni",
        "path" : "LogAuthorCz.datumUlozeni",
        "short" : "A.1.5.5 Datum a čas uložení",
        "definition" : "Datum a čas poslední modifikace dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
