# A.1.7 - Legal authenticator - HL7 CZ Laboratory IG v0.5.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.7 - Legal authenticator**

## Logical Model: A.1.7 - Legal authenticator 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/lab/StructureDefinition/LegalAuthenticatorCz | *Version*:0.5.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnLegalAuthenticatorLabEhnCz |

 
Legal authenticator (The person taking responsibility for the medical content of the document). Section A1.7 of the eHN guideline. 

**Usages:**

* Use this Logical Model: [A - Laboratory Report](StructureDefinition-LabReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.lab|current/StructureDefinition/LegalAuthenticatorCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LegalAuthenticatorCz.csv), [Excel](StructureDefinition-LegalAuthenticatorCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LegalAuthenticatorCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/lab/StructureDefinition/LegalAuthenticatorCz",
  "version" : "0.5.0",
  "name" : "LogEnLegalAuthenticatorLabEhnCz",
  "title" : "A.1.7 - Legal authenticator",
  "status" : "draft",
  "date" : "2025-12-10T22:15:30+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.cz"
        }
      ]
    }
  ],
  "description" : "Legal authenticator (The person taking responsibility for the medical content of the document).\nSection A1.7 of the eHN guideline.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/lab/StructureDefinition/LegalAuthenticatorCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LegalAuthenticatorCz",
        "path" : "LegalAuthenticatorCz",
        "short" : "A.1.7 - Legal authenticator",
        "definition" : "Legal authenticator (The person taking responsibility for the medical content of the document).\nSection A1.7 of the eHN guideline."
      },
      {
        "id" : "LegalAuthenticatorCz.identifier",
        "path" : "LegalAuthenticatorCz.identifier",
        "short" : "A.1.7.1 Legal authenticator identifier",
        "definition" : "Identification number of the healthcare professional responsible for the overall content of the document. Either an internal identifier assigned by the health care provider's institution or (preferably) a national health professional ID such as a license or registration number. The chief medical officer or head of department who is responsible for the discharge report as a whole. May be the same as the certifying officer. ",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LegalAuthenticatorCz.name",
        "path" : "LegalAuthenticatorCz.name",
        "short" : "A.1.7.2 Legal authenticator name",
        "definition" : "Full name and identification of the person responsible for the content of the document.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LegalAuthenticatorCz.organization",
        "path" : "LegalAuthenticatorCz.organization",
        "short" : "A.1.7.3 Legal authenticator organization",
        "definition" : "The name and identification details of the healthcare facility represented by the person responsible for the content of the document.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "LegalAuthenticatorCz.dateTime",
        "path" : "LegalAuthenticatorCz.dateTime",
        "short" : "A.1.7.4 Authentication date and time",
        "definition" : "Date and time when the document was authorized.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
